/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentSchedule;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.exception.AxelorException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Set;

public interface PaymentScheduleService {
    public PaymentSchedule createPaymentSchedule(Partner var1, Company var2, Set<Invoice> var3, LocalDate var4, int var5) throws AxelorException;

    public PaymentSchedule createPaymentSchedule(Partner var1, Invoice var2, Company var3, LocalDate var4, LocalDate var5, int var6, BankDetails var7, PaymentMode var8) throws AxelorException;

    public String getPaymentScheduleSequence(Company var1) throws AxelorException;

    public BigDecimal getInvoiceTermTotal(PaymentSchedule var1);

    public void updatePaymentSchedule(PaymentSchedule var1, BigDecimal var2);

    public PaymentSchedule createPaymentSchedule(Partner var1, Company var2, LocalDate var3, LocalDate var4, BigDecimal var5, int var6, BankDetails var7, PaymentMode var8) throws AxelorException;

    public List<MoveLine> getPaymentSchedulerMoveLineToPay(PaymentSchedule var1);

    public void validatePaymentSchedule(PaymentSchedule var1) throws AxelorException;

    public void updateInvoices(PaymentSchedule var1);

    public void updateInvoice(Invoice var1, PaymentSchedule var2);

    public void cancelPaymentSchedule(PaymentSchedule var1);

    public boolean isLastSchedule(PaymentScheduleLine var1);

    public void closePaymentSchedule(PaymentSchedule var1) throws AxelorException;

    public void closePaymentScheduleIfAllPaid(PaymentSchedule var1) throws AxelorException;

    public LocalDate getMostOldDatePaymentScheduleLine(List<PaymentScheduleLine> var1);

    public LocalDate getMostRecentDatePaymentScheduleLine(List<PaymentScheduleLine> var1);

    public void createPaymentScheduleLines(PaymentSchedule var1);

    public void initCollection(PaymentSchedule var1);

    public void toCancelPaymentSchedule(PaymentSchedule var1);

    public BankDetails getBankDetails(PaymentSchedule var1) throws AxelorException;

    public void checkTotalLineAmount(PaymentSchedule var1) throws AxelorException;

    public int getNextScheduleLineSeq(PaymentSchedule var1);
}

