/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.PeriodServiceAccount;
import com.axelor.apps.account.service.move.MoveValidateService;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.repo.PeriodRepository;
import com.axelor.apps.base.service.AdjustHistoryService;
import com.axelor.apps.base.service.PeriodServiceImpl;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PeriodServiceAccountImpl
extends PeriodServiceImpl
implements PeriodServiceAccount {
    protected MoveValidateService moveValidateService;
    protected MoveRepository moveRepository;

    @Inject
    public PeriodServiceAccountImpl(PeriodRepository periodRepo, AdjustHistoryService adjustHistoryService, MoveValidateService moveValidateService, MoveRepository moveRepository) {
        super(periodRepo, adjustHistoryService);
        this.moveValidateService = moveValidateService;
        this.moveRepository = moveRepository;
    }

    public void close(Period period) throws AxelorException {
        if (period.getYear().getTypeSelect() == 1) {
            this.moveValidateService.validateMultiple(this.getMoveListToValidateQuery(period));
            period = (Period)this.periodRepo.find(period.getId());
        }
        super.close(period);
    }

    @Override
    public Query<Move> getMoveListToValidateQuery(Period period) {
        return this.moveRepository.all().filter("self.period.id = ?1 AND (self.statusSelect NOT IN (?2,?3, ?4) OR (self.statusSelect = ?2 AND (self.archived = false OR self.archived is null)))", new Object[]{period.getId(), 1, 3, 4}).order("date").order("id");
    }
}

