/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.base.db.Partner;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.List;

public interface ReconcileService {
    @Transactional
    public Reconcile createReconcile(MoveLine var1, MoveLine var2, BigDecimal var3, boolean var4);

    @Transactional(rollbackOn={Exception.class})
    public Reconcile confirmReconcile(Reconcile var1, boolean var2) throws AxelorException;

    public void reconcilePreconditions(Reconcile var1) throws AxelorException;

    public void updatePartnerAccountingSituation(Reconcile var1) throws AxelorException;

    public List<Partner> getPartners(Reconcile var1);

    public Reconcile reconcile(MoveLine var1, MoveLine var2, boolean var3, boolean var4) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void unreconcile(Reconcile var1) throws AxelorException;

    @Transactional(rollbackOn={Exception.class})
    public void canBeZeroBalance(Reconcile var1) throws AxelorException;

    public void balanceCredit(MoveLine var1) throws AxelorException;

    public List<Reconcile> getReconciles(MoveLine var1);

    public void addToReconcileGroup(Reconcile var1) throws AxelorException;

    public static boolean isReconcilable(MoveLine acc1, MoveLine acc2) {
        return acc1.getAccount().getReconcileOk() != false && acc2.getAccount().getReconcileOk() != false && (acc1.getAccount().equals((Object)acc2.getAccount()) || acc1.getAccount().getCompatibleAccountSet().contains((Object)acc2.getAccount()));
    }
}

