/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.Reimbursement;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.db.repo.ReimbursementRepository;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReimbursementExportService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveService moveService;
    protected MoveRepository moveRepo;
    protected MoveLineService moveLineService;
    protected ReconcileService reconcileService;
    protected SequenceService sequenceService;
    protected ReimbursementRepository reimbursementRepo;
    protected AccountConfigService accountConfigService;
    protected PartnerService partnerService;
    protected PartnerRepository partnerRepository;
    protected AppAccountService appAccountService;

    @Inject
    public ReimbursementExportService(MoveService moveService, MoveRepository moveRepo, MoveLineService moveLineService, ReconcileService reconcileService, SequenceService sequenceService, ReimbursementRepository reimbursementRepo, AccountConfigService accountConfigService, PartnerService partnerService, AppAccountService appAccountService, PartnerRepository partnerRepository) {
        this.moveService = moveService;
        this.moveRepo = moveRepo;
        this.moveLineService = moveLineService;
        this.reconcileService = reconcileService;
        this.sequenceService = sequenceService;
        this.reimbursementRepo = reimbursementRepo;
        this.accountConfigService = accountConfigService;
        this.partnerService = partnerService;
        this.partnerRepository = partnerRepository;
        this.appAccountService = appAccountService;
    }

    public void fillMoveLineSet(Reimbursement reimbursement, List<MoveLine> moveLineList, BigDecimal total) {
        this.log.debug("In fillMoveLineSet");
        this.log.debug("Nombre de trop-per\u00e7us trouv\u00e9s : {}", (Object)moveLineList.size());
        for (MoveLine moveLine : moveLineList) {
            moveLine.setReimbursementStatusSelect(1);
        }
        reimbursement.setMoveLineSet(new HashSet<MoveLine>());
        reimbursement.getMoveLineSet().addAll(moveLineList);
        this.log.debug("End fillMoveLineSet");
    }

    @Transactional(rollbackOn={Exception.class})
    public Reimbursement runCreateReimbursement(List<MoveLine> moveLineList, Company company, Partner partner) throws AxelorException {
        this.log.debug("In runReimbursementProcess");
        BigDecimal total = this.getTotalAmountRemaining(moveLineList);
        AccountConfig accountConfig = company.getAccountConfig();
        if (total.compareTo(accountConfig.getLowerThresholdReimbursement()) > 0) {
            Reimbursement reimbursement = this.createReimbursement(partner, company);
            this.fillMoveLineSet(reimbursement, moveLineList, total);
            if (total.compareTo(accountConfig.getUpperThresholdReimbursement()) > 0 || reimbursement.getBankDetails() == null) {
                reimbursement.setStatusSelect(2);
            } else {
                reimbursement.setStatusSelect(3);
            }
            reimbursement = (Reimbursement)((Object)this.reimbursementRepo.save((Model)((Object)reimbursement)));
            return reimbursement;
        }
        this.log.debug("End runReimbursementProcess");
        return null;
    }

    public BigDecimal getTotalAmountRemaining(List<MoveLine> moveLineList) {
        BigDecimal total = BigDecimal.ZERO;
        for (MoveLine moveLine : moveLineList) {
            total = total.add(moveLine.getAmountRemaining());
        }
        this.log.debug("Total Amount Remaining : {}", (Object)total);
        return total;
    }

    public void createReimbursementMove(Reimbursement reimbursement, Company company) throws AxelorException {
        reimbursement = (Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId()));
        Partner partner = null;
        Move newMove = null;
        boolean first = true;
        AccountConfig accountConfig = company.getAccountConfig();
        if (reimbursement.getMoveLineSet() != null && !reimbursement.getMoveLineSet().isEmpty()) {
            int seq = 1;
            for (MoveLine moveLine : reimbursement.getMoveLineSet()) {
                BigDecimal amountRemaining = moveLine.getAmountRemaining();
                if (amountRemaining.compareTo(BigDecimal.ZERO) <= 0) continue;
                partner = moveLine.getPartner();
                moveLine.setReimbursementStatusSelect(2);
                if (first) {
                    newMove = this.moveService.getMoveCreateService().createMove(accountConfig.getReimbursementJournal(), company, null, partner, null, 2);
                    first = false;
                }
                MoveLine newDebitMoveLine = this.moveLineService.createMoveLine(newMove, partner, moveLine.getAccount(), amountRemaining, true, this.appAccountService.getTodayDate(company), seq, reimbursement.getRef(), reimbursement.getDescription());
                newMove.getMoveLineList().add(newDebitMoveLine);
                if (reimbursement.getDescription() != null && !reimbursement.getDescription().isEmpty()) {
                    newDebitMoveLine.setDescription(reimbursement.getDescription());
                }
                ++seq;
                Reconcile reconcile = this.reconcileService.createReconcile(newDebitMoveLine, moveLine, amountRemaining, false);
                if (reconcile == null) continue;
                this.reconcileService.confirmReconcile(reconcile, true);
            }
            MoveLine newCreditMoveLine = this.moveLineService.createMoveLine(newMove, partner, accountConfig.getReimbursementAccount(), reimbursement.getAmountReimbursed(), false, this.appAccountService.getTodayDate(company), seq, reimbursement.getRef(), reimbursement.getDescription());
            newMove.getMoveLineList().add(newCreditMoveLine);
            if (reimbursement.getDescription() != null && !reimbursement.getDescription().isEmpty()) {
                newCreditMoveLine.setDescription(reimbursement.getDescription());
            }
            this.moveService.getMoveValidateService().validate(newMove);
            this.moveRepo.save((Model)((Object)newMove));
        }
    }

    public void testCompanyField(Company company) throws AxelorException {
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        this.accountConfigService.getReimbursementAccount(accountConfig);
        this.accountConfigService.getReimbursementJournal(accountConfig);
        this.accountConfigService.getReimbursementExportFolderPath(accountConfig);
        if (!this.sequenceService.hasSequence("reimbursement", company)) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a reimbursement sequence for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void reimburse(Reimbursement reimbursement, Company company) throws AxelorException {
        reimbursement.setAmountReimbursed(reimbursement.getAmountToReimburse());
        this.createReimbursementMove(reimbursement, company);
        reimbursement.setStatusSelect(4);
        this.reimbursementRepo.save((Model)((Object)reimbursement));
    }

    public Reimbursement createReimbursement(Partner partner, Company company) throws AxelorException {
        Reimbursement reimbursement = new Reimbursement();
        reimbursement.setPartner(partner);
        reimbursement.setCompany(company);
        BankDetails bankDetails = this.partnerService.getDefaultBankDetails(partner);
        reimbursement.setBankDetails(bankDetails);
        reimbursement.setRef(this.sequenceService.getSequenceNumber("reimbursement", company));
        return reimbursement;
    }

    public boolean canBeReimbursed(Partner partner, Company company) {
        return ((BlockingService)Beans.get(BlockingService.class)).getBlocking(partner, company, BlockingRepository.REIMBURSEMENT_BLOCKING.intValue()) == null;
    }

    @Transactional
    public void updatePartnerCurrentRIB(Reimbursement reimbursement) {
        BankDetails bankDetails = reimbursement.getBankDetails();
        Partner partner = reimbursement.getPartner();
        BankDetails defaultBankDetails = this.partnerService.getDefaultBankDetails(partner);
        if (partner != null && bankDetails != null && !bankDetails.equals((Object)defaultBankDetails)) {
            bankDetails.setIsDefault(true);
            defaultBankDetails.setIsDefault(false);
            partner.addBankDetailsListItem(bankDetails);
            this.partnerRepository.save((Model)((Object)partner));
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void createReimbursementInvoice(Partner partner, Company company, List<? extends MoveLine> moveLineList) throws AxelorException {
        BigDecimal total = this.getTotalAmountRemaining(moveLineList);
        if (total.compareTo(BigDecimal.ZERO) > 0) {
            this.testCompanyField(company);
            Reimbursement reimbursement = this.createReimbursement(partner, company);
            this.fillMoveLineSet(reimbursement, moveLineList, total);
            if (total.compareTo(company.getAccountConfig().getUpperThresholdReimbursement()) > 0 || reimbursement.getBankDetails() == null) {
                reimbursement.setStatusSelect(2);
            } else {
                reimbursement.setStatusSelect(3);
            }
            this.reimbursementRepo.save((Model)((Object)reimbursement));
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void createReimbursementInvoice(Invoice invoice) throws AxelorException {
        Company company = invoice.getCompany();
        Partner partner = invoice.getPartner();
        MoveLineRepository moveLineRepo = (MoveLineRepository)((Object)Beans.get(MoveLineRepository.class));
        List moveLineList = moveLineRepo.all().filter("self.account.useForPartnerBalance = 'true' AND (self.move.statusSelect = ?1 OR self.move.statusSelect = ?2) AND self.amountRemaining > 0 AND self.credit > 0 AND self.partner = ?3 AND self.reimbursementStatusSelect = ?4 ", new Object[]{3, 2, partner, 0}).fetch();
        this.createReimbursementInvoice(partner, company, moveLineList);
    }
}

