/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.InterbankCodeLine;
import com.axelor.apps.account.db.repo.InterbankCodeLineRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.bankorder.file.cfonb.CfonbImportService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.tool.file.FileTool;
import com.axelor.exception.AxelorException;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RejectImportService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AppAccountService appAccountService;
    protected CfonbImportService cfonbImportService;
    protected InterbankCodeLineRepository interbankCodeLineRepo;

    @Inject
    public RejectImportService(AppAccountService appAccountService, CfonbImportService cfonbImportService, InterbankCodeLineRepository interbankCodeLineRepo) {
        this.appAccountService = appAccountService;
        this.cfonbImportService = cfonbImportService;
        this.interbankCodeLineRepo = interbankCodeLineRepo;
    }

    public String getDestFilename(String src, String dest) {
        this.log.debug("Chemin de destination : {}", (Object)dest);
        String newDest = dest.split("\\.")[0];
        String timeString = this.appAccountService.getTodayDateTime().toString();
        timeString = timeString.replace("-", "");
        timeString = timeString.replace(":", "");
        timeString = timeString.replace(".", "");
        timeString = timeString.replace("+", "");
        newDest = newDest + "_" + timeString + ".";
        newDest = dest.split("\\.").length == 2 ? newDest + dest.split("\\.")[1] : newDest + src.split("\\.")[1];
        this.log.debug("Chemin de destination g\u00e9n\u00e9r\u00e9 : {}", (Object)newDest);
        return newDest;
    }

    public String getDestCFONBFile(String src, String temp) throws AxelorException, IOException {
        String dest = this.getDestFilename(src, temp);
        this.createFilePath(dest);
        FileTool.copy((String)src, (String)dest);
        return dest;
    }

    public List<String[]> getCFONBFile(String src, String temp, Company company, int operation) throws AxelorException, IOException {
        String dest = this.getDestCFONBFile(src, temp);
        return this.cfonbImportService.importCFONB(dest, company, operation);
    }

    public Map<List<String[]>, String> getCFONBFileByLot(String src, String temp, Company company, int operation) throws AxelorException, IOException {
        String dest = this.getDestCFONBFile(src, temp);
        return this.cfonbImportService.importCFONBByLot(dest, company, operation);
    }

    public InterbankCodeLine getInterbankCodeLine(String reasonCode, int interbankCodeOperation) {
        switch (interbankCodeOperation) {
            case 0: {
                return (InterbankCodeLine)((Object)this.interbankCodeLineRepo.all().filter("self.code = ?1 AND self.interbankCode = ?2 AND self.transferCfonbOk = 'true'", new Object[]{reasonCode, this.appAccountService.getAppAccount().getTransferAndDirectDebitInterbankCode()}).fetchOne());
            }
            case 1: {
                return (InterbankCodeLine)((Object)this.interbankCodeLineRepo.all().filter("self.code = ?1 AND self.interbankCode = ?2 AND self.directDebitAndTipCfonbOk = 'true'", new Object[]{reasonCode, this.appAccountService.getAppAccount().getTransferAndDirectDebitInterbankCode()}).fetchOne());
            }
            case 2: {
                return (InterbankCodeLine)((Object)this.interbankCodeLineRepo.all().filter("self.code = ?1 AND self.interbankCode = ?2 AND self.directDebitSepaOk = 'true'", new Object[]{reasonCode, this.appAccountService.getAppAccount().getTransferAndDirectDebitInterbankCode()}).fetchOne());
            }
            case 3: {
                return (InterbankCodeLine)((Object)this.interbankCodeLineRepo.all().filter("self.code = ?1 AND self.interbankCode = ?2 AND self.lcrBorOk = 'true'", new Object[]{reasonCode, this.appAccountService.getAppAccount().getTransferAndDirectDebitInterbankCode()}).fetchOne());
            }
            case 4: {
                return (InterbankCodeLine)((Object)this.interbankCodeLineRepo.all().filter("self.code = ?1 AND self.interbankCode = ?2 AND self.chequeOk = 'true'", new Object[]{reasonCode, this.appAccountService.getAppAccount().getChequeInterbankCode()}).fetchOne());
            }
        }
        return null;
    }

    public LocalDate createRejectDate(String dateReject) {
        return LocalDate.of(Integer.parseInt(dateReject.substring(4, 6)) + 2000, Integer.parseInt(dateReject.substring(2, 4)), Integer.parseInt(dateReject.substring(0, 2)));
    }

    public void createFilePath(String path) throws IOException {
        File file = new File(path);
        Files.createParentDirs((File)file);
        file.createNewFile();
    }
}

