/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service;

import com.axelor.apps.account.db.TaxPaymentMoveLine;
import com.axelor.apps.account.service.TaxPaymentMoveLineService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class TaxPaymentMoveLineServiceImpl
implements TaxPaymentMoveLineService {
    @Override
    public TaxPaymentMoveLine computeTaxAmount(TaxPaymentMoveLine taxPaymentMoveLine) throws AxelorException {
        BigDecimal taxRate = taxPaymentMoveLine.getTaxRate();
        BigDecimal base = taxPaymentMoveLine.getDetailPaymentAmount();
        taxPaymentMoveLine.setTaxAmount(base.multiply(taxRate).setScale(2, RoundingMode.HALF_UP));
        return taxPaymentMoveLine;
    }

    @Override
    public TaxPaymentMoveLine getReverseTaxPaymentMoveLine(TaxPaymentMoveLine taxPaymentMoveLine) throws AxelorException {
        TaxPaymentMoveLine reversetaxPaymentMoveLine = new TaxPaymentMoveLine(taxPaymentMoveLine.getMoveLine(), taxPaymentMoveLine.getOriginTaxLine(), taxPaymentMoveLine.getReconcile(), taxPaymentMoveLine.getTaxRate(), taxPaymentMoveLine.getDetailPaymentAmount().negate(), ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(taxPaymentMoveLine.getReconcile().getCompany()));
        reversetaxPaymentMoveLine = this.computeTaxAmount(reversetaxPaymentMoveLine);
        reversetaxPaymentMoveLine.setIsAlreadyReverse(true);
        taxPaymentMoveLine.setIsAlreadyReverse(true);
        return reversetaxPaymentMoveLine;
    }
}

