/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.bankorder.file.cfonb;

import com.axelor.apps.account.db.CfonbConfig;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.CfonbConfigService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.tool.file.FileTool;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CfonbImportService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected CfonbConfigService cfonbConfigService;
    protected AppAccountService appAccountService;
    protected CfonbConfig cfonbConfig;
    protected List<String> importFile;

    @Inject
    public CfonbImportService(CfonbConfigService cfonbConfigService, AppAccountService appAccountService) {
        this.cfonbConfigService = cfonbConfigService;
        this.appAccountService = appAccountService;
    }

    private void init(CfonbConfig cfonbConfig) {
        this.cfonbConfig = cfonbConfig;
    }

    private void init(Company company) throws AxelorException {
        this.init(this.cfonbConfigService.getCfonbConfig(company));
    }

    public List<String[]> importCFONB(String fileName, Company company, int operation) throws AxelorException, IOException {
        return this.importCFONB(fileName, company, operation, 999);
    }

    public Map<List<String[]>, String> importCFONBByLot(String fileName, Company company, int operation) throws AxelorException, IOException {
        return this.importCFONBByLot(fileName, company, operation, 999);
    }

    public List<String[]> importCFONB(String fileName, Company company, int operation, int optionalOperation) throws AxelorException, IOException {
        this.testCompanyImportCFONBField(company);
        this.importFile = FileTool.reader((String)fileName);
        if (this.appAccountService.getAppAccount().getTransferAndDirectDebitInterbankCode() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a reject/return reason's code's list relating to Card cashing, Direct debit and TIP in general configuration"), new Object[]{I18n.get((String)"Warning !")});
        }
        String headerCFONB = null;
        List<String> multiDetailsCFONB = null;
        String endingCFONB = null;
        ArrayList<String[]> importDataList = new ArrayList<String[]>();
        while (this.importFile != null && this.importFile.size() != 0) {
            headerCFONB = this.getHeaderCFONB(this.importFile, operation, optionalOperation);
            if (headerCFONB == null) {
                throw new AxelorException(4, I18n.get((String)"%s : A header record is missing in the file %s"), new Object[]{I18n.get((String)"Warning !"), fileName});
            }
            this.importFile.remove(headerCFONB);
            multiDetailsCFONB = this.getDetailsCFONB(this.importFile, operation, optionalOperation);
            if (multiDetailsCFONB.isEmpty()) {
                throw new AxelorException(4, I18n.get((String)"%s : One or several detail records are missing in the file %s"), new Object[]{I18n.get((String)"Warning !"), fileName});
            }
            for (String detail : multiDetailsCFONB) {
                this.importFile.remove(detail);
            }
            endingCFONB = this.getEndingCFONB(this.importFile, operation, optionalOperation);
            if (endingCFONB == null) {
                throw new AxelorException(4, I18n.get((String)"%s : A record is missing in the file %s"), new Object[]{I18n.get((String)"Warning !"), fileName});
            }
            this.importFile.remove(endingCFONB);
            this.testLength(headerCFONB, multiDetailsCFONB, endingCFONB, company);
            importDataList.addAll(this.getDetailDataAndCheckAmount(operation, headerCFONB, multiDetailsCFONB, endingCFONB, fileName));
        }
        return importDataList;
    }

    public Map<List<String[]>, String> importCFONBByLot(String fileName, Company company, int operation, int optionalOperation) throws AxelorException, IOException {
        this.testCompanyImportCFONBField(company);
        this.importFile = FileTool.reader((String)fileName);
        if (this.appAccountService.getAppAccount().getTransferAndDirectDebitInterbankCode() == null) {
            throw new AxelorException(4, I18n.get((String)"%s : You must configure a reject/return reason's code's list relating to Card cashing, Direct debit and TIP in general configuration"), new Object[]{I18n.get((String)"Warning !")});
        }
        String headerCFONB = null;
        List<String> multiDetailsCFONB = null;
        String endingCFONB = null;
        HashMap<List<String[]>, String> importDataList = new HashMap<List<String[]>, String>();
        while (this.importFile != null && this.importFile.size() != 0) {
            headerCFONB = this.getHeaderCFONB(this.importFile, operation, optionalOperation);
            if (headerCFONB == null) {
                throw new AxelorException(4, I18n.get((String)"%s : A header record is missing in the file %s"), new Object[]{I18n.get((String)"Warning !"), fileName});
            }
            this.importFile.remove(headerCFONB);
            multiDetailsCFONB = this.getDetailsCFONB(this.importFile, operation, optionalOperation);
            if (multiDetailsCFONB.isEmpty()) {
                throw new AxelorException(4, I18n.get((String)"%s : One or several detail records are missing in the file %s"), new Object[]{I18n.get((String)"Warning !"), fileName});
            }
            for (String detail : multiDetailsCFONB) {
                this.importFile.remove(detail);
            }
            endingCFONB = this.getEndingCFONB(this.importFile, operation, optionalOperation);
            if (endingCFONB == null) {
                throw new AxelorException(4, I18n.get((String)"%s : A record is missing in the file %s"), new Object[]{I18n.get((String)"Warning !"), fileName});
            }
            this.importFile.remove(endingCFONB);
            this.testLength(headerCFONB, multiDetailsCFONB, endingCFONB, company);
            importDataList.put(this.getDetailDataAndCheckAmount(operation, headerCFONB, multiDetailsCFONB, endingCFONB, fileName), this.getHeaderDate(headerCFONB));
        }
        return importDataList;
    }

    private List<String[]> getDetailDataAndCheckAmount(int operation, String headerCFONB, List<String> multiDetailsCFONB, String endingCFONB, String fileName) throws AxelorException {
        ArrayList<String[]> importDataList = new ArrayList<String[]>();
        switch (operation) {
            case 0: {
                for (String detailCFONB : multiDetailsCFONB) {
                    importDataList.add(this.getDetailData(detailCFONB));
                }
                this.checkTotalAmount(multiDetailsCFONB, endingCFONB, fileName, 228, 240);
                break;
            }
            case 1: {
                for (String detailCFONB : multiDetailsCFONB) {
                    importDataList.add(this.getDetailData(detailCFONB));
                }
                this.checkTotalAmount(multiDetailsCFONB, endingCFONB, fileName, 228, 240);
                break;
            }
        }
        return importDataList;
    }

    private void checkTotalAmount(List<String> multiDetailsCFONB, String endingCFONB, String fileName, int amountPosStart, int amountPosEnd) throws AxelorException {
        int totalAmount = 0;
        for (String detailCFONB : multiDetailsCFONB) {
            totalAmount += Integer.parseInt(detailCFONB.substring(amountPosStart, amountPosEnd));
        }
        int totalRecord = Integer.parseInt(endingCFONB.substring(amountPosStart, amountPosEnd));
        this.log.debug("Controle du montant total des enregistrement d\u00e9tail ({}) et du montant de l'enregistrement total ({})", new Object[]{totalAmount, totalRecord});
        if (totalAmount != totalRecord) {
            throw new AxelorException(4, I18n.get((String)"%s : The total amount for the following record isn't correct (file %s) :\n %s"), new Object[]{I18n.get((String)"Warning !"), fileName, endingCFONB});
        }
    }

    private void testLength(String headerCFONB, List<String> multiDetailsCFONB, String endingCFONB, Company company) throws AxelorException {
    }

    private String[] getDetailData(String detailCFONB) {
        String[] detailData = new String[4];
        this.log.debug("detailCFONB : {}", (Object)detailCFONB);
        detailData[0] = detailCFONB.substring(214, 220);
        detailData[1] = detailCFONB.substring(152, 183).split("/")[0].trim();
        detailData[2] = detailCFONB.substring(228, 240).substring(0, 10) + "." + detailCFONB.substring(228, 240).substring(10);
        detailData[3] = detailCFONB.substring(226, 228);
        this.log.debug("Obtention des donn\u00e9es d'un enregistrement d\u00e9tail CFONB: Date de rejet = {}, Ref pr\u00e9l\u00e8vement = {}, Montant rejet\u00e9 = {}, Motif du rejet = {}", new Object[]{detailData[0], detailData[1], detailData[2], detailData[3]});
        return detailData;
    }

    private String getHeaderDate(String headerCFONB) {
        return headerCFONB.substring(10, 16);
    }

    public void testCompanyImportCFONBField(Company company) throws AxelorException {
        this.init(company);
        this.cfonbConfigService.getHeaderRecordCodeImportCFONB(this.cfonbConfig);
        this.cfonbConfigService.getDetailRecordCodeImportCFONB(this.cfonbConfig);
        this.cfonbConfigService.getEndingRecordCodeImportCFONB(this.cfonbConfig);
        this.cfonbConfigService.getTransferOperationCodeImportCFONB(this.cfonbConfig);
        this.cfonbConfigService.getDirectDebitOperationCodeImportCFONB(this.cfonbConfig);
    }

    private String getHeaderCFONB(List<String> file, int operation, int optionalOperation) {
        String recordCode = this.getHeaderRecordCode(operation);
        String optionalRecordCode = this.getHeaderRecordCode(optionalOperation);
        String operationCode = this.getImportOperationCode(operation);
        String optionalOperationCode = this.getImportOperationCode(optionalOperation);
        this.log.debug("Obtention enregistrement en-t\u00eate CFONB: recordCode = {}, operationCode = {}, optionalRecordCode = {}, optionalOperationCode = {}", new Object[]{recordCode, operationCode, optionalRecordCode, optionalOperationCode});
        for (String s : file) {
            this.log.debug("file line : {}", (Object)s);
            this.log.debug("s.substring(0, 2) : {}", (Object)s.substring(0, 2));
            if (!s.substring(0, 2).equals(recordCode) && !s.substring(0, 2).equals(optionalRecordCode)) break;
            this.log.debug("s.substring(8, 10) : {}", (Object)s.substring(8, 10));
            this.log.debug("s.substring(2, 4) : {}", (Object)s.substring(2, 4));
            if ((!s.substring(8, 10).equals(operationCode) || optionalOperation != 999) && !s.substring(2, 4).equals(operationCode) && !s.substring(2, 4).equals(optionalOperationCode)) continue;
            return s;
        }
        return null;
    }

    private String getHeaderRecordCode(int operation) {
        if (operation == 0 || operation == 1 || operation == 2) {
            return this.cfonbConfig.getHeaderRecordCodeImportCFONB();
        }
        if (operation == 3 || operation == 4) {
            return this.cfonbConfig.getSenderRecordCodeExportCFONB();
        }
        return "999";
    }

    private List<String> getDetailsCFONB(List<String> file, int operation, int optionalOperation) {
        ArrayList<String> stringList = new ArrayList<String>();
        String recordCode = this.getDetailRecordCode(operation);
        String operationCode = this.getImportOperationCode(operation);
        String optionalRecordCode = this.getDetailRecordCode(optionalOperation);
        String optionalOperationCode = this.getImportOperationCode(optionalOperation);
        this.log.debug("Obtention enregistrement d\u00e9tails CFONB: recordCode = {}, operationCode = {}, optionalRecordCode = {}, optionalOperationCode = {}", new Object[]{recordCode, operationCode, optionalRecordCode, optionalOperationCode});
        for (String s : file) {
            if (!s.substring(0, 2).equals(recordCode) && !s.substring(0, 2).equals(optionalRecordCode)) break;
            if ((!s.substring(8, 10).equals(operationCode) || optionalOperation != 999) && !s.substring(2, 4).equals(operationCode) && !s.substring(2, 4).equals(optionalOperationCode)) continue;
            stringList.add(s);
        }
        return stringList;
    }

    private String getDetailRecordCode(int operation) {
        if (operation == 0 || operation == 1 || operation == 2) {
            return this.cfonbConfig.getDetailRecordCodeImportCFONB();
        }
        if (operation == 3 || operation == 4) {
            return this.cfonbConfig.getRecipientRecordCodeExportCFONB();
        }
        return "999";
    }

    private String getEndingCFONB(List<String> file, int operation, int optionalOperation) {
        String operationCode = this.getImportOperationCode(operation);
        String recordCode = this.getEndingRecordCode(operation);
        String optionalRecordCode = this.getEndingRecordCode(optionalOperation);
        String optionalOperationCode = this.getImportOperationCode(optionalOperation);
        this.log.debug("Obtention enregistrement fin CFONB: recordCode = {}, operationCode = {}, optionalRecordCode = {}, optionalOperationCode = {}", new Object[]{recordCode, operationCode, optionalRecordCode, optionalOperationCode});
        for (String s : file) {
            if (!s.substring(0, 2).equals(recordCode) && !s.substring(0, 2).equals(optionalRecordCode)) break;
            if ((!s.substring(8, 10).equals(operationCode) || optionalOperation != 999) && !s.substring(2, 4).equals(operationCode) && !s.substring(2, 4).equals(optionalOperationCode)) continue;
            return s;
        }
        return null;
    }

    private String getEndingRecordCode(int operation) {
        if (operation == 0 || operation == 1 || operation == 2) {
            return this.cfonbConfig.getEndingRecordCodeImportCFONB();
        }
        if (operation == 3 || operation == 4) {
            return this.cfonbConfig.getTotalRecordCodeExportCFONB();
        }
        return "999";
    }

    private String getImportOperationCode(int operation) {
        String operationCode = "";
        switch (operation) {
            case 0: {
                operationCode = this.cfonbConfig.getTransferOperationCodeImportCFONB();
                break;
            }
            case 1: {
                operationCode = this.cfonbConfig.getDirectDebitOperationCodeImportCFONB();
                break;
            }
        }
        return operationCode;
    }
}

