/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.batch.BatchStrategy;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCreateService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.repo.BankDetailsRepository;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchCreditTransferInvoice
extends BatchStrategy {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final AppAccountService appAccountService;
    protected final InvoiceRepository invoiceRepo;
    protected final InvoicePaymentCreateService invoicePaymentCreateService;
    protected final InvoicePaymentRepository invoicePaymentRepository;

    @Inject
    public BatchCreditTransferInvoice(AppAccountService appAccountService, InvoiceRepository invoiceRepo, InvoicePaymentCreateService invoicePaymentCreateService, InvoicePaymentRepository invoicePaymentRepository) {
        this.appAccountService = appAccountService;
        this.invoiceRepo = invoiceRepo;
        this.invoicePaymentCreateService = invoicePaymentCreateService;
        this.invoicePaymentRepository = invoicePaymentRepository;
    }

    protected List<InvoicePayment> processInvoices(int operationTypeSelect) {
        List invoiceList;
        ArrayList<InvoicePayment> doneList = new ArrayList<InvoicePayment>();
        ArrayList anomalyList = Lists.newArrayList((Object[])new Long[]{0L});
        AccountingBatch accountingBatch = this.batch.getAccountingBatch();
        boolean manageMultiBanks = this.appAccountService.getAppBase().getManageMultiBanks();
        StringBuilder filter = new StringBuilder();
        filter.append("self.operationTypeSelect = :operationTypeSelect AND self.statusSelect = :statusSelect AND self.amountRemaining > 0 AND self.hasPendingPayments = FALSE AND self.company = :company AND self.dueDate <= :dueDate AND self.paymentMode = :paymentMode AND self.id NOT IN (:anomalyList)AND self.pfpValidateStatusSelect != :pfpValidateStatusSelect");
        if (manageMultiBanks) {
            filter.append(" AND self.companyBankDetails IN (:bankDetailsSet)");
        }
        if (accountingBatch.getCurrency() != null) {
            filter.append(" AND self.currency = :currency");
        }
        Query query = this.invoiceRepo.all().filter(filter.toString()).bind("operationTypeSelect", (Object)operationTypeSelect).bind("statusSelect", (Object)3).bind("company", (Object)accountingBatch.getCompany()).bind("dueDate", (Object)accountingBatch.getDueDate()).bind("paymentMode", (Object)accountingBatch.getPaymentMode()).bind("anomalyList", (Object)anomalyList).bind("pfpValidateStatusSelect", (Object)3);
        if (manageMultiBanks) {
            HashSet bankDetailsSet = Sets.newHashSet((Object[])new BankDetails[]{accountingBatch.getBankDetails()});
            if (accountingBatch.getIncludeOtherBankAccounts().booleanValue()) {
                bankDetailsSet.addAll(accountingBatch.getCompany().getBankDetailsList());
            }
            query.bind("bankDetailsSet", (Object)bankDetailsSet);
        }
        if (accountingBatch.getCurrency() != null) {
            query.bind("currency", (Object)accountingBatch.getCurrency());
        }
        BankDetailsRepository bankDetailsRepo = (BankDetailsRepository)((Object)Beans.get(BankDetailsRepository.class));
        BankDetails companyBankDetails = accountingBatch.getBankDetails();
        while (!(invoiceList = query.fetch(10)).isEmpty()) {
            if (!JPA.em().contains((Object)companyBankDetails)) {
                companyBankDetails = (BankDetails)((Object)bankDetailsRepo.find(companyBankDetails.getId()));
            }
            for (Invoice invoice : invoiceList) {
                try {
                    doneList.add(this.invoicePaymentCreateService.createInvoicePayment(invoice, companyBankDetails));
                    this.incrementDone();
                }
                catch (Exception ex) {
                    this.incrementAnomaly();
                    anomalyList.add(invoice.getId());
                    query.bind("anomalyList", (Object)anomalyList);
                    TraceBackService.trace((Throwable)ex, (String)"creditTransfer", (long)this.batch.getId());
                    ex.printStackTrace();
                    this.log.error(String.format("Credit transfer batch for invoices: anomaly for invoice %s", invoice.getInvoiceId()));
                    break;
                }
            }
            JPA.clear();
        }
        return doneList;
    }

    protected void stop() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.get((String)"Report for credit transfer batch:")).append(" ");
        sb.append(String.format(I18n.get((String)"%d invoice treated successfully,", (String)"%d invoices treated successfully,", (int)this.batch.getDone()) + " ", this.batch.getDone()));
        sb.append(String.format(I18n.get((String)"%d anomaly.", (String)"%d anomalies.", (int)this.batch.getAnomaly()), this.batch.getAnomaly()));
        this.addComment(sb.toString());
        super.stop();
    }
}

