/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.DebtRecovery;
import com.axelor.apps.account.db.repo.DebtRecoveryRepository;
import com.axelor.apps.account.service.batch.BatchStrategy;
import com.axelor.apps.account.service.debtrecovery.DebtRecoveryActionService;
import com.axelor.apps.account.service.debtrecovery.DebtRecoveryService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.Table;

public class BatchDebtRecovery
extends BatchStrategy {
    protected boolean stopping = false;
    protected PartnerRepository partnerRepository;
    protected MessageRepository messageRepository;
    protected DebtRecoveryRepository debtRecoveryRepository;
    protected DebtRecoveryActionService debtRecoveryActionService;

    @Inject
    public BatchDebtRecovery(DebtRecoveryService debtRecoveryService, PartnerRepository partnerRepository, DebtRecoveryRepository debtRecoveryRepository, DebtRecoveryActionService debtRecoveryActionService, MessageRepository messageRepository) {
        super(debtRecoveryService);
        this.partnerRepository = partnerRepository;
        this.debtRecoveryRepository = debtRecoveryRepository;
        this.debtRecoveryActionService = debtRecoveryActionService;
        this.messageRepository = messageRepository;
    }

    protected void start() throws IllegalAccessException {
        super.start();
        Company company = this.batch.getAccountingBatch().getCompany();
        try {
            this.debtRecoveryService.testCompanyField(company);
        }
        catch (AxelorException e) {
            TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), ""), (String)"debtRecovery", (long)this.batch.getId());
            this.incrementAnomaly();
            this.stopping = true;
        }
        this.checkPoint();
    }

    protected void process() {
        if (!this.stopping) {
            this.debtRecoveryPartner();
        }
    }

    public void debtRecoveryPartner() {
        List partnerList;
        Company company = this.batch.getAccountingBatch().getCompany();
        com.axelor.db.Query query = this.partnerRepository.all().filter("self.isContact = false AND :_company MEMBER OF self.companySet AND self.accountingSituationList IS NOT EMPTY AND self.isCustomer = true AND self.id NOT IN (" + ((BlockingService)Beans.get(BlockingService.class)).listOfBlockedPartner(company, BlockingRepository.REMINDER_BLOCKING.intValue()) + ")").bind("_company", (Object)company).order("id");
        int offset = 0;
        while (!(partnerList = query.fetch(10, offset)).isEmpty()) {
            this.findBatch();
            for (Partner partner : partnerList) {
                ++offset;
                try {
                    boolean remindedOk = this.debtRecoveryService.debtRecoveryGenerate(partner, company);
                    if (!remindedOk) continue;
                    DebtRecovery debtRecovery = this.debtRecoveryService.getDebtRecovery(partner, company);
                    this.addBatchToModel((Model)((Object)debtRecovery));
                    this.incrementDone(partner);
                }
                catch (AxelorException e) {
                    TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Partner") + " %s", new Object[]{partner.getName()}), (String)"debtRecovery", (long)this.batch.getId());
                    this.incrementAnomaly(partner);
                    break;
                }
                catch (Exception e) {
                    TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Partner") + " %s", partner.getName()), e), (String)"debtRecovery", (long)this.batch.getId());
                    this.incrementAnomaly(partner);
                    break;
                }
            }
            JPA.clear();
        }
    }

    protected void incrementDone(Partner partner) {
        this.addBatchToModel((Model)((Object)partner));
        this._incrementDone();
    }

    protected void incrementAnomaly(Partner partner) {
        this.findBatch();
        partner = (Partner)((Object)this.partnerRepository.find(partner.getId()));
        this._incrementAnomaly();
    }

    protected void addBatchToModel(Model model) {
        String tableName = this.getBatchSetTableName(model);
        String sqlString = String.format("INSERT INTO %s VALUES (:modelId, :batchId)", tableName);
        Query query = JPA.em().createNativeQuery(sqlString);
        query.setParameter("modelId", (Object)model.getId());
        query.setParameter("batchId", (Object)this.batch.getId());
        JPA.runInTransaction(() -> ((Query)query).executeUpdate());
    }

    private String getBatchSetTableName(Model model) {
        String modelTableName = EntityHelper.getEntityClass((Object)model).getAnnotation(Table.class).name();
        return modelTableName + "_BATCH_SET";
    }

    protected void stop() {
        String comment = I18n.get((String)"Debt recovery's reporting :");
        comment = comment + String.format("\t* %s " + I18n.get((String)"Partner(s) treated") + "\n", this.batch.getDone());
        comment = comment + String.format(I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }
}

