/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.FixedAssetLine;
import com.axelor.apps.account.db.repo.FixedAssetLineRepository;
import com.axelor.apps.account.service.FixedAssetLineService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;

public class BatchRealizeFixedAssetLine
extends AbstractBatch {
    private FixedAssetLineService fixedAssetLineService;
    private AppBaseService appBaseService;
    @Inject
    FixedAssetLineRepository fixedAssetLineRepo;

    @Inject
    public BatchRealizeFixedAssetLine(FixedAssetLineService fixedAssetLineService, AppBaseService appBaseService) {
        this.fixedAssetLineService = fixedAssetLineService;
        this.appBaseService = appBaseService;
    }

    protected void process() {
        String query = "self.statusSelect = :statusSelect";
        LocalDate startDate = this.batch.getAccountingBatch().getStartDate();
        LocalDate endDate = this.batch.getAccountingBatch().getEndDate();
        query = this.batch.getAccountingBatch().getUpdateAllRealizedFixedAssetLines() == false && startDate != null && endDate != null && startDate.isBefore(endDate) ? query + " AND self.depreciationDate < :endDate AND self.depreciationDate > :startDate" : query + " AND self.depreciationDate < :dateNow";
        List fixedAssetLineList = ((FixedAssetLineRepository)((Object)Beans.get(FixedAssetLineRepository.class))).all().filter(query).bind("statusSelect", (Object)1).bind("startDate", (Object)startDate).bind("endDate", (Object)endDate).bind("dateNow", (Object)this.appBaseService.getTodayDate(this.batch.getAccountingBatch() != null ? this.batch.getAccountingBatch().getCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null))).fetch();
        for (FixedAssetLine fixedAssetLine : fixedAssetLineList) {
            try {
                fixedAssetLine = (FixedAssetLine)((Object)this.fixedAssetLineRepo.find(fixedAssetLine.getId()));
                if (fixedAssetLine.getFixedAsset().getStatusSelect() > 1) {
                    this.fixedAssetLineService.realize(fixedAssetLine);
                    this.incrementDone();
                }
            }
            catch (Exception e) {
                this.incrementAnomaly();
                TraceBackService.trace((Throwable)e);
            }
            JPA.clear();
        }
    }

    protected void stop() {
        String comment = String.format("\t* %s " + I18n.get((String)"Realized fixed asset lines") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        this.addComment(comment);
        super.stop();
    }
}

