/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.batch;

import com.axelor.apps.account.db.Reimbursement;
import com.axelor.apps.account.db.repo.ReimbursementRepository;
import com.axelor.apps.account.service.AccountingService;
import com.axelor.apps.account.service.ReimbursementExportService;
import com.axelor.apps.account.service.bankorder.file.cfonb.CfonbExportService;
import com.axelor.apps.account.service.batch.BatchAccountCustomer;
import com.axelor.apps.account.service.batch.BatchStrategy;
import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchReimbursementExport
extends BatchStrategy {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected boolean stop = false;
    protected BigDecimal totalAmount = BigDecimal.ZERO;
    protected String updateCustomerAccountLog = "";
    protected ReimbursementRepository reimbursementRepo;
    protected PartnerRepository partnerRepository;

    @Inject
    public BatchReimbursementExport(ReimbursementExportService reimbursementExportService, CfonbExportService cfonbExportService, BatchAccountCustomer batchAccountCustomer, ReimbursementRepository reimbursementRepo, PartnerRepository partnerRepository) {
        super(reimbursementExportService, cfonbExportService, batchAccountCustomer);
        this.reimbursementRepo = reimbursementRepo;
        this.partnerRepository = partnerRepository;
        AccountingService.setUpdateCustomerAccount(false);
    }

    protected void start() throws IllegalAccessException {
        super.start();
        Company company = this.batch.getAccountingBatch().getCompany();
        switch (this.batch.getAccountingBatch().getReimbursementExportTypeSelect()) {
            case 1: {
                try {
                    this.testAccountingBatchBankDetails(this.batch.getAccountingBatch());
                    this.reimbursementExportService.testCompanyField(company);
                }
                catch (AxelorException e) {
                    TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), ""), (String)"reimbursement", (long)this.batch.getId());
                    this.incrementAnomaly();
                    this.stop = true;
                }
                break;
            }
            case 2: {
                try {
                    this.testAccountingBatchBankDetails(this.batch.getAccountingBatch());
                    this.reimbursementExportService.testCompanyField(company);
                    this.cfonbExportService.testCompanyExportCFONBField(company);
                }
                catch (AxelorException e) {
                    TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), ""), (String)"reimbursement", (long)this.batch.getId());
                    this.incrementAnomaly();
                    this.stop = true;
                }
                break;
            }
            default: {
                TraceBackService.trace((AxelorException)new AxelorException(5, I18n.get((String)"Unknowned data type for the treatment %s"), new Object[]{this.batch.getAccountingBatch().getActionSelect()}), (String)"reimbursement", (long)this.batch.getId());
                this.incrementAnomaly();
                this.stop = true;
            }
        }
        this.checkPoint();
    }

    protected void process() {
        if (!this.stop) {
            Company company = this.batch.getAccountingBatch().getCompany();
            switch (this.batch.getAccountingBatch().getReimbursementExportTypeSelect()) {
                case 1: {
                    this.runCreateReimbursementExport(company);
                    break;
                }
                case 2: {
                    this.runReimbursementExportProcess(company);
                    this.updateCustomerAccountLog = this.updateCustomerAccountLog + this.batchAccountCustomer.updateAccountingSituationMarked((Company)((Object)this.companyRepo.find(company.getId())));
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCreateReimbursementExport(Company company) {
        List reimbursementList = this.reimbursementRepo.all().filter("self.statusSelect != ?1 AND self.statusSelect != ?2 AND self.company = ?3 AND self.partner.id NOT IN (" + ((BlockingService)Beans.get(BlockingService.class)).listOfBlockedPartner(company, BlockingRepository.REIMBURSEMENT_BLOCKING.intValue()) + " )", new Object[]{4, 5, company}).fetch();
        int i = 0;
        for (Reimbursement reimbursement : reimbursementList) {
            this.log.debug("Remboursement n\u00b0 {}", (Object)reimbursement.getRef());
            this.updateReimbursement((Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId())));
        }
        List partnerList = Lists.transform((List)reimbursementList, Reimbursement::getPartner);
        for (Partner partner : partnerList) {
            try {
                Reimbursement reimbursement;
                partner = (Partner)((Object)this.partnerRepository.find(partner.getId()));
                this.log.debug("Tiers n\u00b0 {}", (Object)partner.getName());
                List moveLineList = this.moveLineRepo.all().filter("self.account.useForPartnerBalance = 'true' AND (self.move.statusSelect = ?1 OR self.move.statusSelect = ?2) AND self.amountRemaining > 0 AND self.credit > 0 AND self.partner = ?3 AND self.company = ?4 AND self.reimbursementStatusSelect = ?5 ", new Object[]{3, 2, this.partnerRepository.find(partner.getId()), this.companyRepo.find(company.getId()), 0}).fetch();
                this.log.debug("Liste des trop per\u00e7us : {}", (Object)moveLineList);
                if (moveLineList == null || moveLineList.isEmpty() || (reimbursement = this.reimbursementExportService.runCreateReimbursement(moveLineList, (Company)((Object)this.companyRepo.find(company.getId())), (Partner)((Object)this.partnerRepository.find(partner.getId())))) == null) continue;
                this.updateReimbursement((Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId())));
                this.totalAmount = this.totalAmount.add(((Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId()))).getAmountToReimburse());
                ++i;
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Partner") + "%s", new Object[]{((Partner)((Object)this.partnerRepository.find(partner.getId()))).getName()}), (String)"reimbursement", (long)this.batch.getId());
                this.incrementAnomaly();
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Partner") + "%s", ((Partner)((Object)this.partnerRepository.find(partner.getId()))).getName()), e), (String)"reimbursement", (long)this.batch.getId());
                this.incrementAnomaly();
                this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour le tiers {}", (Object)((Partner)((Object)this.partnerRepository.find(partner.getId()))).getName());
            }
            finally {
                if (i % 10 != 0) continue;
                JPA.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runReimbursementExportProcess(Company company) {
        int i = 0;
        List reimbursementToCancelList = this.reimbursementRepo.all().filter("self.company = ?1 and self.statusSelect = ?2 and self.amountToReimburse = 0", new Object[]{3, company}).fetch();
        for (Reimbursement reimbursement : reimbursementToCancelList) {
            reimbursement.setStatusSelect(5);
        }
        List reimbursementList = this.reimbursementRepo.all().filter("self.company = ?1 and self.statusSelect = ?2 and self.amountToReimburse > 0 AND self.partner", new Object[]{company, 3}).fetch();
        ArrayList<Reimbursement> reimbursementToExport = new ArrayList<Reimbursement>();
        for (Reimbursement reimbursement : reimbursementList) {
            try {
                if (!this.reimbursementExportService.canBeReimbursed((reimbursement = (Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId()))).getPartner(), reimbursement.getCompany())) continue;
                this.reimbursementExportService.reimburse(reimbursement, company);
                this.updateReimbursement((Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId())));
                reimbursementToExport.add(reimbursement);
                this.totalAmount = this.totalAmount.add(((Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId()))).getAmountReimbursed());
                ++i;
            }
            catch (AxelorException e) {
                TraceBackService.trace((AxelorException)new AxelorException((Throwable)e, e.getCategory(), I18n.get((String)"Reimbursement") + " %s", new Object[]{((Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId()))).getRef()}), (String)"reimbursement", (long)this.batch.getId());
                this.incrementAnomaly();
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Reimbursement") + " %s", ((Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId()))).getRef()), e), (String)"reimbursement", (long)this.batch.getId());
                this.incrementAnomaly();
                this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e) pour l'export du remboursement {}", (Object)((Reimbursement)((Object)this.reimbursementRepo.find(reimbursement.getId()))).getRef());
            }
            finally {
                if (i % 10 != 0) continue;
                JPA.clear();
            }
        }
        if (reimbursementToExport != null && !reimbursementToExport.isEmpty()) {
            try {
                this.cfonbExportService.exportCFONB((Company)((Object)this.companyRepo.find(company.getId())), ((Batch)((Object)this.batchRepo.find(this.batch.getId()))).getStartDate(), reimbursementToExport, ((Batch)((Object)this.batchRepo.find(this.batch.getId()))).getAccountingBatch().getBankDetails());
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Bug(Anomaly) generated during SEPA export - Batch %s"), this.batch.getId()), e), (String)"reimbursement", (long)this.batch.getId());
                this.incrementAnomaly();
                this.log.error("Bug(Anomalie) g\u00e9n\u00e9r\u00e9(e)e dans l'export CFONB - Batch {}", (Object)this.batch.getId());
            }
        }
    }

    protected void stop() {
        AccountingService.setUpdateCustomerAccount(true);
        String comment = "";
        this.batch = (Batch)((Object)this.batchRepo.find(this.batch.getId()));
        switch (this.batch.getAccountingBatch().getReimbursementExportTypeSelect()) {
            case 1: {
                comment = I18n.get((String)"Reporting to reimbursement creation :") + "\n";
                comment = comment + String.format("\t* %s " + I18n.get((String)"Reimbursement(s) created") + "\n", this.batch.getDone());
                comment = comment + String.format("\t* " + I18n.get((String)"Total Amount") + " : %s \n", this.totalAmount);
                break;
            }
            case 2: {
                comment = I18n.get((String)"Reporting to reimbursement's export :") + "\n";
                comment = comment + String.format("\t* %s " + I18n.get((String)"Reimbursement(s) treated") + "\n", this.batch.getDone());
                comment = comment + String.format("\t* " + I18n.get((String)"Total Amount") + " : %s \n", this.totalAmount);
                comment = comment + String.format("\t* ------------------------------- \n", new Object[0]);
                comment = comment + String.format("\t* %s ", this.updateCustomerAccountLog);
                break;
            }
        }
        comment = comment + String.format(I18n.get((String)"Alarm batch"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }
}

