/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.debtrecovery;

import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.DebtRecovery;
import com.axelor.apps.account.db.DebtRecoveryConfigLine;
import com.axelor.apps.account.db.DebtRecoveryMethod;
import com.axelor.apps.account.db.DebtRecoveryMethodLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.PaymentScheduleLine;
import com.axelor.apps.account.db.repo.DebtRecoveryRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebtRecoverySessionService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected DebtRecoveryRepository debtRecoveryRepo;
    protected AppAccountService appAccountService;

    @Inject
    public DebtRecoverySessionService(DebtRecoveryRepository debtRecoveryRepo, AppAccountService appAccountService) {
        this.appAccountService = appAccountService;
        this.debtRecoveryRepo = debtRecoveryRepo;
    }

    public DebtRecoveryMethod getDebtRecoveryMethod(DebtRecovery debtRecovery) {
        AccountingSituation accountingSituation = debtRecovery.getAccountingSituation();
        Company company = accountingSituation.getCompany();
        Partner partner = accountingSituation.getPartner();
        List<DebtRecoveryConfigLine> debtRecoveryConfigLines = company.getAccountConfig().getDebtRecoveryConfigLineList();
        for (DebtRecoveryConfigLine debtRecoveryConfigLine : debtRecoveryConfigLines) {
            if (!debtRecoveryConfigLine.getPartnerCategory().equals((Object)partner.getPartnerCategory())) continue;
            this.log.debug("m\u00e9thode de relance determin\u00e9e ");
            return debtRecoveryConfigLine.getDebtRecoveryMethod();
        }
        this.log.debug("m\u00e9thode de relance non determin\u00e9e ");
        return null;
    }

    public DebtRecovery debtRecoverySession(DebtRecovery debtRecovery) throws AxelorException {
        this.log.debug("Begin debtRecoverySession service...");
        LocalDate referenceDate = debtRecovery.getReferenceDate();
        BigDecimal balanceDueDebtRecovery = debtRecovery.getBalanceDueDebtRecovery();
        int debtRecoveryLevel = 0;
        if (debtRecovery.getDebtRecoveryMethodLine() != null && debtRecovery.getDebtRecoveryMethodLine().getDebtRecoveryLevel().getName() != null) {
            debtRecoveryLevel = debtRecovery.getDebtRecoveryMethodLine().getDebtRecoveryLevel().getName();
        }
        int levelMax = this.getMaxLevel(debtRecovery);
        if ((this.appAccountService.getTodayDate(debtRecovery.getCompany()).isAfter(referenceDate) || this.appAccountService.getTodayDate(debtRecovery.getCompany()).isEqual(referenceDate)) && balanceDueDebtRecovery.compareTo(BigDecimal.ZERO) > 0) {
            int theoricalDebtRecoveryLevel;
            this.log.debug("Si la date actuelle est \u00e9gale ou ult\u00e9rieur \u00e0 la date de r\u00e9f\u00e9rence et le solde due relan\u00e7able positif");
            if (debtRecoveryLevel < levelMax) {
                this.log.debug("Sinon ce n'est pas un client \u00e0 haut risque vital");
                theoricalDebtRecoveryLevel = debtRecoveryLevel + 1;
            } else {
                this.log.debug("Sinon c'est un client \u00e0 un haut risque vital");
                theoricalDebtRecoveryLevel = levelMax;
            }
            DebtRecoveryMethodLine debtRecoveryMethodLine = this.getDebtRecoveryMethodLine(debtRecovery, theoricalDebtRecoveryLevel);
            if (!referenceDate.plusDays(debtRecoveryMethodLine.getStandardDeadline().intValue()).isAfter(this.appAccountService.getTodayDate(debtRecovery.getCompany())) && balanceDueDebtRecovery.compareTo(debtRecoveryMethodLine.getMinThreshold()) > 0) {
                this.log.debug("Si le seuil du solde exigible relan\u00e7able est respect\u00e9 et le d\u00e9lai est respect\u00e9");
                if (!debtRecoveryMethodLine.getManualValidationOk().booleanValue()) {
                    this.log.debug("Si le niveau ne necessite pas de validation manuelle");
                    debtRecovery.setDebtRecoveryMethodLine(debtRecoveryMethodLine);
                    debtRecovery.setWaitDebtRecoveryMethodLine(null);
                } else {
                    this.log.debug("Si le niveau necessite une validation manuelle");
                    debtRecovery.setWaitDebtRecoveryMethodLine(debtRecoveryMethodLine);
                }
            }
        } else {
            this.log.debug("Sinon on lance une r\u00e9initialisation");
            this.debtRecoveryInitialization(debtRecovery);
        }
        this.log.debug("End debtRecoverySession service");
        return debtRecovery;
    }

    public int getMaxLevel(DebtRecovery debtRecovery) {
        DebtRecoveryMethod debtRecoveryMethod = debtRecovery.getDebtRecoveryMethod();
        int levelMax = 0;
        if (debtRecoveryMethod != null && debtRecoveryMethod.getDebtRecoveryMethodLineList() != null) {
            for (DebtRecoveryMethodLine debtRecoveryMethodLine : debtRecoveryMethod.getDebtRecoveryMethodLineList()) {
                int currentLevel = debtRecoveryMethodLine.getDebtRecoveryLevel().getName();
                if (currentLevel <= levelMax) continue;
                levelMax = currentLevel;
            }
        }
        return levelMax;
    }

    @Transactional(rollbackOn={Exception.class})
    public void debtRecoveryInitialization(DebtRecovery debtRecovery) throws AxelorException {
        if (debtRecovery != null) {
            this.log.debug("Begin debtRecoveryInitialization service...");
            debtRecovery.setDebtRecoveryMethodLine(null);
            debtRecovery.setWaitDebtRecoveryMethodLine(null);
            debtRecovery.setBalanceDue(BigDecimal.ZERO);
            debtRecovery.setBalanceDueDebtRecovery(BigDecimal.ZERO);
            debtRecovery.setInvoiceDebtRecoverySet(new HashSet<Invoice>());
            debtRecovery.setPaymentScheduleLineDebtRecoverySet(new HashSet<PaymentScheduleLine>());
            this.log.debug("End debtRecoveryInitialization service");
            this.debtRecoveryRepo.save((Model)((Object)debtRecovery));
        }
    }

    public List<DebtRecoveryMethodLine> getDebtRecoveryMethodLineList(DebtRecovery debtRecovery) {
        return debtRecovery.getDebtRecoveryMethod().getDebtRecoveryMethodLineList();
    }

    public DebtRecoveryMethodLine getDebtRecoveryMethodLine(DebtRecovery debtRecovery, int debtRecoveryLevel) throws AxelorException {
        if (debtRecovery.getDebtRecoveryMethod() == null || debtRecovery.getDebtRecoveryMethod().getDebtRecoveryMethodLineList() == null || debtRecovery.getDebtRecoveryMethod().getDebtRecoveryMethodLineList().isEmpty()) {
            throw new AxelorException((Model)((Object)debtRecovery), 1, "%s :\n" + I18n.get((String)"Partner") + " %s: +" + I18n.get((String)"Debt recovery method line missing."), new Object[]{I18n.get((String)"Warning !"), debtRecovery.getAccountingSituation().getPartner().getName()});
        }
        for (DebtRecoveryMethodLine debtRecoveryMethodLine : debtRecovery.getDebtRecoveryMethod().getDebtRecoveryMethodLineList()) {
            if (!debtRecoveryMethodLine.getDebtRecoveryLevel().getName().equals(debtRecoveryLevel)) continue;
            return debtRecoveryMethodLine;
        }
        throw new AxelorException((Model)((Object)debtRecovery), 4, I18n.get((String)"Debt recovery method line not found"));
    }
}

