/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.debtrecovery;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.FiscalPositionAccountService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubtfulCustomerService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveService moveService;
    protected MoveRepository moveRepo;
    protected MoveLineService moveLineService;
    protected MoveLineRepository moveLineRepo;
    protected ReconcileService reconcileService;
    protected AccountConfigService accountConfigService;
    protected AppBaseService appBaseService;

    @Inject
    public DoubtfulCustomerService(MoveService moveService, MoveRepository moveRepo, MoveLineService moveLineService, MoveLineRepository moveLineRepo, ReconcileService reconcileService, AccountConfigService accountConfigService, AppBaseService appBaseService) {
        this.moveService = moveService;
        this.moveRepo = moveRepo;
        this.moveLineService = moveLineService;
        this.moveLineRepo = moveLineRepo;
        this.reconcileService = reconcileService;
        this.accountConfigService = accountConfigService;
        this.appBaseService = appBaseService;
    }

    public void testCompanyField(Company company) throws AxelorException {
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        this.accountConfigService.getDoubtfulCustomerAccount(accountConfig);
        this.accountConfigService.getAutoMiscOpeJournal(accountConfig);
        this.accountConfigService.getSixMonthDebtPassReason(accountConfig);
        this.accountConfigService.getThreeMonthDebtPassReason(accountConfig);
    }

    public void createDoubtFulCustomerMove(List<Move> moveList, Account doubtfulCustomerAccount, String debtPassReason) throws AxelorException {
        for (Move move : moveList) {
            this.createDoubtFulCustomerMove(move, doubtfulCustomerAccount, debtPassReason);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void createDoubtFulCustomerMove(Move move, Account doubtfulCustomerAccount, String debtPassReason) throws AxelorException {
        this.log.debug("Concerned account move : {} ", (Object)move.getReference());
        Company company = move.getCompany();
        Partner partner = move.getPartner();
        Invoice invoice = move.getInvoice();
        Move newMove = this.moveService.getMoveCreateService().createMove(company.getAccountConfig().getAutoMiscOpeJournal(), company, invoice.getCurrency(), partner, move.getPaymentMode(), 2);
        newMove.setInvoice(invoice);
        LocalDate todayDate = this.appBaseService.getTodayDate(company);
        MoveLine invoicePartnerMoveLine = null;
        for (MoveLine moveLine : move.getMoveLineList()) {
            if (!moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0 || moveLine.getAccount() == doubtfulCustomerAccount || moveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0) continue;
            invoicePartnerMoveLine = moveLine;
        }
        BigDecimal amountRemaining = invoicePartnerMoveLine.getAmountRemaining();
        MoveLine creditMoveLine = this.moveLineService.createMoveLine(newMove, partner, invoicePartnerMoveLine.getAccount(), amountRemaining, false, todayDate, 1, move.getInvoice().getInvoiceId(), debtPassReason);
        newMove.getMoveLineList().add(creditMoveLine);
        MoveLine debitMoveLine = this.moveLineService.createMoveLine(newMove, partner, doubtfulCustomerAccount, amountRemaining, true, todayDate, 2, creditMoveLine.getOrigin(), debtPassReason);
        newMove.getMoveLineList().add(debitMoveLine);
        debitMoveLine.setPassageReason(debtPassReason);
        this.moveService.getMoveValidateService().validate(newMove);
        this.moveRepo.save((Model)((Object)newMove));
        Reconcile reconcile = this.reconcileService.createReconcile(invoicePartnerMoveLine, creditMoveLine, amountRemaining, false);
        if (reconcile != null) {
            this.reconcileService.confirmReconcile(reconcile, true);
        }
        this.invoiceProcess(newMove, doubtfulCustomerAccount, debtPassReason);
    }

    public void createDoubtFulCustomerRejectMove(List<MoveLine> moveLineList, Account doubtfulCustomerAccount, String debtPassReason) throws AxelorException {
        for (MoveLine moveLine : moveLineList) {
            this.createDoubtFulCustomerRejectMove(moveLine, doubtfulCustomerAccount, debtPassReason);
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void createDoubtFulCustomerRejectMove(MoveLine moveLine, Account doubtfulCustomerAccount, String debtPassReason) throws AxelorException {
        this.log.debug("Ecriture concern\u00e9e : {} ", (Object)moveLine.getName());
        Company company = moveLine.getMove().getCompany();
        Partner partner = moveLine.getPartner();
        LocalDate todayDate = this.appBaseService.getTodayDate(company);
        Move newMove = this.moveService.getMoveCreateService().createMove(company.getAccountConfig().getAutoMiscOpeJournal(), company, null, partner, moveLine.getMove().getPaymentMode(), 2);
        BigDecimal amountRemaining = moveLine.getAmountRemaining();
        MoveLine creditMoveLine = this.moveLineService.createMoveLine(newMove, partner, moveLine.getAccount(), amountRemaining, false, todayDate, 1, moveLine.getName(), debtPassReason);
        newMove.addMoveLineListItem(creditMoveLine);
        Reconcile reconcile = this.reconcileService.createReconcile(moveLine, creditMoveLine, amountRemaining, false);
        if (reconcile != null) {
            this.reconcileService.confirmReconcile(reconcile, true);
        }
        MoveLine debitMoveLine = this.moveLineService.createMoveLine(newMove, newMove.getPartner(), doubtfulCustomerAccount, amountRemaining, true, todayDate, 2, moveLine.getName(), debtPassReason);
        newMove.getMoveLineList().add(debitMoveLine);
        debitMoveLine.setInvoiceReject(moveLine.getInvoiceReject());
        debitMoveLine.setPassageReason(debtPassReason);
        this.moveService.getMoveValidateService().validate(newMove);
        this.moveRepo.save((Model)((Object)newMove));
        this.invoiceRejectProcess(debitMoveLine, doubtfulCustomerAccount, debtPassReason);
    }

    public void updateDoubtfulCustomerMove(List<Move> moveList, Account doubtfulCustomerAccount, String debtPassReason) {
        block0: for (Move move : moveList) {
            for (MoveLine moveLine : move.getMoveLineList()) {
                if (!moveLine.getAccount().equals((Object)doubtfulCustomerAccount) || moveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0) continue;
                moveLine.setPassageReason(debtPassReason);
                this.moveLineRepo.save((Model)((Object)moveLine));
                continue block0;
            }
        }
    }

    public Invoice invoiceProcess(Move move, Account doubtfulCustomerAccount, String debtPassReason) throws AxelorException {
        Invoice invoice = move.getInvoice();
        if (invoice != null) {
            invoice.setOldMove(invoice.getMove());
            invoice.setMove(move);
            if (invoice.getPartner() != null) {
                doubtfulCustomerAccount = ((FiscalPositionAccountService)Beans.get(FiscalPositionAccountService.class)).getAccount(invoice.getPartner().getFiscalPosition(), doubtfulCustomerAccount);
            }
            invoice.setPartnerAccount(doubtfulCustomerAccount);
            invoice.setDoubtfulCustomerOk(true);
            invoice.setCompanyInTaxTotalRemaining(this.moveService.getMoveToolService().getInTaxTotalRemaining(invoice));
        }
        return invoice;
    }

    public Invoice invoiceRejectProcess(MoveLine moveLine, Account doubtfulCustomerAccount, String debtPassReason) {
        Invoice invoice = moveLine.getInvoiceReject();
        invoice.setRejectMoveLine(moveLine);
        invoice.setDoubtfulCustomerOk(true);
        return invoice;
    }

    public List<Move> getMove(int rule, Account doubtfulCustomerAccount, Company company) {
        LocalDate date = null;
        switch (rule) {
            case 0: {
                date = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(company).minusMonths(company.getAccountConfig().getSixMonthDebtMonthNumber().intValue());
                break;
            }
            case 1: {
                date = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(company).minusMonths(company.getAccountConfig().getThreeMonthDebtMontsNumber().intValue());
                break;
            }
        }
        this.log.debug("Date de cr\u00e9ance prise en compte : {} ", date);
        String request = "SELECT DISTINCT m FROM MoveLine ml, Move m WHERE ml.move = m AND m.company.id = " + company.getId() + " AND ml.account.useForPartnerBalance = true AND m.invoice IS NOT NULL AND ml.amountRemaining > 0.00 AND ml.debit > 0.00 AND ml.dueDate < '" + date.toString() + "' AND ml.account.id != " + doubtfulCustomerAccount.getId() + " AND m.invoice.operationTypeSelect = " + 3;
        this.log.debug("Requete : {} ", (Object)request);
        Query query = JPA.em().createQuery(request);
        List moveList = query.getResultList();
        return moveList;
    }

    public List<? extends MoveLine> getRejectMoveLine(int rule, Account doubtfulCustomerAccount, Company company) {
        LocalDate date = null;
        List moveLineList = null;
        switch (rule) {
            case 0: {
                date = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(company).minusMonths(company.getAccountConfig().getSixMonthDebtMonthNumber().intValue());
                moveLineList = this.moveLineRepo.all().filter("self.move.company = ?1 AND self.account.useForPartnerBalance = 'true' AND self.invoiceReject IS NOT NULL AND self.amountRemaining > 0.00 AND self.debit > 0.00 AND self.dueDate < ?2 AND self.account != ?3 AND self.invoiceReject.operationTypeSelect = ?4", new Object[]{company, date, doubtfulCustomerAccount, 3}).fetch();
                break;
            }
            case 1: {
                date = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(company).minusMonths(company.getAccountConfig().getThreeMonthDebtMontsNumber().intValue());
                moveLineList = this.moveLineRepo.all().filter("self.move.company = ?1 AND self.account.useForPartnerBalance = 'true' AND self.invoiceReject IS NOT NULL AND self.amountRemaining > 0.00 AND self.debit > 0.00 AND self.dueDate < ?2 AND self.account != ?3 AND self.invoiceReject.operationTypeSelect = ?4", new Object[]{company, date, doubtfulCustomerAccount, 3}).fetch();
                break;
            }
        }
        this.log.debug("Date de cr\u00e9ance prise en compte : {} ", date);
        return moveLineList;
    }
}

