/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice;

import com.axelor.apps.account.db.InvoiceBatch;
import com.axelor.apps.account.db.repo.InvoiceBatchRepository;
import com.axelor.apps.account.service.invoice.generator.batch.BatchStrategy;
import com.axelor.apps.account.service.invoice.generator.batch.BatchValidation;
import com.axelor.apps.account.service.invoice.generator.batch.BatchVentilation;
import com.axelor.apps.base.db.Batch;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;

public class InvoiceBatchService {
    protected InvoiceBatchRepository invoiceBatchRepo;

    @Inject
    public InvoiceBatchService(InvoiceBatchRepository invoiceBatchRepo) {
        this.invoiceBatchRepo = invoiceBatchRepo;
    }

    public Batch run(String batchCode) throws AxelorException {
        Batch batch;
        block4: {
            block3: {
                InvoiceBatch invoiceBatch = this.invoiceBatchRepo.findByCode(batchCode);
                if (invoiceBatch == null) break block3;
                switch (invoiceBatch.getActionSelect()) {
                    case 1: {
                        batch = this.wkf(invoiceBatch);
                        break block4;
                    }
                    default: {
                        throw new AxelorException(5, I18n.get((String)"Unknown action %s for the %s treatment"), new Object[]{invoiceBatch.getActionSelect(), batchCode});
                    }
                }
            }
            throw new AxelorException(5, I18n.get((String)"Batch %s unknown"), new Object[]{batchCode});
        }
        return batch;
    }

    public Batch wkf(InvoiceBatch invoiceBatch) throws AxelorException {
        BatchStrategy strategy = null;
        if (invoiceBatch.getToStatusSelect().equals(2)) {
            strategy = (BatchStrategy)((Object)Beans.get(BatchValidation.class));
        } else if (invoiceBatch.getToStatusSelect().equals(3)) {
            strategy = (BatchStrategy)((Object)Beans.get(BatchVentilation.class));
        } else {
            throw new AxelorException(5, I18n.get((String)"State %s unknown for treatment %s"), new Object[]{invoiceBatch.getToStatusSelect(), invoiceBatch.getCode()});
        }
        return strategy.run(invoiceBatch);
    }
}

