/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice;

import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PriceListLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.exception.AxelorException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public interface InvoiceLineService {
    public List<AnalyticMoveLine> getAndComputeAnalyticDistribution(InvoiceLine var1, Invoice var2) throws AxelorException;

    public List<AnalyticMoveLine> computeAnalyticDistribution(InvoiceLine var1) throws AxelorException;

    public List<AnalyticMoveLine> createAnalyticDistributionWithTemplate(InvoiceLine var1) throws AxelorException;

    public TaxLine getTaxLine(Invoice var1, InvoiceLine var2, boolean var3) throws AxelorException;

    public BigDecimal getExTaxUnitPrice(Invoice var1, InvoiceLine var2, TaxLine var3, boolean var4) throws AxelorException;

    public BigDecimal getInTaxUnitPrice(Invoice var1, InvoiceLine var2, TaxLine var3, boolean var4) throws AxelorException;

    public BigDecimal getAccountingExTaxTotal(BigDecimal var1, Invoice var2) throws AxelorException;

    public BigDecimal getCompanyExTaxTotal(BigDecimal var1, Invoice var2) throws AxelorException;

    public PriceListLine getPriceListLine(InvoiceLine var1, PriceList var2, BigDecimal var3);

    public BigDecimal computeDiscount(InvoiceLine var1, Boolean var2);

    public BigDecimal convertUnitPrice(Boolean var1, TaxLine var2, BigDecimal var3);

    public Map<String, Object> getDiscount(Invoice var1, InvoiceLine var2, BigDecimal var3) throws AxelorException;

    public Map<String, Object> getDiscountsFromPriceLists(Invoice var1, InvoiceLine var2, BigDecimal var3);

    public int getDiscountTypeSelect(Invoice var1, InvoiceLine var2, BigDecimal var3);

    public Unit getUnit(Product var1, boolean var2);

    public Map<String, Object> resetProductInformation(Invoice var1) throws AxelorException;

    public Map<String, Object> fillProductInformation(Invoice var1, InvoiceLine var2) throws AxelorException;

    public Map<String, Object> fillPriceAndAccount(Invoice var1, InvoiceLine var2, boolean var3) throws AxelorException;
}

