/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.FiscalPosition;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.service.AccountManagementAccountService;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PriceListLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.PriceListService;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.tax.FiscalPositionService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.common.base.MoreObjects;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class InvoiceLineServiceImpl
implements InvoiceLineService {
    protected AccountManagementAccountService accountManagementAccountService;
    protected CurrencyService currencyService;
    protected PriceListService priceListService;
    protected AppAccountService appAccountService;
    protected AnalyticMoveLineService analyticMoveLineService;
    protected ProductCompanyService productCompanyService;

    @Inject
    public InvoiceLineServiceImpl(CurrencyService currencyService, PriceListService priceListService, AppAccountService appAccountService, AnalyticMoveLineService analyticMoveLineService, AccountManagementAccountService accountManagementAccountService, ProductCompanyService productCompanyService) {
        this.accountManagementAccountService = accountManagementAccountService;
        this.currencyService = currencyService;
        this.priceListService = priceListService;
        this.appAccountService = appAccountService;
        this.analyticMoveLineService = analyticMoveLineService;
        this.productCompanyService = productCompanyService;
    }

    @Override
    public List<AnalyticMoveLine> getAndComputeAnalyticDistribution(InvoiceLine invoiceLine, Invoice invoice) {
        if (this.appAccountService.getAppAccount().getAnalyticDistributionTypeSelect() == 1) {
            return (List)MoreObjects.firstNonNull(invoiceLine.getAnalyticMoveLineList(), new ArrayList());
        }
        AnalyticDistributionTemplate analyticDistributionTemplate = this.analyticMoveLineService.getAnalyticDistributionTemplate(invoice.getPartner(), invoiceLine.getProduct(), invoice.getCompany());
        invoiceLine.setAnalyticDistributionTemplate(analyticDistributionTemplate);
        if (invoiceLine.getAnalyticMoveLineList() != null) {
            invoiceLine.getAnalyticMoveLineList().clear();
        }
        return this.computeAnalyticDistribution(invoiceLine);
    }

    @Override
    public List<AnalyticMoveLine> computeAnalyticDistribution(InvoiceLine invoiceLine) {
        List<AnalyticMoveLine> analyticMoveLineList = invoiceLine.getAnalyticMoveLineList();
        if (analyticMoveLineList == null || analyticMoveLineList.isEmpty()) {
            return this.createAnalyticDistributionWithTemplate(invoiceLine);
        }
        LocalDate date = this.appAccountService.getTodayDate(invoiceLine.getInvoice() != null ? invoiceLine.getInvoice().getCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null));
        if (invoiceLine.getAnalyticMoveLineList() != null) {
            for (AnalyticMoveLine analyticMoveLine : analyticMoveLineList) {
                this.analyticMoveLineService.updateAnalyticMoveLine(analyticMoveLine, invoiceLine.getCompanyExTaxTotal(), date);
            }
        }
        return analyticMoveLineList;
    }

    @Override
    public List<AnalyticMoveLine> createAnalyticDistributionWithTemplate(InvoiceLine invoiceLine) {
        List<AnalyticMoveLine> analyticMoveLineList = this.analyticMoveLineService.generateLines(invoiceLine.getAnalyticDistributionTemplate(), invoiceLine.getCompanyExTaxTotal(), 2, this.appAccountService.getTodayDate(invoiceLine.getInvoice() != null ? invoiceLine.getInvoice().getCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)));
        return analyticMoveLineList;
    }

    @Override
    public TaxLine getTaxLine(Invoice invoice, InvoiceLine invoiceLine, boolean isPurchase) throws AxelorException {
        return this.accountManagementAccountService.getTaxLine(this.appAccountService.getTodayDate(invoice.getCompany()), invoiceLine.getProduct(), invoice.getCompany(), invoice.getPartner().getFiscalPosition(), isPurchase);
    }

    @Override
    public BigDecimal getExTaxUnitPrice(Invoice invoice, InvoiceLine invoiceLine, TaxLine taxLine, boolean isPurchase) throws AxelorException {
        return this.getUnitPrice(invoice, invoiceLine, taxLine, isPurchase, false);
    }

    @Override
    public BigDecimal getInTaxUnitPrice(Invoice invoice, InvoiceLine invoiceLine, TaxLine taxLine, boolean isPurchase) throws AxelorException {
        return this.getUnitPrice(invoice, invoiceLine, taxLine, isPurchase, true);
    }

    private BigDecimal getUnitPrice(Invoice invoice, InvoiceLine invoiceLine, TaxLine taxLine, boolean isPurchase, boolean resultInAti) throws AxelorException {
        Currency productCurrency;
        Product product = invoiceLine.getProduct();
        BigDecimal price = null;
        if (isPurchase) {
            price = (BigDecimal)this.productCompanyService.get(product, "purchasePrice", invoice.getCompany());
            productCurrency = (Currency)this.productCompanyService.get(product, "purchaseCurrency", invoice.getCompany());
        } else {
            price = (BigDecimal)this.productCompanyService.get(product, "salePrice", invoice.getCompany());
            productCurrency = (Currency)this.productCompanyService.get(product, "saleCurrency", invoice.getCompany());
        }
        if ((Boolean)this.productCompanyService.get(product, "inAti", invoice.getCompany()) != resultInAti) {
            price = this.convertUnitPrice((Boolean)this.productCompanyService.get(product, "inAti", invoice.getCompany()), taxLine, price);
        }
        return this.currencyService.getAmountCurrencyConvertedAtDate(productCurrency, invoice.getCurrency(), price, invoice.getInvoiceDate()).setScale(this.appAccountService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getAccountingExTaxTotal(BigDecimal exTaxTotal, Invoice invoice) throws AxelorException {
        return this.currencyService.getAmountCurrencyConvertedAtDate(invoice.getCurrency(), invoice.getPartner().getCurrency(), exTaxTotal, invoice.getInvoiceDate()).setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getCompanyExTaxTotal(BigDecimal exTaxTotal, Invoice invoice) throws AxelorException {
        return this.currencyService.getAmountCurrencyConvertedAtDate(invoice.getCurrency(), invoice.getCompany().getCurrency(), exTaxTotal, invoice.getInvoiceDate()).setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public PriceListLine getPriceListLine(InvoiceLine invoiceLine, PriceList priceList, BigDecimal price) {
        return this.priceListService.getPriceListLine(invoiceLine.getProduct(), invoiceLine.getQty(), priceList, price);
    }

    @Override
    public BigDecimal computeDiscount(InvoiceLine invoiceLine, Boolean inAti) {
        BigDecimal unitPrice = inAti != false ? invoiceLine.getInTaxPrice() : invoiceLine.getPrice();
        return this.priceListService.computeDiscount(unitPrice, invoiceLine.getDiscountTypeSelect().intValue(), invoiceLine.getDiscountAmount());
    }

    @Override
    public BigDecimal convertUnitPrice(Boolean priceIsAti, TaxLine taxLine, BigDecimal price) {
        if (taxLine == null) {
            return price;
        }
        price = priceIsAti != false ? price.divide(taxLine.getValue().add(BigDecimal.ONE), 2, 4) : price.add(price.multiply(taxLine.getValue()));
        return price;
    }

    @Override
    public Map<String, Object> getDiscount(Invoice invoice, InvoiceLine invoiceLine, BigDecimal price) throws AxelorException {
        Map<String, Object> rawDiscounts = this.getDiscountsFromPriceLists(invoice, invoiceLine, price);
        HashMap<String, Object> processedDiscounts = new HashMap<String, Object>();
        if (rawDiscounts != null) {
            if (rawDiscounts.get("price") != null) {
                price = (BigDecimal)rawDiscounts.get("price");
            }
            if (invoiceLine.getProduct().getInAti() != invoice.getInAti() && (Integer)rawDiscounts.get("discountTypeSelect") != 1) {
                processedDiscounts.put("discountAmount", this.convertUnitPrice(invoiceLine.getProduct().getInAti(), invoiceLine.getTaxLine(), (BigDecimal)rawDiscounts.get("discountAmount")));
            } else {
                processedDiscounts.put("discountAmount", rawDiscounts.get("discountAmount"));
            }
            processedDiscounts.put("discountTypeSelect", rawDiscounts.get("discountTypeSelect"));
        }
        if (price.compareTo(invoiceLine.getProduct().getInAti() != false ? invoiceLine.getInTaxPrice() : invoiceLine.getPrice()) != 0) {
            if (invoiceLine.getProduct().getInAti().booleanValue()) {
                processedDiscounts.put("inTaxPrice", price);
                processedDiscounts.put("price", this.convertUnitPrice(true, invoiceLine.getTaxLine(), price));
            } else {
                processedDiscounts.put("price", price);
                processedDiscounts.put("inTaxPrice", this.convertUnitPrice(false, invoiceLine.getTaxLine(), price));
            }
        }
        return processedDiscounts;
    }

    @Override
    public Map<String, Object> getDiscountsFromPriceLists(Invoice invoice, InvoiceLine invoiceLine, BigDecimal price) {
        Map discounts = null;
        PriceList priceList = invoice.getPriceList();
        if (priceList != null) {
            PriceListLine priceListLine = this.getPriceListLine(invoiceLine, priceList, price);
            discounts = this.priceListService.getReplacedPriceAndDiscounts(priceList, priceListLine, price);
        }
        return discounts;
    }

    @Override
    public int getDiscountTypeSelect(Invoice invoice, InvoiceLine invoiceLine, BigDecimal price) {
        PriceList priceList = invoice.getPriceList();
        if (priceList != null) {
            PriceListLine priceListLine = this.getPriceListLine(invoiceLine, priceList, price);
            return priceListLine.getTypeSelect();
        }
        return 0;
    }

    @Override
    public Unit getUnit(Product product, boolean isPurchase) {
        return product.getUnit();
    }

    @Override
    public Map<String, Object> resetProductInformation(Invoice invoice) throws AxelorException {
        HashMap<String, Object> productInformation = new HashMap<String, Object>();
        productInformation.put("taxLine", null);
        productInformation.put("taxEquiv", null);
        productInformation.put("taxCode", null);
        productInformation.put("taxRate", null);
        productInformation.put("productName", null);
        productInformation.put("unit", null);
        productInformation.put("discountAmount", null);
        productInformation.put("discountTypeSelect", 0);
        productInformation.put("price", null);
        productInformation.put("inTaxPrice", null);
        productInformation.put("exTaxTotal", null);
        productInformation.put("inTaxTotal", null);
        productInformation.put("companyInTaxTotal", null);
        productInformation.put("companyExTaxTotal", null);
        productInformation.put("typeSelect", 0);
        boolean isPurchase = InvoiceToolService.isPurchase(invoice);
        if (isPurchase && this.appAccountService.getAppInvoice().getIsEnabledProductDescriptionCopyForCustomers().booleanValue() || !isPurchase && this.appAccountService.getAppInvoice().getIsEnabledProductDescriptionCopyForSuppliers().booleanValue()) {
            productInformation.put("description", null);
        }
        if (this.appAccountService.getAppAccount().getAnalyticDistributionTypeSelect() == 3) {
            productInformation.put("analyticMoveLineList", null);
        }
        return productInformation;
    }

    @Override
    public Map<String, Object> fillProductInformation(Invoice invoice, InvoiceLine invoiceLine) throws AxelorException {
        boolean isPurchase = InvoiceToolService.isPurchase(invoice);
        Map<String, Object> productInformation = this.fillPriceAndAccount(invoice, invoiceLine, isPurchase);
        productInformation.put("productName", invoiceLine.getProduct().getName());
        productInformation.put("productCode", invoiceLine.getProduct().getCode());
        productInformation.put("unit", this.getUnit(invoiceLine.getProduct(), isPurchase));
        if (isPurchase && this.appAccountService.getAppInvoice().getIsEnabledProductDescriptionCopyForCustomers().booleanValue() || !isPurchase && this.appAccountService.getAppInvoice().getIsEnabledProductDescriptionCopyForSuppliers().booleanValue()) {
            productInformation.put("description", invoiceLine.getProduct().getDescription());
        }
        return productInformation;
    }

    @Override
    public Map<String, Object> fillPriceAndAccount(Invoice invoice, InvoiceLine invoiceLine, boolean isPurchase) throws AxelorException {
        Map<String, Object> productInformation = this.resetProductInformation(invoice);
        Product product = invoiceLine.getProduct();
        TaxLine taxLine = null;
        Company company = invoice.getCompany();
        FiscalPosition fiscalPosition = invoice.getPartner().getFiscalPosition();
        try {
            taxLine = this.getTaxLine(invoice, invoiceLine, isPurchase);
            invoiceLine.setTaxLine(taxLine);
            productInformation.put("taxLine", taxLine);
            productInformation.put("taxRate", taxLine.getValue());
            productInformation.put("taxCode", taxLine.getTax().getCode());
            Tax tax = this.accountManagementAccountService.getProductTax(product, company, null, isPurchase);
            TaxEquiv taxEquiv = ((FiscalPositionService)Beans.get(FiscalPositionService.class)).getTaxEquiv(fiscalPosition, tax);
            productInformation.put("taxEquiv", taxEquiv);
            Account account = this.accountManagementAccountService.getProductAccount(product, company, fiscalPosition, isPurchase, invoiceLine.getFixedAssets());
            productInformation.put("account", (Object)account);
        }
        catch (AxelorException e) {
            productInformation.put("error", e.getMessage());
        }
        BigDecimal price = this.getExTaxUnitPrice(invoice, invoiceLine, taxLine, isPurchase);
        BigDecimal inTaxPrice = this.getInTaxUnitPrice(invoice, invoiceLine, taxLine, isPurchase);
        productInformation.put("price", price);
        productInformation.put("inTaxPrice", inTaxPrice);
        productInformation.putAll(this.getDiscount(invoice, invoiceLine, product.getInAti() != false ? inTaxPrice : price));
        productInformation.put("productName", invoiceLine.getProduct().getName());
        return productInformation;
    }
}

