/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.SubstitutePfpValidator;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.factory.CancelFactory;
import com.axelor.apps.account.service.invoice.factory.ValidateFactory;
import com.axelor.apps.account.service.invoice.factory.VentilateFactory;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.account.service.invoice.generator.invoice.RefundInvoice;
import com.axelor.apps.account.service.invoice.print.InvoicePrintService;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentToolService;
import com.axelor.apps.base.db.Alarm;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.repo.BankDetailsRepository;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.alarm.AlarmEngineService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.tool.ModelTool;
import com.axelor.apps.tool.StringTool;
import com.axelor.apps.tool.ThrowConsumer;
import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceServiceImpl
extends InvoiceRepository
implements InvoiceService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ValidateFactory validateFactory;
    protected VentilateFactory ventilateFactory;
    protected CancelFactory cancelFactory;
    protected AlarmEngineService<Invoice> alarmEngineService;
    protected InvoiceRepository invoiceRepo;
    protected AppAccountService appAccountService;
    protected PartnerService partnerService;
    protected InvoiceLineService invoiceLineService;
    protected AccountConfigService accountConfigService;
    protected MoveToolService moveToolService;

    @Inject
    public InvoiceServiceImpl(ValidateFactory validateFactory, VentilateFactory ventilateFactory, CancelFactory cancelFactory, AlarmEngineService<Invoice> alarmEngineService, InvoiceRepository invoiceRepo, AppAccountService appAccountService, PartnerService partnerService, InvoiceLineService invoiceLineService, AccountConfigService accountConfigService, MoveToolService moveToolService) {
        this.validateFactory = validateFactory;
        this.ventilateFactory = ventilateFactory;
        this.cancelFactory = cancelFactory;
        this.alarmEngineService = alarmEngineService;
        this.invoiceRepo = invoiceRepo;
        this.appAccountService = appAccountService;
        this.partnerService = partnerService;
        this.invoiceLineService = invoiceLineService;
        this.accountConfigService = accountConfigService;
        this.moveToolService = moveToolService;
    }

    @Override
    public Map<Invoice, List<Alarm>> getAlarms(Invoice ... invoices) {
        return this.alarmEngineService.get(Invoice.class, (Model[])invoices);
    }

    @Override
    public void raisingAlarms(Invoice invoice, String alarmEngineCode) {
        Alarm alarm = this.alarmEngineService.get(alarmEngineCode, (Model)((Object)invoice), true);
        if (alarm != null) {
            alarm.setInvoice(invoice);
        }
    }

    @Override
    public Account getPartnerAccount(Invoice invoice) throws AxelorException {
        if (invoice.getCompany() == null || invoice.getOperationTypeSelect() == null || invoice.getOperationTypeSelect() == 0 || invoice.getPartner() == null) {
            return null;
        }
        AccountingSituationService situationService = (AccountingSituationService)Beans.get(AccountingSituationService.class);
        return InvoiceToolService.isPurchase(invoice) ? situationService.getSupplierAccount(invoice.getPartner(), invoice.getCompany()) : situationService.getCustomerAccount(invoice.getPartner(), invoice.getCompany());
    }

    @Override
    public Journal getJournal(Invoice invoice) throws AxelorException {
        Company company = invoice.getCompany();
        if (company == null) {
            return null;
        }
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        switch (invoice.getOperationTypeSelect()) {
            case 1: {
                return invoice.getInTaxTotal().signum() < 0 ? this.accountConfigService.getSupplierCreditNoteJournal(accountConfig) : this.accountConfigService.getSupplierPurchaseJournal(accountConfig);
            }
            case 2: {
                return invoice.getInTaxTotal().signum() < 0 ? this.accountConfigService.getSupplierPurchaseJournal(accountConfig) : this.accountConfigService.getSupplierCreditNoteJournal(accountConfig);
            }
            case 3: {
                return invoice.getInTaxTotal().signum() < 0 ? this.accountConfigService.getCustomerCreditNoteJournal(accountConfig) : this.accountConfigService.getCustomerSalesJournal(accountConfig);
            }
            case 4: {
                return invoice.getInTaxTotal().signum() < 0 ? this.accountConfigService.getCustomerSalesJournal(accountConfig) : this.accountConfigService.getCustomerCreditNoteJournal(accountConfig);
            }
        }
        throw new AxelorException((Model)((Object)invoice), 1, I18n.get((String)"Invoice type missing on invoice %s"), new Object[]{invoice.getInvoiceId()});
    }

    @Override
    public Invoice compute(final Invoice invoice) throws AxelorException {
        this.log.debug("Calcul de la facture");
        InvoiceGenerator invoiceGenerator = new InvoiceGenerator(){

            @Override
            public Invoice generate() throws AxelorException {
                ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
                invoiceLines.addAll(invoice.getInvoiceLineList());
                this.populate(invoice, invoiceLines);
                return invoice;
            }
        };
        Invoice invoice1 = invoiceGenerator.generate();
        invoice1.setAdvancePaymentInvoiceSet(this.getDefaultAdvancePaymentInvoice(invoice1));
        return invoice1;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validateAndVentilate(Invoice invoice) throws AxelorException {
        this.validate(invoice);
        this.ventilate(invoice);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validate(Invoice invoice) throws AxelorException {
        this.log.debug("Validation de la facture");
        this.compute(invoice);
        this.validateFactory.getValidator(invoice).process();
        if (invoice.getOperationSubTypeSelect() == 2) {
            this.ventilate(invoice);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void ventilate(Invoice invoice) throws AxelorException {
        if (invoice.getPaymentCondition() == null) {
            throw new AxelorException(1, I18n.get((String)"%s : Payment condition missing"), new Object[]{I18n.get((String)"Warning !")});
        }
        if (invoice.getPaymentMode() == null) {
            throw new AxelorException(1, I18n.get((String)"%s : Payment mode missing"), new Object[]{I18n.get((String)"Warning !")});
        }
        for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
            Account account = invoiceLine.getAccount();
            if (invoiceLine.getAccount() == null && invoiceLine.getTypeSelect() == 0) {
                throw new AxelorException((Model)((Object)invoice), 1, I18n.get((String)"The account of a product could not be determined or is not filled. Please fill the missing account on invoice line %s"), new Object[]{invoiceLine.getProductName()});
            }
            if (account == null || account.getAnalyticDistributionAuthorized().booleanValue() || invoiceLine.getAnalyticDistributionTemplate() == null && (invoiceLine.getAnalyticMoveLineList() == null || invoiceLine.getAnalyticMoveLineList().isEmpty())) continue;
            throw new AxelorException((Model)((Object)invoice), 4, I18n.get((String)"An analytic distribution is set in product but the account used do not allow analytic distribution"));
        }
        this.log.debug("Ventilation de la facture {}", (Object)invoice.getInvoiceId());
        this.ventilateFactory.getVentilator(invoice).process();
        this.invoiceRepo.save((Model)((Object)invoice));
        if (this.checkEnablePDFGenerationOnVentilation(invoice)) {
            ((InvoicePrintService)Beans.get(InvoicePrintService.class)).printAndSave(invoice, 2, "pdf", null);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancel(Invoice invoice) throws AxelorException {
        this.log.debug("Annulation de la facture {}", (Object)invoice.getInvoiceId());
        this.cancelFactory.getCanceller(invoice).process();
        this.invoiceRepo.save((Model)((Object)invoice));
    }

    @Override
    @Transactional
    public void usherProcess(Invoice invoice) {
        Move move = invoice.getMove();
        if (move != null) {
            if (invoice.getUsherPassageOk().booleanValue()) {
                for (MoveLine moveLine : move.getMoveLineList()) {
                    moveLine.setUsherPassageOk(true);
                }
            } else {
                for (MoveLine moveLine : move.getMoveLineList()) {
                    moveLine.setUsherPassageOk(false);
                }
            }
            ((MoveRepository)((Object)Beans.get(MoveRepository.class))).save((Model)((Object)move));
        }
    }

    @Override
    public String checkNotImputedRefunds(Invoice invoice) throws AxelorException {
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(invoice.getCompany());
        if (!accountConfig.getAutoReconcileOnInvoice().booleanValue()) {
            long supplierRefundsAmount;
            long clientRefundsAmount;
            if (invoice.getOperationTypeSelect() == 3 && (clientRefundsAmount = this.getRefundsAmount(invoice.getPartner().getId(), 4)) > 0L) {
                return I18n.get((String)"Note: there are existing not imputed client refunds.");
            }
            if (invoice.getOperationTypeSelect() == 1 && (supplierRefundsAmount = this.getRefundsAmount(invoice.getPartner().getId(), 2)) > 0L) {
                return I18n.get((String)"Note: there are existing not imputed supplier refunds.");
            }
        }
        return null;
    }

    private long getRefundsAmount(Long partnerId, int refundType) {
        return this.invoiceRepo.all().filter("self.partner.id = ? AND self.operationTypeSelect = ? AND self.statusSelect = ? AND self.amountRemaining > 0", new Object[]{partnerId, refundType, 3}).count();
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice createRefund(Invoice invoice) throws AxelorException {
        Invoice refund = new RefundInvoice(invoice).generate();
        invoice.addRefundInvoiceListItem(refund);
        this.invoiceRepo.save((Model)((Object)invoice));
        return refund;
    }

    @Override
    public void setDraftSequence(Invoice invoice) throws AxelorException {
        if (invoice.getId() != null && Strings.isNullOrEmpty((String)invoice.getInvoiceId())) {
            invoice.setInvoiceId(((SequenceService)Beans.get(SequenceService.class)).getDraftSequenceNumber((Model)((Object)invoice)));
        }
    }

    @Override
    public Invoice mergeInvoiceProcess(List<Invoice> invoiceList, Company company, Currency currency, Partner partner, Partner contactPartner, PriceList priceList, PaymentMode paymentMode, PaymentCondition paymentCondition) throws AxelorException {
        Invoice invoiceMerged = this.mergeInvoice(invoiceList, company, currency, partner, contactPartner, priceList, paymentMode, paymentCondition);
        this.deleteOldInvoices(invoiceList);
        return invoiceMerged;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Invoice mergeInvoice(List<Invoice> invoiceList, Company company, Currency currency, Partner partner, Partner contactPartner, PriceList priceList, PaymentMode paymentMode, PaymentCondition paymentCondition) throws AxelorException {
        String numSeq = "";
        String externalRef = "";
        for (Invoice invoiceLocal : invoiceList) {
            if (!numSeq.isEmpty()) {
                numSeq = numSeq + "-";
            }
            if (invoiceLocal.getInternalReference() != null) {
                numSeq = numSeq + invoiceLocal.getInternalReference();
            }
            if (!externalRef.isEmpty()) {
                externalRef = externalRef + "|";
            }
            if (invoiceLocal.getExternalReference() == null) continue;
            externalRef = externalRef + invoiceLocal.getExternalReference();
        }
        InvoiceGenerator invoiceGenerator = new InvoiceGenerator(3, company, paymentCondition, paymentMode, this.partnerService.getInvoicingAddress(partner), partner, contactPartner, currency, priceList, numSeq, externalRef, null, company.getDefaultBankDetails(), null){

            @Override
            public Invoice generate() throws AxelorException {
                return super.createInvoiceHeader();
            }
        };
        Invoice invoiceMerged = invoiceGenerator.generate();
        List<InvoiceLine> invoiceLines = this.getInvoiceLinesFromInvoiceList(invoiceList);
        invoiceGenerator.populate(invoiceMerged, invoiceLines);
        this.setInvoiceForInvoiceLines(invoiceLines, invoiceMerged);
        this.invoiceRepo.save((Model)((Object)invoiceMerged));
        return invoiceMerged;
    }

    @Override
    @Transactional
    public void deleteOldInvoices(List<Invoice> invoiceList) {
        for (Invoice invoicetemp : invoiceList) {
            this.invoiceRepo.remove((Model)((Object)invoicetemp));
        }
    }

    @Override
    public List<InvoiceLine> getInvoiceLinesFromInvoiceList(List<Invoice> invoiceList) {
        ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
        for (Invoice invoice : invoiceList) {
            int countLine = 1;
            for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
                invoiceLine.setSequence(countLine * 10);
                invoiceLines.add(invoiceLine);
                ++countLine;
            }
        }
        return invoiceLines;
    }

    @Override
    public void setInvoiceForInvoiceLines(List<InvoiceLine> invoiceLines, Invoice invoice) {
        for (InvoiceLine invoiceLine : invoiceLines) {
            invoiceLine.setInvoice(invoice);
        }
    }

    @Override
    public Invoice getInvoice(MoveLine moveLine) {
        Invoice invoice = null;
        invoice = moveLine.getMove().getRejectOk() != false ? moveLine.getInvoiceReject() : moveLine.getMove().getInvoice();
        return invoice;
    }

    @Override
    public String createAdvancePaymentInvoiceSetDomain(Invoice invoice) throws AxelorException {
        Set<Invoice> invoices = this.getDefaultAdvancePaymentInvoice(invoice);
        String domain = "self.id IN (" + StringTool.getIdListString(invoices) + ")";
        return domain;
    }

    @Override
    public Set<Invoice> getDefaultAdvancePaymentInvoice(Invoice invoice) throws AxelorException {
        Company company = invoice.getCompany();
        Currency currency = invoice.getCurrency();
        Partner partner = invoice.getPartner();
        if (company == null || currency == null || partner == null) {
            return new HashSet<Invoice>();
        }
        String filter = this.writeGeneralFilterForAdvancePayment();
        filter = filter + " AND self.partner = :_partner AND self.currency = :_currency";
        HashSet<Invoice> advancePaymentInvoices = new HashSet<Invoice>(this.invoiceRepo.all().filter(filter).bind("_status", (Object)2).bind("_operationSubType", (Object)2).bind("_partner", (Object)partner).bind("_currency", (Object)currency).fetch());
        this.filterAdvancePaymentInvoice(invoice, advancePaymentInvoices);
        return advancePaymentInvoices;
    }

    @Override
    public void filterAdvancePaymentInvoice(Invoice invoice, Set<Invoice> advancePaymentInvoices) throws AxelorException {
        Iterator<Invoice> advPaymentInvoiceIt = advancePaymentInvoices.iterator();
        while (advPaymentInvoiceIt.hasNext()) {
            Invoice candidateAdvancePayment = advPaymentInvoiceIt.next();
            if (!this.removeBecauseOfTotalAmount(invoice, candidateAdvancePayment) && !this.removeBecauseOfAmountRemaining(invoice, candidateAdvancePayment)) continue;
            advPaymentInvoiceIt.remove();
        }
    }

    protected boolean removeBecauseOfTotalAmount(Invoice invoice, Invoice candidateAdvancePayment) throws AxelorException {
        if (this.accountConfigService.getAccountConfig(invoice.getCompany()).getGenerateMoveForInvoicePayment().booleanValue()) {
            return false;
        }
        BigDecimal invoiceTotal = invoice.getInTaxTotal();
        List<InvoicePayment> invoicePayments = candidateAdvancePayment.getInvoicePaymentList();
        if (invoicePayments == null) {
            return false;
        }
        BigDecimal totalAmount = invoicePayments.stream().map(InvoicePayment::getAmount).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        return totalAmount.compareTo(invoiceTotal) > 0;
    }

    protected boolean removeBecauseOfAmountRemaining(Invoice invoice, Invoice candidateAdvancePayment) throws AxelorException {
        List<InvoicePayment> invoicePayments = candidateAdvancePayment.getInvoicePaymentList();
        if (invoicePayments == null || invoicePayments.isEmpty()) {
            return true;
        }
        if (!this.accountConfigService.getAccountConfig(invoice.getCompany()).getGenerateMoveForInvoicePayment().booleanValue()) {
            for (InvoicePayment invoicePayment : invoicePayments) {
                if (invoicePayment.getImputedBy() != null) continue;
                return false;
            }
            return true;
        }
        for (InvoicePayment invoicePayment : invoicePayments) {
            List<MoveLine> moveLineList;
            Move move = invoicePayment.getMove();
            if (move == null || (moveLineList = move.getMoveLineList()) == null || moveLineList.isEmpty()) continue;
            for (MoveLine moveLine : moveLineList) {
                BigDecimal amountRemaining = moveLine.getAmountRemaining();
                if (amountRemaining == null || amountRemaining.compareTo(BigDecimal.ZERO) <= 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<MoveLine> getMoveLinesFromAdvancePayments(Invoice invoice) throws AxelorException {
        if (this.appAccountService.getAppAccount().getManageAdvancePaymentInvoice().booleanValue()) {
            return this.getMoveLinesFromInvoiceAdvancePayments(invoice);
        }
        return this.getMoveLinesFromSOAdvancePayments(invoice);
    }

    @Override
    public List<MoveLine> getMoveLinesFromInvoiceAdvancePayments(Invoice invoice) {
        ArrayList<MoveLine> advancePaymentMoveLines = new ArrayList<MoveLine>();
        Set<Invoice> advancePayments = invoice.getAdvancePaymentInvoiceSet();
        if (advancePayments == null || advancePayments.isEmpty()) {
            return advancePaymentMoveLines;
        }
        InvoicePaymentToolService invoicePaymentToolService = (InvoicePaymentToolService)Beans.get(InvoicePaymentToolService.class);
        for (Invoice advancePayment : advancePayments) {
            List<InvoicePayment> invoicePayments = advancePayment.getInvoicePaymentList();
            List<MoveLine> creditMoveLines = invoicePaymentToolService.getCreditMoveLinesFromPayments(invoicePayments);
            advancePaymentMoveLines.addAll(creditMoveLines);
        }
        return advancePaymentMoveLines;
    }

    @Override
    public List<MoveLine> getMoveLinesFromSOAdvancePayments(Invoice invoice) {
        return new ArrayList<MoveLine>();
    }

    protected String writeGeneralFilterForAdvancePayment() {
        return "self.statusSelect = :_status AND self.operationSubTypeSelect = :_operationSubType";
    }

    @Override
    public BankDetails getBankDetails(Invoice invoice) throws AxelorException {
        BankDetails bankDetails;
        if (invoice.getSchedulePaymentOk().booleanValue() && invoice.getPaymentSchedule() != null && (bankDetails = invoice.getPaymentSchedule().getBankDetails()) != null) {
            return bankDetails;
        }
        bankDetails = invoice.getBankDetails();
        if (bankDetails != null) {
            return bankDetails;
        }
        Partner partner = invoice.getPartner();
        Preconditions.checkNotNull((Object)((Object)partner));
        bankDetails = ((BankDetailsRepository)((Object)Beans.get(BankDetailsRepository.class))).findDefaultByPartner(partner);
        if (bankDetails != null) {
            return bankDetails;
        }
        throw new AxelorException((Model)((Object)invoice), 1, I18n.get((String)"Bank details are missing for partner %s."), new Object[]{partner.getName()});
    }

    @Override
    public int getPurchaseTypeOrSaleType(Invoice invoice) {
        if (invoice.getOperationTypeSelect() == 3 || invoice.getOperationTypeSelect() == 4) {
            return 1;
        }
        if (invoice.getOperationTypeSelect() == 1 || invoice.getOperationTypeSelect() == 2) {
            return 2;
        }
        return -1;
    }

    @Override
    public Pair<Integer, Integer> massValidate(Collection<? extends Number> invoiceIds) {
        return this.massProcess(invoiceIds, (ThrowConsumer<Invoice>)((ThrowConsumer)this::validate), 1);
    }

    @Override
    public Pair<Integer, Integer> massValidateAndVentilate(Collection<? extends Number> invoiceIds) {
        return this.massProcess(invoiceIds, (ThrowConsumer<Invoice>)((ThrowConsumer)this::validateAndVentilate), 1);
    }

    @Override
    public Pair<Integer, Integer> massVentilate(Collection<? extends Number> invoiceIds) {
        return this.massProcess(invoiceIds, (ThrowConsumer<Invoice>)((ThrowConsumer)this::ventilate), 2);
    }

    private Pair<Integer, Integer> massProcess(Collection<? extends Number> invoiceIds, final ThrowConsumer<Invoice> consumer, final int statusSelect) {
        final IntCounter doneCounter = new IntCounter();
        int errorCount = ModelTool.apply(Invoice.class, invoiceIds, (ThrowConsumer)new ThrowConsumer<Invoice>(){

            public void accept(Invoice invoice) throws Exception {
                if (invoice.getStatusSelect() == statusSelect) {
                    consumer.accept((Object)invoice);
                    doneCounter.increment();
                }
            }
        });
        return Pair.of((Object)doneCounter.intValue(), (Object)errorCount);
    }

    @Override
    public Boolean checkPartnerBankDetailsList(Invoice invoice) {
        PaymentMode paymentMode = invoice.getPaymentMode();
        Partner partner = invoice.getPartner();
        if (partner == null || paymentMode == null) {
            return true;
        }
        int paymentModeInOutSelect = paymentMode.getInOutSelect();
        int paymentModeTypeSelect = paymentMode.getTypeSelect();
        if (paymentModeInOutSelect == 1 && (paymentModeTypeSelect == 3 || paymentModeTypeSelect == 4 || paymentModeTypeSelect == 2) || paymentModeInOutSelect == 2 && paymentModeTypeSelect == 9) {
            return partner.getBankDetailsList().stream().anyMatch(bankDetails -> bankDetails.getActive());
        }
        return true;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void refusalToPay(Invoice invoice, CancelReason reasonOfRefusalToPay, String reasonOfRefusalToPayStr) {
        invoice.setPfpValidateStatusSelect(3);
        invoice.setDecisionPfpTakenDate(((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(invoice.getCompany()));
        invoice.setReasonOfRefusalToPay(reasonOfRefusalToPay);
        invoice.setReasonOfRefusalToPayStr(reasonOfRefusalToPayStr != null ? reasonOfRefusalToPayStr : reasonOfRefusalToPay.getName());
        this.invoiceRepo.save((Model)((Object)invoice));
    }

    @Override
    public User getPfpValidatorUser(Invoice invoice) {
        AccountingSituation accountingSituation = ((AccountingSituationService)Beans.get(AccountingSituationService.class)).getAccountingSituation(invoice.getPartner(), invoice.getCompany());
        if (accountingSituation == null) {
            return null;
        }
        return accountingSituation.getPfpValidatorUser();
    }

    @Override
    public String getPfpValidatorUserDomain(Invoice invoice) {
        User pfpValidatorUser = this.getPfpValidatorUser(invoice);
        if (pfpValidatorUser == null) {
            return "self.id in (0)";
        }
        List<SubstitutePfpValidator> substitutePfpValidatorList = pfpValidatorUser.getSubstitutePfpValidatorList();
        ArrayList<User> validPfpValidatorUserList = new ArrayList<User>();
        StringBuilder pfpValidatorUserDomain = new StringBuilder("self.id in ");
        LocalDate todayDate = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(invoice.getCompany());
        validPfpValidatorUserList.add(pfpValidatorUser);
        for (SubstitutePfpValidator substitutePfpValidator : substitutePfpValidatorList) {
            LocalDate substituteStartDate = substitutePfpValidator.getSubstituteStartDate();
            LocalDate substituteEndDate = substitutePfpValidator.getSubstituteEndDate();
            if (substituteStartDate == null) {
                if (substituteEndDate != null && !substituteEndDate.isAfter(todayDate)) continue;
                validPfpValidatorUserList.add(substitutePfpValidator.getSubstitutePfpValidatorUser());
                continue;
            }
            if (substituteEndDate == null && substituteStartDate.isBefore(todayDate)) {
                validPfpValidatorUserList.add(substitutePfpValidator.getSubstitutePfpValidatorUser());
                continue;
            }
            if (!substituteStartDate.isBefore(todayDate) || !substituteEndDate.isAfter(todayDate)) continue;
            validPfpValidatorUserList.add(substitutePfpValidator.getSubstitutePfpValidatorUser());
        }
        pfpValidatorUserDomain.append("(").append(validPfpValidatorUserList.stream().map(pfpValidator -> pfpValidator.getId().toString()).collect(Collectors.joining(","))).append(")");
        return pfpValidatorUserDomain.toString();
    }

    protected boolean checkEnablePDFGenerationOnVentilation(Invoice invoice) throws AxelorException {
        if (this.appAccountService.getAppInvoice().getAutoGenerateInvoicePrintingFileOnSaleInvoice().booleanValue() && !InvoiceToolService.isPurchase(invoice)) {
            return true;
        }
        return this.appAccountService.getAppInvoice().getAutoGenerateInvoicePrintingFileOnPurchaseInvoice() != false && InvoiceToolService.isPurchase(invoice);
    }

    @Override
    public String checkNotLetteredAdvancePaymentMoveLines(Invoice invoice) throws AxelorException {
        long supplierNotLetteredAdvancePaymentMoveLinesAmount;
        if (invoice.getOperationTypeSelect() == 1 && (supplierNotLetteredAdvancePaymentMoveLinesAmount = this.getNotLetteredAdvancePaymentMoveLinesAmount(invoice.getPartner())) > 0L) {
            return I18n.get((String)"There is at least one advance payment or payment that can be imputed to this invoice.");
        }
        return null;
    }

    protected long getNotLetteredAdvancePaymentMoveLinesAmount(Partner partner) {
        return JPA.em().createQuery("Select moveLine.id FROM  MoveLine moveLine LEFT JOIN Move move on moveLine.move = move.id LEFT JOIN Invoice invoice on move.id = invoice.move LEFT JOIN Account account on moveLine.account = account.id LEFT JOIN AccountType accountType on account.accountType = accountType.id LEFT JOIN Partner partner on moveLine.partner = partner.id WHERE invoice.move = null AND moveLine.debit > 0 AND moveLine.amountRemaining > 0 AND accountType.technicalTypeSelect = ?1 AND move.statusSelect in (?2,?3) AND partner.id = ?4").setParameter(1, (Object)"payable").setParameter(2, (Object)2).setParameter(3, (Object)3).setParameter(4, (Object)partner.getId()).getResultList().size();
    }

    private static class IntCounter
    extends Number {
        private static final long serialVersionUID = -5434353935712805399L;
        private int count = 0;

        private IntCounter() {
        }

        public void increment() {
            ++this.count;
        }

        @Override
        public int intValue() {
            return this.count;
        }

        @Override
        public long longValue() {
            return this.count;
        }

        @Override
        public float floatValue() {
            return Float.valueOf(this.count).floatValue();
        }

        @Override
        public double doubleValue() {
            return this.count;
        }
    }
}

