/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.generator;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.InvoiceLineTax;
import com.axelor.apps.account.db.PaymentCondition;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.generator.tax.TaxInvoiceLine;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.TradingName;
import com.axelor.apps.base.db.repo.BlockingRepository;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.BlockingService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.TradingNameService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ContextEntity;
import com.google.common.base.Strings;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InvoiceGenerator {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected int operationType;
    protected Company company;
    protected PaymentCondition paymentCondition;
    protected PaymentMode paymentMode;
    protected Address mainInvoicingAddress;
    protected Partner partner;
    protected Partner contactPartner;
    protected Currency currency;
    protected LocalDate today;
    protected PriceList priceList;
    protected String internalReference;
    protected String externalReference;
    protected Boolean inAti;
    protected BankDetails companyBankDetails;
    protected TradingName tradingName;
    protected static int DEFAULT_INVOICE_COPY = 1;

    protected InvoiceGenerator(int operationType, Company company, PaymentCondition paymentCondition, PaymentMode paymentMode, Address mainInvoicingAddress, Partner partner, Partner contactPartner, Currency currency, PriceList priceList, String internalReference, String externalReference, Boolean inAti, BankDetails companyBankDetails, TradingName tradingName) throws AxelorException {
        this.operationType = operationType;
        this.company = company;
        this.paymentCondition = paymentCondition;
        this.paymentMode = paymentMode;
        this.mainInvoicingAddress = mainInvoicingAddress;
        this.partner = partner;
        this.contactPartner = contactPartner;
        this.currency = currency;
        this.priceList = priceList;
        this.internalReference = internalReference;
        this.externalReference = externalReference;
        this.inAti = inAti;
        this.companyBankDetails = companyBankDetails;
        this.tradingName = tradingName;
        this.today = ((AppAccountService)Beans.get(AppAccountService.class)).getTodayDate(company);
    }

    protected InvoiceGenerator(int operationType, Company company, Partner partner, Partner contactPartner, PriceList priceList, String internalReference, String externalReference, Boolean inAti, TradingName tradingName) throws AxelorException {
        this.operationType = operationType;
        this.company = company;
        this.partner = partner;
        this.contactPartner = contactPartner;
        this.priceList = priceList;
        this.internalReference = internalReference;
        this.externalReference = externalReference;
        this.inAti = inAti;
        this.tradingName = tradingName;
        this.today = ((AppAccountService)Beans.get(AppAccountService.class)).getTodayDate(company);
    }

    protected InvoiceGenerator() {
        this.today = ((AppAccountService)Beans.get(AppAccountService.class)).getTodayDate(this.company);
    }

    protected int inverseOperationType(int operationType) throws AxelorException {
        switch (operationType) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 3;
            }
        }
        throw new AxelorException(1, I18n.get((String)"%s : Invoice's type is not filled %s"), new Object[]{I18n.get((String)"Warning !")});
    }

    public abstract Invoice generate() throws AxelorException;

    protected Invoice createInvoiceHeader() throws AxelorException {
        Invoice invoice = new Invoice();
        invoice.setCompany(this.company);
        invoice.setOperationTypeSelect(this.operationType);
        if (this.partner == null) {
            throw new AxelorException(1, I18n.get((String)"%s : There's no partner selected"), new Object[]{I18n.get((String)"Warning !")});
        }
        if (((BlockingService)Beans.get(BlockingService.class)).getBlocking(this.partner, this.company, BlockingRepository.INVOICING_BLOCKING.intValue()) != null) {
            throw new AxelorException(5, I18n.get((String)"The partner is blocked for invoicing."));
        }
        invoice.setPartner(this.partner);
        AccountingSituation accountingSituation = ((AccountingSituationService)Beans.get(AccountingSituationService.class)).getAccountingSituation(this.partner, this.company);
        if (accountingSituation != null) {
            invoice.setInvoiceAutomaticMail(accountingSituation.getInvoiceAutomaticMail());
            invoice.setInvoiceMessageTemplate(accountingSituation.getInvoiceMessageTemplate());
            invoice.setPfpValidatorUser(accountingSituation.getPfpValidatorUser());
        }
        if (this.paymentCondition == null) {
            this.paymentCondition = InvoiceToolService.getPaymentCondition(invoice);
        }
        invoice.setPaymentCondition(this.paymentCondition);
        if (this.paymentMode == null) {
            this.paymentMode = InvoiceToolService.getPaymentMode(invoice);
        }
        invoice.setPaymentMode(this.paymentMode);
        if (this.mainInvoicingAddress == null) {
            this.mainInvoicingAddress = ((PartnerService)Beans.get(PartnerService.class)).getInvoicingAddress(this.partner);
        }
        invoice.setAddress(this.mainInvoicingAddress);
        invoice.setAddressStr(((AddressService)Beans.get(AddressService.class)).computeAddressStr(invoice.getAddress()));
        invoice.setContactPartner(this.contactPartner);
        if (this.currency == null) {
            this.currency = this.partner.getCurrency();
        }
        if (this.currency == null) {
            throw new AxelorException(1, I18n.get((String)"%s : Currency missing"), new Object[]{I18n.get((String)"Warning !")});
        }
        invoice.setCurrency(this.currency);
        invoice.setStatusSelect(1);
        invoice.setPriceList(this.priceList);
        invoice.setInternalReference(this.internalReference);
        invoice.setExternalReference(this.externalReference);
        invoice.setPrintingSettings(((TradingNameService)Beans.get(TradingNameService.class)).getDefaultPrintingSettings(null, this.company));
        invoice.setTradingName(this.tradingName);
        AccountConfigService accountConfigService = (AccountConfigService)Beans.get(AccountConfigService.class);
        AccountConfig accountConfig = accountConfigService.getAccountConfig(this.company);
        int atiChoice = accountConfig.getInvoiceInAtiSelect();
        if (this.inAti == null) {
            invoice.setInAti(accountConfigService.getInvoiceInAti(accountConfig));
        } else if (atiChoice == 4 || atiChoice == 3) {
            invoice.setInAti(this.inAti);
        } else if (atiChoice == 2) {
            invoice.setInAti(true);
        } else {
            invoice.setInAti(false);
        }
        if (this.partner.getFactorizedCustomer().booleanValue() && accountConfig.getFactorPartner() != null) {
            List<BankDetails> bankDetailsList = accountConfig.getFactorPartner().getBankDetailsList();
            this.companyBankDetails = bankDetailsList.stream().filter(bankDetails -> bankDetails.getIsDefault()).findFirst().orElse(null);
        } else if (accountingSituation != null && this.paymentMode != null) {
            if (this.paymentMode.equals((Object)this.partner.getOutPaymentMode())) {
                this.companyBankDetails = accountingSituation.getCompanyOutBankDetails();
            } else if (this.paymentMode.equals((Object)this.partner.getInPaymentMode())) {
                this.companyBankDetails = accountingSituation.getCompanyInBankDetails();
            }
        }
        if (this.companyBankDetails == null) {
            this.companyBankDetails = this.company.getDefaultBankDetails();
            List<BankDetails> allowedBDs = ((PaymentModeService)Beans.get(PaymentModeService.class)).getCompatibleBankDetailsList(this.paymentMode, this.company);
            if (!allowedBDs.contains((Object)this.companyBankDetails)) {
                this.companyBankDetails = null;
            }
        }
        invoice.setCompanyBankDetails(this.companyBankDetails);
        if (this.partner != null && !Strings.isNullOrEmpty((String)this.partner.getInvoiceComments())) {
            invoice.setNote(this.partner.getInvoiceComments());
        }
        invoice.setInvoicesCopySelect(this.getInvoiceCopy());
        this.initCollections(invoice);
        return invoice;
    }

    public int getInvoiceCopy() {
        if (this.partner.getIsCustomer().booleanValue()) {
            return this.partner.getInvoicesCopySelect() == 0 ? DEFAULT_INVOICE_COPY : this.partner.getInvoicesCopySelect();
        }
        return DEFAULT_INVOICE_COPY;
    }

    public void populate(Invoice invoice, List<InvoiceLine> invoiceLines) throws AxelorException {
        this.logger.debug("Peupler une facture => lignes de factures: {} ", new Object[]{invoiceLines.size()});
        this.initCollections(invoice);
        List<InvoiceLineTax> invoiceTaxLines = new TaxInvoiceLine(invoice, invoiceLines).creates();
        if (invoice instanceof ContextEntity) {
            invoice.getInvoiceLineList().addAll(invoiceLines);
            invoice.getInvoiceLineTaxList().addAll(invoiceTaxLines);
        } else {
            invoiceLines.stream().forEach(invoice::addInvoiceLineListItem);
            invoiceTaxLines.stream().forEach(invoice::addInvoiceLineTaxListItem);
        }
        this.computeInvoice(invoice);
    }

    protected void initCollections(Invoice invoice) {
        this.initInvoiceLineTaxList(invoice);
        this.initInvoiceLineList(invoice);
    }

    protected void initInvoiceLineList(Invoice invoice) {
        if (invoice.getInvoiceLineList() == null) {
            invoice.setInvoiceLineList(new ArrayList<InvoiceLine>());
        } else {
            invoice.getInvoiceLineList().clear();
        }
    }

    protected void initInvoiceLineTaxList(Invoice invoice) {
        if (invoice.getInvoiceLineTaxList() == null) {
            invoice.setInvoiceLineTaxList(new ArrayList<InvoiceLineTax>());
        } else {
            invoice.getInvoiceLineTaxList().clear();
        }
    }

    public void computeInvoice(Invoice invoice) throws AxelorException {
        invoice.setExTaxTotal(BigDecimal.ZERO);
        invoice.setTaxTotal(BigDecimal.ZERO);
        invoice.setInTaxTotal(BigDecimal.ZERO);
        invoice.setCompanyExTaxTotal(BigDecimal.ZERO);
        invoice.setCompanyTaxTotal(BigDecimal.ZERO);
        invoice.setCompanyInTaxTotal(BigDecimal.ZERO);
        for (InvoiceLine invoiceLine : invoice.getInvoiceLineList()) {
            invoice.setExTaxTotal(invoice.getExTaxTotal().add(invoiceLine.getExTaxTotal()));
            invoice.setCompanyExTaxTotal(invoice.getCompanyExTaxTotal().add(invoiceLine.getCompanyExTaxTotal()));
        }
        for (InvoiceLineTax invoiceLineTax : invoice.getInvoiceLineTaxList()) {
            invoice.setTaxTotal(invoice.getTaxTotal().add(invoiceLineTax.getTaxTotal()));
            invoice.setCompanyTaxTotal(invoice.getCompanyTaxTotal().add(invoiceLineTax.getCompanyTaxTotal()));
        }
        invoice.setInTaxTotal(invoice.getExTaxTotal().add(invoice.getTaxTotal()));
        invoice.setCompanyInTaxTotal(invoice.getCompanyExTaxTotal().add(invoice.getCompanyTaxTotal()));
        invoice.setAmountRemaining(invoice.getInTaxTotal());
        invoice.setHasPendingPayments(false);
        this.logger.debug("Invoice amounts : W.T. = {}, Tax = {}, A.T.I. = {}", new Object[]{invoice.getExTaxTotal(), invoice.getTaxTotal(), invoice.getInTaxTotal()});
    }
}

