/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.generator;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.service.AccountManagementAccountService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.invoice.InvoiceLineService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.generator.line.InvoiceLineManagement;
import com.axelor.apps.base.db.Alarm;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.UnitConversion;
import com.axelor.apps.base.db.repo.UnitConversionRepository;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.tax.AccountManagementService;
import com.axelor.apps.base.service.tax.FiscalPositionService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InvoiceLineGenerator
extends InvoiceLineManagement {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected CurrencyService currencyService;
    protected UnitConversionRepository unitConversionRepo;
    protected AppBaseService appBaseService;
    protected AppAccountService appAccountService;
    protected InvoiceLineService invoiceLineService;
    protected AccountManagementAccountService accountManagementService;
    protected ProductCompanyService productCompanyService;
    protected Invoice invoice;
    protected Product product;
    protected String productName;
    protected BigDecimal price;
    protected BigDecimal inTaxPrice;
    protected BigDecimal priceDiscounted;
    protected String description;
    protected BigDecimal qty;
    protected Unit unit;
    protected TaxLine taxLine;
    protected int sequence;
    protected LocalDate today;
    protected boolean isTaxInvoice;
    protected BigDecimal discountAmount;
    protected int discountTypeSelect;
    protected BigDecimal exTaxTotal;
    protected BigDecimal inTaxTotal;
    protected Integer typeSelect = 0;
    public static final int DEFAULT_SEQUENCE = 0;

    protected InvoiceLineGenerator() {
    }

    protected InvoiceLineGenerator(Invoice invoice) {
        this.invoice = invoice;
        this.unitConversionRepo = (UnitConversionRepository)Beans.get(UnitConversionRepository.class);
        this.appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
        this.appAccountService = (AppAccountService)Beans.get(AppAccountService.class);
        this.invoiceLineService = (InvoiceLineService)Beans.get(InvoiceLineService.class);
        this.accountManagementService = (AccountManagementAccountService)Beans.get(AccountManagementAccountService.class);
        this.productCompanyService = (ProductCompanyService)Beans.get(ProductCompanyService.class);
    }

    protected InvoiceLineGenerator(Invoice invoice, Product product, String productName, String description, BigDecimal qty, Unit unit, int sequence, boolean isTaxInvoice) {
        this(invoice);
        this.product = product;
        this.productName = productName;
        this.description = description;
        this.qty = qty.setScale(this.appBaseService.getNbDecimalDigitForQty(), RoundingMode.HALF_EVEN);
        this.unit = unit;
        this.sequence = sequence;
        this.isTaxInvoice = isTaxInvoice;
        this.today = ((AppAccountService)Beans.get(AppAccountService.class)).getTodayDate(invoice.getCompany());
        this.currencyService = new CurrencyService(this.today);
    }

    protected InvoiceLineGenerator(Invoice invoice, Product product, String productName, BigDecimal price, BigDecimal inTaxPrice, BigDecimal priceDiscounted, String description, BigDecimal qty, Unit unit, TaxLine taxLine, int sequence, BigDecimal discountAmount, int discountTypeSelect, BigDecimal exTaxTotal, BigDecimal inTaxTotal, boolean isTaxInvoice) {
        this(invoice, product, productName, description, qty, unit, sequence, isTaxInvoice);
        this.price = price;
        this.inTaxPrice = inTaxPrice;
        this.priceDiscounted = priceDiscounted;
        this.taxLine = taxLine;
        this.discountTypeSelect = discountTypeSelect;
        this.discountAmount = discountAmount;
        this.exTaxTotal = exTaxTotal;
        this.inTaxTotal = inTaxTotal;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public void setInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    public abstract List<InvoiceLine> creates() throws AxelorException;

    protected InvoiceLine createInvoiceLine() throws AxelorException {
        InvoiceLine invoiceLine = new InvoiceLine();
        boolean isPurchase = InvoiceToolService.isPurchase(this.invoice);
        Partner partner = this.invoice.getPartner();
        Company company = this.invoice.getCompany();
        invoiceLine.setInvoice(this.invoice);
        invoiceLine.setProduct(this.product);
        invoiceLine.setProductName(this.productName);
        if (this.product != null) {
            invoiceLine.setProductCode((String)this.productCompanyService.get(this.product, "code", company));
            Account account = this.accountManagementService.getProductAccount(this.product, company, partner.getFiscalPosition(), isPurchase, invoiceLine.getFixedAssets());
            invoiceLine.setAccount(account);
        }
        invoiceLine.setDescription(this.description);
        invoiceLine.setPrice(this.price);
        invoiceLine.setInTaxPrice(this.inTaxPrice);
        invoiceLine.setPriceDiscounted(this.priceDiscounted);
        invoiceLine.setQty(this.qty);
        invoiceLine.setUnit(this.unit);
        invoiceLine.setTypeSelect(this.typeSelect);
        if (this.taxLine == null) {
            this.determineTaxLine();
        }
        if (this.product != null) {
            Tax tax = ((AccountManagementService)Beans.get(AccountManagementService.class)).getProductTax(this.product, company, null, isPurchase);
            TaxEquiv taxEquiv = ((FiscalPositionService)Beans.get(FiscalPositionService.class)).getTaxEquiv(partner.getFiscalPosition(), tax);
            invoiceLine.setTaxEquiv(taxEquiv);
        }
        invoiceLine.setTaxLine(this.taxLine);
        if (this.taxLine != null) {
            invoiceLine.setTaxRate(this.taxLine.getValue());
            invoiceLine.setTaxCode(this.taxLine.getTax().getCode());
        }
        if (this.exTaxTotal == null || this.inTaxTotal == null) {
            this.computeTotal();
        }
        invoiceLine.setExTaxTotal(this.exTaxTotal);
        invoiceLine.setInTaxTotal(this.inTaxTotal);
        this.computeCompanyTotal(invoiceLine);
        invoiceLine.setSequence(this.sequence);
        invoiceLine.setDiscountTypeSelect(this.discountTypeSelect);
        invoiceLine.setDiscountAmount(this.discountAmount);
        return invoiceLine;
    }

    public void determineTaxLine() throws AxelorException {
        if (this.product != null) {
            Company company = this.invoice.getCompany();
            Partner partner = this.invoice.getPartner();
            this.taxLine = this.accountManagementService.getTaxLine(this.today, this.product, company, partner.getFiscalPosition(), InvoiceToolService.isPurchase(this.invoice));
        }
    }

    public void computeTotal() {
        if (this.typeSelect == 1) {
            return;
        }
        BigDecimal taxRate = BigDecimal.ZERO;
        if (this.taxLine != null) {
            taxRate = this.taxLine.getValue();
        }
        if (!this.invoice.getInAti().booleanValue()) {
            this.exTaxTotal = InvoiceLineGenerator.computeAmount(this.qty, this.priceDiscounted, 2);
            this.inTaxTotal = this.exTaxTotal.add(this.exTaxTotal.multiply(taxRate)).setScale(2, RoundingMode.HALF_EVEN);
        } else {
            this.inTaxTotal = InvoiceLineGenerator.computeAmount(this.qty, this.priceDiscounted, 2);
            this.exTaxTotal = this.inTaxTotal.divide(taxRate.add(BigDecimal.ONE), 2, 6);
        }
    }

    public void computeCompanyTotal(InvoiceLine invoiceLine) throws AxelorException {
        if (this.typeSelect == 1) {
            return;
        }
        Company company = this.invoice.getCompany();
        Currency companyCurrency = company.getCurrency();
        if (companyCurrency == null) {
            throw new AxelorException(4, I18n.get((String)"You must select a currency for company %s"), new Object[]{company.getName()});
        }
        invoiceLine.setCompanyExTaxTotal(this.currencyService.getAmountCurrencyConvertedAtDate(this.invoice.getCurrency(), companyCurrency, this.exTaxTotal, this.today).setScale(2, RoundingMode.HALF_UP));
        invoiceLine.setCompanyInTaxTotal(this.currencyService.getAmountCurrencyConvertedAtDate(this.invoice.getCurrency(), companyCurrency, this.inTaxTotal, this.today).setScale(2, RoundingMode.HALF_UP));
    }

    protected InvoiceLine refundInvoiceLine(InvoiceLine invoiceLine, boolean daysQty) {
        LOG.debug("Remboursement d'une ligne de facture (quantit\u00e9 = nb jour ? {}).", (Object)daysQty);
        InvoiceLine refundInvoiceLine = (InvoiceLine)((Object)JPA.copy((Model)((Object)invoiceLine), (boolean)true));
        refundInvoiceLine.setInvoice(this.invoice);
        BigDecimal quantity = invoiceLine.getQty();
        refundInvoiceLine.setQty(quantity.negate());
        LOG.debug("Quantit\u00e9 rembours\u00e9e : {}", (Object)refundInvoiceLine.getQty());
        refundInvoiceLine.setExTaxTotal(InvoiceLineGenerator.computeAmount(refundInvoiceLine.getQty(), refundInvoiceLine.getPrice()));
        LOG.debug("Remboursement de la ligne de facture {} => montant HT: {}", new Object[]{invoiceLine.getId(), refundInvoiceLine.getExTaxTotal()});
        return refundInvoiceLine;
    }

    protected InvoiceLine substractInvoiceLine(InvoiceLine invoiceLine1, InvoiceLine invoiceLine2) {
        InvoiceLine substract = (InvoiceLine)((Object)JPA.copy((Model)((Object)invoiceLine1), (boolean)false));
        substract.setQty(invoiceLine1.getQty().add(invoiceLine2.getQty()));
        substract.setExTaxTotal(InvoiceLineGenerator.computeAmount(substract.getQty(), substract.getPrice()));
        LOG.debug("Soustraction de deux lignes de factures: {}", (Object)substract);
        return substract;
    }

    protected BigDecimal convertPrice(BigDecimal price, Unit startUnit, Unit endUnit) {
        BigDecimal convertPrice = this.convert(startUnit, endUnit, price);
        LOG.debug("Conversion du prix {} {} : {} {}", new Object[]{price, startUnit, convertPrice, endUnit});
        return convertPrice;
    }

    protected Unit unit(Unit unit, Unit displayUnit) {
        Unit resUnit = unit;
        if (displayUnit != null) {
            resUnit = displayUnit;
        }
        LOG.debug("Obtention de l'unit\u00e9 : Unit\u00e9 {}, Unit\u00e9 affich\u00e9e {} : {}", new Object[]{unit, displayUnit, resUnit});
        return resUnit;
    }

    protected BigDecimal convert(Unit startUnit, Unit endUnit, BigDecimal value) {
        if (value == null || startUnit == null || endUnit == null || startUnit.equals((Object)endUnit)) {
            return value;
        }
        return value.multiply(this.convertCoef(startUnit, endUnit)).setScale(6, RoundingMode.HALF_EVEN);
    }

    protected BigDecimal convertCoef(Unit startUnit, Unit endUnit) {
        UnitConversion unitConversion = (UnitConversion)this.unitConversionRepo.all().filter("self.startUnit = ?1 AND self.endUnit = ?2", new Object[]{startUnit, endUnit}).fetchOne();
        if (unitConversion != null) {
            return unitConversion.getCoef();
        }
        return BigDecimal.ONE;
    }

    protected void addAlarm(Alarm alarm, Partner partner) {
        if (alarm != null) {
            alarm.setInvoice(this.invoice);
            alarm.setPartner(partner);
        }
    }
}

