/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.generator.batch;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceBatch;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.generator.batch.BatchStrategy;
import com.axelor.inject.Beans;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchWkf
extends BatchStrategy {
    static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected BatchWkf(InvoiceService invoiceService) {
        super(invoiceService);
    }

    protected static Collection<? extends Invoice> invoices(InvoiceBatch invoiceBatch, boolean isTo) {
        if (invoiceBatch.getOnSelectOk().booleanValue()) {
            return invoiceBatch.getInvoiceSet();
        }
        return BatchWkf.invoiceQuery(invoiceBatch, isTo);
    }

    public static List<? extends Invoice> invoiceQuery(InvoiceBatch invoiceBatch, boolean isTo) {
        if (invoiceBatch != null) {
            ArrayList<Object> params = new ArrayList<Object>();
            String query = "self.company = ?1";
            params.add((Object)invoiceBatch.getCompany());
            query = query + " AND self.statusSelect = ?2";
            if (isTo) {
                params.add(invoiceBatch.getToStatusSelect());
            } else {
                params.add(invoiceBatch.getFromStatusSelect());
            }
            LOG.debug("Query: {}", (Object)query);
            return ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).all().filter(query, params.toArray()).fetch();
        }
        return new ArrayList();
    }
}

