/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.generator.invoice;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.generator.InvoiceGenerator;
import com.axelor.apps.account.service.invoice.generator.invoice.InvoiceStrategy;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefundInvoice
extends InvoiceGenerator
implements InvoiceStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Invoice invoice;

    public RefundInvoice(Invoice invoice) {
        this.invoice = invoice;
    }

    @Override
    public Invoice generate() throws AxelorException {
        LOG.debug("Creating a refund for invoice {}", (Object)this.invoice.getInvoiceId());
        Invoice refund = (Invoice)((Object)JPA.copy((Model)((Object)this.invoice), (boolean)true));
        InvoiceToolService.resetInvoiceStatusOnCopy(refund);
        refund.setOperationTypeSelect(this.inverseOperationType(refund.getOperationTypeSelect()));
        ArrayList<InvoiceLine> refundLines = new ArrayList<InvoiceLine>();
        if (refund.getInvoiceLineList() != null) {
            refundLines.addAll(refund.getInvoiceLineList());
        }
        this.populate(refund, refundLines);
        refund.setPaymentMode(InvoiceToolService.getPaymentMode(refund));
        if (refund.getPaymentMode() == null) {
            throw new AxelorException(1, I18n.get((String)"%s : Payment mode must be filled either in the partner or in the company configuration."), new Object[]{I18n.get((String)"Warning !")});
        }
        return refund;
    }

    @Override
    public void populate(Invoice invoice, List<InvoiceLine> invoiceLines) throws AxelorException {
        super.populate(invoice, invoiceLines);
    }

    @Deprecated
    protected void refundInvoiceLines(List<InvoiceLine> invoiceLines) {
        for (InvoiceLine invoiceLine : invoiceLines) {
            invoiceLine.setQty(invoiceLine.getQty().negate());
            invoiceLine.setExTaxTotal(invoiceLine.getExTaxTotal().negate());
        }
    }
}

