/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.generator.line;

import com.axelor.exception.AxelorException;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InvoiceLineManagement {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public abstract List<?> creates() throws AxelorException;

    public static BigDecimal computeAmount(BigDecimal quantity, BigDecimal price) {
        BigDecimal amount = quantity.multiply(price).setScale(2, RoundingMode.HALF_EVEN);
        LOG.debug("Calcul du montant HT avec une quantit\u00e9 de {} pour {} : {}", new Object[]{quantity, price, amount});
        return amount;
    }

    public static BigDecimal computeAmount(BigDecimal quantity, BigDecimal price, int scale) {
        BigDecimal amount = quantity.multiply(price).setScale(scale, RoundingMode.HALF_EVEN);
        LOG.debug("Calcul du montant HT avec une quantit\u00e9 de {} pour {} : {}", new Object[]{quantity, price, amount});
        return amount;
    }
}

