/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.generator.tax;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.InvoiceLineTax;
import com.axelor.apps.account.db.TaxEquiv;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.service.invoice.generator.TaxGenerator;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaxInvoiceLine
extends TaxGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public TaxInvoiceLine(Invoice invoice, List<InvoiceLine> invoiceLines) {
        super(invoice, invoiceLines);
    }

    public List<InvoiceLineTax> creates() {
        HashMap<TaxLine, InvoiceLineTax> map = new HashMap<TaxLine, InvoiceLineTax>();
        if (this.invoiceLines != null && !this.invoiceLines.isEmpty()) {
            LOG.debug("Cr\u00e9ation des lignes de tva pour les lignes de factures.");
            for (InvoiceLine invoiceLine : this.invoiceLines) {
                this.createInvoiceLineTaxes(invoiceLine, map);
            }
        }
        if (this.invoice.getPartner().getFiscalPosition() == null || !this.invoice.getPartner().getFiscalPosition().getCustomerSpecificNote().booleanValue()) {
            if (this.invoiceLines != null) {
                this.invoice.setSpecificNotes(this.invoiceLines.stream().map(InvoiceLine::getTaxEquiv).filter(Objects::nonNull).map(TaxEquiv::getSpecificNote).filter(Objects::nonNull).collect(Collectors.joining("\n")));
            }
        } else {
            this.invoice.setSpecificNotes(this.invoice.getPartner().getSpecificTaxNote());
        }
        return this.finalizeInvoiceLineTaxes(map);
    }

    protected void createInvoiceLineTaxes(InvoiceLine invoiceLine, Map<TaxLine, InvoiceLineTax> map) {
        TaxLine taxLineRC;
        TaxLine taxLine = invoiceLine.getTaxLine();
        TaxEquiv taxEquiv = invoiceLine.getTaxEquiv();
        TaxLine taxLine2 = taxLineRC = taxEquiv != null && taxEquiv.getReverseCharge() != false && taxEquiv.getReverseChargeTax() != null ? taxEquiv.getReverseChargeTax().getActiveTaxLine() : null;
        if (taxLine != null) {
            this.createOrUpdateInvoiceLineTax(invoiceLine, taxLine, map);
        }
        if (taxLineRC != null) {
            this.createOrUpdateInvoiceLineTaxRc(invoiceLine, taxLineRC, taxEquiv, map);
        }
    }

    protected void createOrUpdateInvoiceLineTax(InvoiceLine invoiceLine, TaxLine taxLine, Map<TaxLine, InvoiceLineTax> map) {
        LOG.debug("TVA {}", (Object)taxLine);
        InvoiceLineTax invoiceLineTax = map.get(taxLine);
        if (invoiceLineTax != null) {
            this.updateInvoiceLineTax(invoiceLine, invoiceLineTax);
            invoiceLineTax.setReverseCharged(false);
        } else {
            invoiceLineTax = this.createInvoiceLineTax(invoiceLine, taxLine);
            invoiceLineTax.setReverseCharged(false);
            map.put(taxLine, invoiceLineTax);
        }
    }

    protected void createOrUpdateInvoiceLineTaxRc(InvoiceLine invoiceLine, TaxLine taxLineRC, TaxEquiv taxEquiv, Map<TaxLine, InvoiceLineTax> map) {
        if (map.containsKey(taxLineRC)) {
            InvoiceLineTax invoiceLineTaxRC = map.get(taxEquiv.getReverseChargeTax().getActiveTaxLine());
            this.updateInvoiceLineTax(invoiceLine, invoiceLineTaxRC);
            invoiceLineTaxRC.setReverseCharged(true);
        } else {
            InvoiceLineTax invoiceLineTaxRC = this.createInvoiceLineTax(invoiceLine, taxLineRC);
            invoiceLineTaxRC.setReverseCharged(true);
            map.put(taxLineRC, invoiceLineTaxRC);
        }
    }

    protected void updateInvoiceLineTax(InvoiceLine invoiceLine, InvoiceLineTax invoiceLineTax) {
        invoiceLineTax.setExTaxBase(invoiceLineTax.getExTaxBase().add(invoiceLine.getExTaxTotal()));
        invoiceLineTax.setCompanyExTaxBase(invoiceLineTax.getCompanyExTaxBase().add(invoiceLine.getCompanyExTaxTotal()).setScale(2, RoundingMode.HALF_UP));
        if (!invoiceLine.getFixedAssets().booleanValue()) {
            invoiceLineTax.setSubTotalExcludingFixedAssets(invoiceLineTax.getSubTotalExcludingFixedAssets().add(invoiceLine.getExTaxTotal()).setScale(2, RoundingMode.HALF_UP));
            invoiceLineTax.setCompanySubTotalExcludingFixedAssets(invoiceLineTax.getCompanySubTotalExcludingFixedAssets().add(invoiceLine.getCompanyExTaxTotal()).setScale(2, RoundingMode.HALF_UP));
        }
    }

    protected InvoiceLineTax createInvoiceLineTax(InvoiceLine invoiceLine, TaxLine taxLine) {
        InvoiceLineTax invoiceLineTax = new InvoiceLineTax();
        invoiceLineTax.setInvoice(this.invoice);
        invoiceLineTax.setExTaxBase(invoiceLine.getExTaxTotal());
        invoiceLineTax.setCompanyExTaxBase(invoiceLine.getCompanyExTaxTotal().setScale(2, RoundingMode.HALF_UP));
        if (!invoiceLine.getFixedAssets().booleanValue()) {
            invoiceLineTax.setSubTotalExcludingFixedAssets(invoiceLine.getCompanyExTaxTotal().setScale(2, RoundingMode.HALF_UP));
            invoiceLineTax.setCompanySubTotalExcludingFixedAssets(invoiceLineTax.getCompanySubTotalExcludingFixedAssets().add(invoiceLine.getCompanyExTaxTotal()).setScale(2, RoundingMode.HALF_UP));
        }
        invoiceLineTax.setTaxLine(taxLine);
        return invoiceLineTax;
    }

    protected List<InvoiceLineTax> finalizeInvoiceLineTaxes(Map<TaxLine, InvoiceLineTax> map) {
        ArrayList<InvoiceLineTax> invoiceLineTaxList = new ArrayList<InvoiceLineTax>();
        for (InvoiceLineTax invoiceLineTax : map.values()) {
            BigDecimal taxValue = invoiceLineTax.getTaxLine().getValue();
            BigDecimal exTaxBase = invoiceLineTax.getReverseCharged() != false ? invoiceLineTax.getExTaxBase().negate() : invoiceLineTax.getExTaxBase();
            BigDecimal taxTotal = TaxInvoiceLine.computeAmount(exTaxBase, taxValue);
            invoiceLineTax.setTaxTotal(taxTotal);
            invoiceLineTax.setInTaxTotal(invoiceLineTax.getExTaxBase().add(taxTotal));
            BigDecimal companyExTaxBase = invoiceLineTax.getReverseCharged() != false ? invoiceLineTax.getCompanyExTaxBase().negate() : invoiceLineTax.getCompanyExTaxBase();
            BigDecimal companyTaxTotal = TaxInvoiceLine.computeAmount(companyExTaxBase, taxValue);
            invoiceLineTax.setCompanyTaxTotal(companyTaxTotal);
            invoiceLineTax.setCompanyInTaxTotal(invoiceLineTax.getCompanyExTaxBase().add(companyTaxTotal));
            BigDecimal subTotalExcludingFixedAssets = invoiceLineTax.getReverseCharged() != false ? invoiceLineTax.getSubTotalExcludingFixedAssets().negate() : invoiceLineTax.getSubTotalExcludingFixedAssets();
            invoiceLineTax.setSubTotalExcludingFixedAssets(TaxInvoiceLine.computeAmount(subTotalExcludingFixedAssets, taxValue));
            invoiceLineTax.setSubTotalOfFixedAssets(taxTotal.subtract(invoiceLineTax.getSubTotalExcludingFixedAssets()).setScale(2, RoundingMode.HALF_UP));
            BigDecimal companySubTotalExcludingFixedAssets = invoiceLineTax.getReverseCharged() != false ? invoiceLineTax.getCompanySubTotalExcludingFixedAssets().negate() : invoiceLineTax.getCompanySubTotalExcludingFixedAssets();
            invoiceLineTax.setCompanySubTotalExcludingFixedAssets(TaxInvoiceLine.computeAmount(companySubTotalExcludingFixedAssets, taxValue));
            invoiceLineTax.setCompanySubTotalOfFixedAssets(companyTaxTotal.subtract(invoiceLineTax.getCompanySubTotalExcludingFixedAssets()).setScale(2, RoundingMode.HALF_UP));
            invoiceLineTaxList.add(invoiceLineTax);
            LOG.debug("Ligne de TVA : Total TVA => {}, Total HT => {}", (Object)invoiceLineTax.getTaxTotal(), (Object)invoiceLineTax.getInTaxTotal());
        }
        return invoiceLineTaxList;
    }
}

