/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.workflow.ventilate;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.service.FiscalPositionAccountService;
import com.axelor.apps.account.service.FixedAssetService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.invoice.workflow.WorkflowInvoice;
import com.axelor.apps.account.service.invoice.workflow.ventilate.WorkflowVentilationService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class VentilateState
extends WorkflowInvoice {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected SequenceService sequenceService;
    protected MoveService moveService;
    protected AccountConfigService accountConfigService;
    protected AppAccountService appAccountService;
    protected InvoiceRepository invoiceRepo;
    protected WorkflowVentilationService workflowService;
    protected UserService userService;
    protected FixedAssetService fixedAssetService;

    @Inject
    public VentilateState(SequenceService sequenceService, MoveService moveService, AccountConfigService accountConfigService, AppAccountService appAccountService, InvoiceRepository invoiceRepo, WorkflowVentilationService workflowService, UserService userService, FixedAssetService fixedAssetService) {
        this.sequenceService = sequenceService;
        this.moveService = moveService;
        this.accountConfigService = accountConfigService;
        this.appAccountService = appAccountService;
        this.invoiceRepo = invoiceRepo;
        this.workflowService = workflowService;
        this.userService = userService;
        this.fixedAssetService = fixedAssetService;
    }

    @Override
    public void init(Invoice invoice) {
        this.invoice = invoice;
    }

    @Override
    public void process() throws AxelorException {
        Preconditions.checkNotNull((Object)((Object)this.invoice.getPartner()));
        this.setDate();
        this.setJournal();
        this.setPartnerAccount();
        this.setInvoiceId();
        this.updatePaymentSchedule();
        this.setMove();
        this.generateFixedAsset();
        this.setStatus();
        this.setVentilatedLog();
        this.workflowService.afterVentilation(this.invoice);
    }

    protected void setVentilatedLog() {
        this.invoice.setVentilatedDate(this.appAccountService.getTodayDate(this.invoice.getCompany()));
        this.invoice.setVentilatedByUser(this.userService.getUser());
    }

    protected void updatePaymentSchedule() {
        if (this.invoice.getPaymentSchedule() != null) {
            this.invoice.getPaymentSchedule().addInvoiceSetItem(this.invoice);
        }
    }

    protected void setPartnerAccount() throws AxelorException {
        if (this.invoice.getPartnerAccount() == null) {
            Account account = ((InvoiceService)Beans.get(InvoiceService.class)).getPartnerAccount(this.invoice);
            if (account == null) {
                throw new AxelorException(4, I18n.get((String)"The partner account can not be determined. Please set up the partner account on the invoice or configure the partner's accounting situation."));
            }
            if (this.invoice.getPartner() != null) {
                account = ((FiscalPositionAccountService)Beans.get(FiscalPositionAccountService.class)).getAccount(this.invoice.getPartner().getFiscalPosition(), account);
            }
            this.invoice.setPartnerAccount(account);
        }
    }

    protected void setJournal() throws AxelorException {
        if (this.invoice.getJournal() == null) {
            this.invoice.setJournal(((InvoiceService)Beans.get(InvoiceService.class)).getJournal(this.invoice));
        }
    }

    protected void setDate() throws AxelorException {
        LocalDate todayDate = this.appAccountService.getTodayDate(this.invoice.getCompany());
        if (this.invoice.getInvoiceDate() == null) {
            this.invoice.setInvoiceDate(todayDate);
        } else if (this.invoice.getInvoiceDate().isAfter(todayDate)) {
            throw new AxelorException((Model)((Object)this.invoice), 4, I18n.get((String)"%s - Invoice date can't be in the future."), new Object[]{this.invoice.getInvoiceId()});
        }
        boolean isPurchase = InvoiceToolService.isPurchase(this.invoice);
        if (isPurchase && this.invoice.getOriginDate() == null) {
            throw new AxelorException(4, I18n.get((String)"Origin date is missing on the invoice"));
        }
        if (isPurchase && this.invoice.getOriginDate().isAfter(todayDate)) {
            throw new AxelorException(4, I18n.get((String)"Invoice date of origin can't be in the future."));
        }
        if (this.invoice.getPaymentCondition() != null && !this.invoice.getPaymentCondition().getIsFree().booleanValue() || this.invoice.getDueDate() == null) {
            this.invoice.setDueDate(this.getDueDate());
        }
    }

    protected void checkInvoiceDate(Sequence sequence) throws AxelorException {
        String query = "self.statusSelect = :ventilated AND self.invoiceDate > :invoiceDate AND self.operationTypeSelect = :operationTypeSelect AND self.company = :company ";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ventilated", 3);
        params.put("invoiceDate", this.invoice.getInvoiceDate());
        params.put("operationTypeSelect", this.invoice.getOperationTypeSelect());
        params.put("company", (Object)this.invoice.getCompany());
        if (sequence.getMonthlyResetOk().booleanValue()) {
            query = query + "AND EXTRACT (month from self.invoiceDate) = :month ";
            params.put("month", this.invoice.getInvoiceDate().getMonthValue());
        }
        if (sequence.getYearlyResetOk().booleanValue()) {
            query = query + "AND EXTRACT (year from self.invoiceDate) = :year ";
            params.put("year", this.invoice.getInvoiceDate().getYear());
        }
        if (this.invoiceRepo.all().filter(query).bind(params).count() > 0L) {
            Invoice lastInvoice = (Invoice)((Object)this.invoiceRepo.all().filter(query).bind(params).order("invoiceDate").fetchOne());
            if (sequence.getMonthlyResetOk().booleanValue()) {
                throw new AxelorException((Model)((Object)sequence), 4, I18n.get((String)"Invoice's or credit note's date can't be previous last invoice ventilated on month's date : %s"), new Object[]{lastInvoice.getInvoiceDate().getMonth().toString()});
            }
            if (sequence.getYearlyResetOk().booleanValue()) {
                throw new AxelorException((Model)((Object)sequence), 4, I18n.get((String)"Invoice's or credit note's date can't be previous last invoice ventilated on year's date : %s"), new Object[]{Integer.toString(lastInvoice.getInvoiceDate().getYear())});
            }
            throw new AxelorException((Model)((Object)this.invoice), 4, I18n.get((String)"Invoice's or credit note's date can't be previous last invoice ventilated's date : %s"), new Object[]{lastInvoice.getInvoiceDate().toString()});
        }
    }

    protected LocalDate getDueDate() throws AxelorException {
        if (InvoiceToolService.isPurchase(this.invoice)) {
            return InvoiceToolService.getDueDate(this.invoice.getPaymentCondition(), this.invoice.getOriginDate());
        }
        return InvoiceToolService.getDueDate(this.invoice.getPaymentCondition(), this.invoice.getInvoiceDate());
    }

    protected void setMove() throws AxelorException {
        if (this.invoice.getInTaxTotal().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        this.log.debug("In Set Move");
        Move move = this.moveService.createMove(this.invoice);
        if (move != null) {
            this.moveService.createMoveUseExcessPaymentOrDue(this.invoice);
        }
    }

    protected void generateFixedAsset() throws AxelorException {
        if (this.invoice.getInTaxTotal().compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        this.log.debug("Generate fixed asset");
        this.fixedAssetService.createFixedAssets(this.invoice);
    }

    protected void setStatus() {
        this.invoice.setStatusSelect(3);
    }

    protected void setInvoiceId() throws AxelorException {
        if (!this.sequenceService.isEmptyOrDraftSequenceNumber(this.invoice.getInvoiceId())) {
            return;
        }
        Sequence sequence = this.getSequence();
        if (!InvoiceToolService.isPurchase(this.invoice)) {
            this.checkInvoiceDate(sequence);
        }
        this.invoice.setInvoiceId(this.sequenceService.getSequenceNumber(sequence, this.invoice.getInvoiceDate()));
        if (this.invoice.getInvoiceId() != null) {
            return;
        }
        throw new AxelorException((Model)((Object)this.invoice), 4, I18n.get((String)"Company %s does not have any invoice's nor credit note's sequence"), new Object[]{this.invoice.getCompany().getName()});
    }

    protected Sequence getSequence() throws AxelorException {
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(this.invoice.getCompany());
        switch (this.invoice.getOperationTypeSelect()) {
            case 1: {
                return this.accountConfigService.getSuppInvSequence(accountConfig);
            }
            case 2: {
                return this.accountConfigService.getSuppRefSequence(accountConfig);
            }
            case 3: {
                return this.accountConfigService.getCustInvSequence(accountConfig);
            }
            case 4: {
                return this.accountConfigService.getCustRefSequence(accountConfig);
            }
        }
        throw new AxelorException((Model)((Object)this.invoice), 1, I18n.get((String)"Invoice type missing on invoice %s"), new Object[]{this.invoice.getInvoiceId()});
    }
}

