/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.invoice.workflow.ventilate;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.workflow.ventilate.WorkflowVentilationService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCreateService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.message.exception.AxelorMessageException;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

public class WorkflowVentilationServiceImpl
implements WorkflowVentilationService {
    protected AccountConfigService accountConfigService;
    protected InvoicePaymentRepository invoicePaymentRepo;
    protected InvoicePaymentCreateService invoicePaymentCreateService;

    @Inject
    public WorkflowVentilationServiceImpl(AccountConfigService accountConfigService, InvoicePaymentRepository invoicePaymentRepo, InvoicePaymentCreateService invoicePaymentCreateService) {
        this.accountConfigService = accountConfigService;
        this.invoicePaymentRepo = invoicePaymentRepo;
        this.invoicePaymentCreateService = invoicePaymentCreateService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void afterVentilation(Invoice invoice) throws AxelorException {
        Company company = invoice.getCompany();
        if (!this.accountConfigService.getAccountConfig(company).getGenerateMoveForInvoicePayment().booleanValue()) {
            this.copyAdvancePaymentToInvoice(invoice);
        }
        if (invoice.getInvoiceAutomaticMail().booleanValue()) {
            try {
                ((TemplateMessageService)Beans.get(TemplateMessageService.class)).generateAndSendMessage((Model)((Object)invoice), invoice.getInvoiceMessageTemplate());
            }
            catch (Exception e) {
                TraceBackService.trace((AxelorException)new AxelorMessageException((Throwable)e, (Model)((Object)invoice), 4));
            }
        }
    }

    protected void copyAdvancePaymentToInvoice(Invoice invoice) throws AxelorException {
        Set<Invoice> advancePaymentInvoiceSet = invoice.getAdvancePaymentInvoiceSet();
        if (advancePaymentInvoiceSet == null) {
            return;
        }
        for (Invoice advancePaymentInvoice : advancePaymentInvoiceSet) {
            List<InvoicePayment> advancePayments = advancePaymentInvoice.getInvoicePaymentList();
            if (advancePayments == null) continue;
            for (InvoicePayment advancePayment : advancePayments) {
                InvoicePayment imputationPayment = this.invoicePaymentCreateService.createInvoicePayment(invoice, advancePayment.getAmount(), advancePayment.getPaymentDate(), advancePayment.getCurrency(), advancePayment.getPaymentMode(), 6);
                advancePayment.setImputedBy(imputationPayment);
                imputationPayment.setCompanyBankDetails(advancePayment.getCompanyBankDetails());
                invoice.addInvoicePaymentListItem(imputationPayment);
                this.invoicePaymentRepo.save((Model)((Object)imputationPayment));
            }
        }
        List<InvoicePayment> invoicePayments = invoice.getInvoicePaymentList();
        if (invoicePayments == null || invoicePayments.isEmpty()) {
            return;
        }
        BigDecimal totalPayments = invoicePayments.stream().map(InvoicePayment::getAmount).reduce(BigDecimal::add).get();
        if (totalPayments.compareTo(invoice.getInTaxTotal()) > 0) {
            throw new AxelorException((Model)((Object)invoice), 5, I18n.get((String)"Sum of advance payments amounts is higher than the total of this invoice."));
        }
    }
}

