/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;

public class MoveCancelService {
    protected MoveRepository moveRepository;
    protected AccountConfigService accountConfigService;

    @Inject
    public MoveCancelService(AccountConfigService accountConfigService, MoveRepository moveRepository) {
        this.accountConfigService = accountConfigService;
        this.moveRepository = moveRepository;
    }

    @Transactional(rollbackOn={Exception.class})
    public void cancel(Move move) throws AxelorException {
        if (move == null) {
            return;
        }
        for (MoveLine moveLine : move.getMoveLineList()) {
            if (!moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getAmountPaid().compareTo(BigDecimal.ZERO) == 0) continue;
            throw new AxelorException((Model)((Object)move), 4, I18n.get((String)"Move should be unreconcile before to cancel the invoice"));
        }
        if (move.getPeriod() == null || move.getPeriod().getStatusSelect() == 2) {
            throw new AxelorException((Model)((Object)move), 4, I18n.get((String)"Move is ventilated on a closed period, and can't be canceled"));
        }
        if (move.getStatusSelect().equals(3)) {
            throw new AxelorException((Model)((Object)move), 4, I18n.get((String)"The move is validated and so can not be canceled."));
        }
        try {
            if (move.getStatusSelect() == 1 || this.accountConfigService.getAccountConfig(move.getCompany()).getAllowRemovalValidatedMove().booleanValue()) {
                this.moveRepository.remove((Model)((Object)move));
            } else {
                move.setStatusSelect(4);
                this.moveRepository.save((Model)((Object)move));
            }
        }
        catch (Exception e) {
            throw new AxelorException((Model)((Object)move), 4, I18n.get((String)"So many accounting operations are used on this move, so move can't be canceled"));
        }
    }
}

