/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.PeriodService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.config.CompanyConfigService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveCreateService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PeriodService periodService;
    protected MoveRepository moveRepository;
    protected CompanyConfigService companyConfigService;
    protected AppAccountService appAccountService;

    @Inject
    public MoveCreateService(AppAccountService appAccountService, PeriodService periodService, MoveRepository moveRepository, CompanyConfigService companyConfigService) {
        this.periodService = periodService;
        this.moveRepository = moveRepository;
        this.companyConfigService = companyConfigService;
        this.appAccountService = appAccountService;
    }

    public Move createMove(Journal journal, Company company, Currency currency, Partner partner, PaymentMode paymentMode, int technicalOriginSelect) throws AxelorException {
        return this.createMove(journal, company, currency, partner, this.appAccountService.getTodayDate(company), paymentMode, technicalOriginSelect);
    }

    public Move createMove(Journal journal, Company company, Currency currency, Partner partner, LocalDate date, PaymentMode paymentMode, int technicalOriginSelect) throws AxelorException {
        return this.createMove(journal, company, currency, partner, date, paymentMode, technicalOriginSelect, false, false, false);
    }

    public Move createMove(Journal journal, Company company, Currency currency, Partner partner, LocalDate date, PaymentMode paymentMode, int technicalOriginSelect, boolean ignoreInDebtRecoveryOk, boolean ignoreInAccountingOk, boolean autoYearClosureMove) throws AxelorException {
        this.log.debug("Creating a new generic accounting move (journal : {}, company : {}", new Object[]{journal.getName(), company.getName()});
        Move move = new Move();
        move.setJournal(journal);
        move.setCompany(company);
        move.setIgnoreInDebtRecoveryOk(ignoreInDebtRecoveryOk);
        move.setIgnoreInAccountingOk(ignoreInAccountingOk);
        move.setAutoYearClosureMove(autoYearClosureMove);
        if (autoYearClosureMove) {
            move.setPeriod(this.periodService.getPeriod(date, company, 1));
            if (move.getPeriod() == null) {
                throw new AxelorException(4, I18n.get((String)"No period found or it has been closed for the company %s for the date %s"), new Object[]{company.getName(), date.toString()});
            }
        } else {
            move.setPeriod(this.periodService.getActivePeriod(date, company, 1));
        }
        move.setDate(date);
        move.setMoveLineList(new ArrayList<MoveLine>());
        Currency companyCurrency = this.companyConfigService.getCompanyCurrency(company);
        if (companyCurrency != null) {
            move.setCompanyCurrency(companyCurrency);
            move.setCompanyCurrencyCode(companyCurrency.getCode());
        }
        if (currency == null) {
            currency = move.getCompanyCurrency();
        }
        if (currency != null) {
            move.setCurrency(currency);
            move.setCurrencyCode(currency.getCode());
        }
        move.setPartner(partner);
        move.setPaymentMode(paymentMode);
        move.setTechnicalOriginSelect(technicalOriginSelect);
        this.moveRepository.save((Model)((Object)move));
        move.setReference(((SequenceService)Beans.get(SequenceService.class)).getDraftSequenceNumber((Model)((Object)move)));
        return move;
    }

    public Move createMoveWithPaymentVoucher(Journal journal, Company company, PaymentVoucher paymentVoucher, Partner partner, LocalDate date, PaymentMode paymentMode, int technicalOriginSelect) throws AxelorException {
        Move move = this.createMove(journal, company, paymentVoucher.getCurrency(), partner, date, paymentMode, technicalOriginSelect);
        move.setPaymentVoucher(paymentVoucher);
        return move;
    }
}

