/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.service.AccountCustomerService;
import com.axelor.apps.account.service.AccountingService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;
import java.util.List;

public class MoveCustAccountService {
    protected AccountCustomerService accountCustomerService;

    @Inject
    public MoveCustAccountService(AccountCustomerService accountCustomerService) {
        this.accountCustomerService = accountCustomerService;
    }

    public void updateCustomerAccount(Move move) throws AxelorException {
        this.updateCustomerAccount(this.getPartnerOfMove(move), move.getCompany());
    }

    @Transactional(rollbackOn={Exception.class})
    public void updateCustomerAccount(List<Partner> partnerList, Company company) throws AxelorException {
        if (AccountingService.getUpdateCustomerAccount()) {
            this.accountCustomerService.updatePartnerAccountingSituation(partnerList, company, true, true, false);
        } else {
            this.flagPartners(partnerList, company);
        }
    }

    public List<Partner> getPartnerOfMove(Move move) {
        ArrayList<Partner> partnerList = new ArrayList<Partner>();
        for (MoveLine moveLine : move.getMoveLineList()) {
            if (moveLine.getAccount() == null || !moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getPartner() == null || partnerList.contains((Object)moveLine.getPartner())) continue;
            partnerList.add(moveLine.getPartner());
        }
        return partnerList;
    }

    public void flagPartners(List<Partner> partnerList, Company company) throws AxelorException {
        this.accountCustomerService.flagPartners(partnerList, company);
    }
}

