/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.InvoiceService;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.base.db.Company;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveExcessPaymentService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveLineRepository moveLineRepository;
    protected MoveToolService moveToolService;

    @Inject
    public MoveExcessPaymentService(MoveLineRepository moveLineRepository, MoveToolService moveToolService) {
        this.moveLineRepository = moveLineRepository;
        this.moveToolService = moveToolService;
    }

    public List<MoveLine> getExcessPayment(Invoice invoice) throws AxelorException {
        Company company = invoice.getCompany();
        AccountConfig accountConfig = ((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(company);
        List<MoveLine> advancePaymentMoveLines = ((InvoiceService)Beans.get(InvoiceService.class)).getMoveLinesFromAdvancePayments(invoice);
        if (accountConfig.getAutoReconcileOnInvoice().booleanValue()) {
            List creditMoveLines = this.moveLineRepository.all().filter("self.move.company = ?1 AND (self.move.statusSelect = ?2 OR self.move.statusSelect = ?3) AND self.move.ignoreInAccountingOk IN (false,null) AND self.account.useForPartnerBalance = ?4 AND self.credit > 0 and self.amountRemaining > 0 AND self.partner = ?5 ORDER BY self.date ASC", new Object[]{company, 3, 2, true, invoice.getPartner()}).fetch();
            this.log.debug("Nombre de trop-per\u00e7us \u00e0 imputer sur la facture r\u00e9cup\u00e9r\u00e9 : {}", (Object)creditMoveLines.size());
            advancePaymentMoveLines.addAll(creditMoveLines);
        }
        advancePaymentMoveLines = advancePaymentMoveLines.stream().distinct().collect(Collectors.toList());
        return advancePaymentMoveLines;
    }

    public List<MoveLine> getAdvancePaymentMoveList(Invoice invoice) {
        ArrayList moveLineList = Lists.newArrayList();
        if (invoice.getInvoicePaymentList() != null) {
            for (InvoicePayment invoicePayment : invoice.getInvoicePaymentList()) {
                if (invoicePayment.getMove() == null || invoicePayment.getMove().getMoveLineList() == null) continue;
                for (MoveLine moveLine : invoicePayment.getMove().getMoveLineList()) {
                    if (moveLine.getCredit().compareTo(BigDecimal.ZERO) == 0) continue;
                    moveLineList.add(moveLine);
                }
            }
            return this.moveToolService.orderListByDate(moveLineList);
        }
        return moveLineList;
    }
}

