/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.exception.AxelorException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

public interface MoveLineService {
    public static final boolean IS_CREDIT = false;
    public static final boolean IS_DEBIT = true;

    public MoveLine computeAnalyticDistribution(MoveLine var1);

    public MoveLine createAnalyticDistributionWithTemplate(MoveLine var1);

    public void updateAccountTypeOnAnalytic(MoveLine var1, List<AnalyticMoveLine> var2);

    public void generateAnalyticMoveLines(MoveLine var1);

    public MoveLine createMoveLine(Move var1, Partner var2, Account var3, BigDecimal var4, boolean var5, LocalDate var6, LocalDate var7, int var8, String var9, String var10) throws AxelorException;

    public MoveLine createMoveLine(Move var1, Partner var2, Account var3, BigDecimal var4, BigDecimal var5, BigDecimal var6, boolean var7, LocalDate var8, LocalDate var9, LocalDate var10, int var11, String var12, String var13) throws AxelorException;

    public MoveLine createMoveLine(Move var1, Partner var2, Account var3, BigDecimal var4, boolean var5, LocalDate var6, int var7, String var8, String var9) throws AxelorException;

    public List<MoveLine> createMoveLines(Invoice var1, Move var2, Company var3, Partner var4, Account var5, boolean var6, boolean var7, boolean var8) throws AxelorException;

    public MoveLine findConsolidateMoveLine(Map<List<Object>, MoveLine> var1, MoveLine var2, List<Object> var3);

    public List<MoveLine> consolidateMoveLines(List<MoveLine> var1);

    public MoveLine getCreditCustomerMoveLine(Invoice var1);

    public MoveLine getCreditCustomerMoveLine(Move var1);

    public MoveLine getDebitCustomerMoveLine(Invoice var1);

    public MoveLine getDebitCustomerMoveLine(Move var1);

    public String determineDescriptionMoveLine(Journal var1, String var2, String var3);

    public void usherProcess(MoveLine var1);

    public List<MoveLine> getReconciliableCreditMoveLines(List<MoveLine> var1);

    public List<MoveLine> getReconciliableDebitMoveLines(List<MoveLine> var1);

    public void reconcileMoveLinesWithCacheManagement(List<MoveLine> var1);

    public void reconcileMoveLines(List<MoveLine> var1);

    public void autoTaxLineGenerate(Move var1) throws AxelorException;

    public MoveLine createNewMoveLine(BigDecimal var1, BigDecimal var2, LocalDate var3, String var4, TaxLine var5, MoveLine var6);

    public void validateMoveLine(MoveLine var1) throws AxelorException;

    public MoveLine generateTaxPaymentMoveLineList(MoveLine var1, Invoice var2, Reconcile var3) throws AxelorException;

    public MoveLine reverseTaxPaymentMoveLines(MoveLine var1, Reconcile var2) throws AxelorException;

    public MoveLine computeTaxAmount(MoveLine var1) throws AxelorException;
}

