/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.move.MoveCreateService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveRemoveService;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.account.service.move.MoveValidateService;
import com.axelor.exception.AxelorException;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

public interface MoveService {
    public MoveLineService getMoveLineService();

    public MoveCreateService getMoveCreateService();

    public MoveValidateService getMoveValidateService();

    public MoveRemoveService getMoveRemoveService();

    public MoveToolService getMoveToolService();

    public ReconcileService getReconcileService();

    public Move createMove(Invoice var1) throws AxelorException;

    public Move createMoveUseExcessPaymentOrDue(Invoice var1) throws AxelorException;

    public Move createMoveUseInvoiceDue(Invoice var1) throws AxelorException;

    public void createMoveUseExcessPayment(Invoice var1) throws AxelorException;

    public Move createMoveUseDebit(Invoice var1, List<MoveLine> var2, MoveLine var3) throws AxelorException;

    public Move generateReverse(Move var1, boolean var2, boolean var3, boolean var4, LocalDate var5) throws AxelorException;

    public MoveLine findMoveLineByAccount(Move var1, Account var2) throws AxelorException;

    public Map<String, Object> computeTotals(Move var1);

    public String filterPartner(Move var1);

    public Move generateReverse(Move var1, Map<String, Object> var2) throws AxelorException;
}

