/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AnalyticMoveLine;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.db.repo.ReconcileRepository;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.invoice.InvoiceToolService;
import com.axelor.apps.account.service.move.MoveCreateService;
import com.axelor.apps.account.service.move.MoveDueService;
import com.axelor.apps.account.service.move.MoveExcessPaymentService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveRemoveService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.account.service.move.MoveValidateService;
import com.axelor.apps.account.service.payment.PaymentService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveServiceImpl
implements MoveService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveLineService moveLineService;
    protected MoveCreateService moveCreateService;
    protected MoveValidateService moveValidateService;
    protected MoveRemoveService moveRemoveService;
    protected MoveToolService moveToolService;
    protected ReconcileService reconcileService;
    protected MoveDueService moveDueService;
    protected PaymentService paymentService;
    protected MoveExcessPaymentService moveExcessPaymentService;
    protected AccountConfigService accountConfigService;
    protected MoveRepository moveRepository;
    protected AppAccountService appAccountService;

    @Inject
    public MoveServiceImpl(AppAccountService appAccountService, MoveLineService moveLineService, MoveCreateService moveCreateService, MoveValidateService moveValidateService, MoveToolService moveToolService, MoveRemoveService moveRemoveService, ReconcileService reconcileService, MoveDueService moveDueService, PaymentService paymentService, MoveExcessPaymentService moveExcessPaymentService, MoveRepository moveRepository, AccountConfigService accountConfigService) {
        this.moveLineService = moveLineService;
        this.moveCreateService = moveCreateService;
        this.moveValidateService = moveValidateService;
        this.moveRemoveService = moveRemoveService;
        this.moveToolService = moveToolService;
        this.reconcileService = reconcileService;
        this.moveDueService = moveDueService;
        this.paymentService = paymentService;
        this.moveExcessPaymentService = moveExcessPaymentService;
        this.moveRepository = moveRepository;
        this.accountConfigService = accountConfigService;
        this.appAccountService = appAccountService;
    }

    @Override
    public MoveLineService getMoveLineService() {
        return this.moveLineService;
    }

    @Override
    public MoveCreateService getMoveCreateService() {
        return this.moveCreateService;
    }

    @Override
    public MoveValidateService getMoveValidateService() {
        return this.moveValidateService;
    }

    @Override
    public MoveRemoveService getMoveRemoveService() {
        return this.moveRemoveService;
    }

    @Override
    public MoveToolService getMoveToolService() {
        return this.moveToolService;
    }

    @Override
    public ReconcileService getReconcileService() {
        return this.reconcileService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Move createMove(Invoice invoice) throws AxelorException {
        Move move = null;
        if (invoice != null && invoice.getInvoiceLineList() != null) {
            Journal journal = invoice.getJournal();
            Company company = invoice.getCompany();
            Partner partner = invoice.getPartner();
            Account account = invoice.getPartnerAccount();
            this.log.debug("Cr\u00e9ation d'une \u00e9criture comptable sp\u00e9cifique \u00e0 la facture {} (Soci\u00e9t\u00e9 : {}, Journal : {})", new Object[]{invoice.getInvoiceId(), company.getName(), journal.getCode()});
            move = this.moveCreateService.createMove(journal, company, invoice.getCurrency(), partner, invoice.getInvoiceDate(), invoice.getPaymentMode(), 2);
            if (move != null) {
                move.setInvoice(invoice);
                boolean isPurchase = InvoiceToolService.isPurchase(invoice);
                boolean isDebitCustomer = this.moveToolService.isDebitCustomer(invoice, false);
                move.getMoveLineList().addAll(this.moveLineService.createMoveLines(invoice, move, company, partner, account, journal.getIsInvoiceMoveConsolidated(), isPurchase, isDebitCustomer));
                this.moveRepository.save((Model)((Object)move));
                invoice.setMove(move);
                invoice.setCompanyInTaxTotalRemaining(this.moveToolService.getInTaxTotalRemaining(invoice));
                this.moveValidateService.validate(move);
            }
        }
        return move;
    }

    @Override
    public Move createMoveUseExcessPaymentOrDue(Invoice invoice) throws AxelorException {
        Move move = null;
        if (invoice != null) {
            if (this.moveToolService.isDebitCustomer(invoice, true)) {
                this.createMoveUseExcessPayment(invoice);
            } else {
                this.createMoveUseInvoiceDue(invoice);
            }
        }
        return move;
    }

    @Override
    public Move createMoveUseInvoiceDue(Invoice invoice) throws AxelorException {
        Company company = invoice.getCompany();
        Move move = null;
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        List<MoveLine> debitMoveLines = this.moveDueService.getInvoiceDue(invoice, accountConfig.getAutoReconcileOnInvoice());
        if (!debitMoveLines.isEmpty()) {
            MoveLine invoiceCustomerMoveLine = this.moveToolService.getCustomerMoveLineByLoop(invoice);
            if (this.moveToolService.isSameAccount(debitMoveLines, invoiceCustomerMoveLine.getAccount())) {
                ArrayList<MoveLine> creditMoveLineList = new ArrayList<MoveLine>();
                creditMoveLineList.add(invoiceCustomerMoveLine);
                this.paymentService.useExcessPaymentOnMoveLines(debitMoveLines, creditMoveLineList);
            } else {
                this.createMoveUseDebit(invoice, debitMoveLines, invoiceCustomerMoveLine);
            }
            this.reconcileService.balanceCredit(invoiceCustomerMoveLine);
            invoice.setCompanyInTaxTotalRemaining(this.moveToolService.getInTaxTotalRemaining(invoice));
        }
        return move;
    }

    @Override
    public void createMoveUseExcessPayment(Invoice invoice) throws AxelorException {
        Company company = invoice.getCompany();
        List<MoveLine> creditMoveLineList = this.moveExcessPaymentService.getAdvancePaymentMoveList(invoice);
        AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
        creditMoveLineList.addAll(this.moveExcessPaymentService.getExcessPayment(invoice));
        if (creditMoveLineList != null && creditMoveLineList.size() != 0) {
            Partner partner = invoice.getPartner();
            Account account = invoice.getPartnerAccount();
            MoveLine invoiceCustomerMoveLine = this.moveToolService.getCustomerMoveLineByLoop(invoice);
            Journal journal = this.accountConfigService.getAutoMiscOpeJournal(accountConfig);
            if (this.moveToolService.isSameAccount(creditMoveLineList, account)) {
                ArrayList<MoveLine> debitMoveLineList = new ArrayList<MoveLine>();
                debitMoveLineList.add(invoiceCustomerMoveLine);
                this.paymentService.useExcessPaymentOnMoveLines(debitMoveLineList, creditMoveLineList);
            } else {
                this.log.debug("Cr\u00e9ation d'une \u00e9criture comptable O.D. sp\u00e9cifique \u00e0 l'emploie des trop-per\u00e7us {} (Soci\u00e9t\u00e9 : {}, Journal : {})", new Object[]{invoice.getInvoiceId(), company.getName(), journal.getCode()});
                Move move = this.moveCreateService.createMove(journal, company, null, partner, invoice.getInvoiceDate(), null, 2);
                if (move != null) {
                    BigDecimal totalCreditAmount = this.moveToolService.getTotalCreditAmount(creditMoveLineList);
                    BigDecimal amount = totalCreditAmount.min(invoiceCustomerMoveLine.getDebit());
                    MoveLine creditMoveLine = this.moveLineService.createMoveLine(move, partner, account, amount, false, this.appAccountService.getTodayDate(company), 1, invoice.getInvoiceId(), null);
                    move.getMoveLineList().add(creditMoveLine);
                    this.paymentService.useExcessPaymentWithAmountConsolidated(creditMoveLineList, amount, move, 2, partner, company, account, invoice.getInvoiceDate(), invoice.getDueDate());
                    this.moveValidateService.validate(move);
                    Reconcile reconcile = this.reconcileService.createReconcile(invoiceCustomerMoveLine, creditMoveLine, amount, false);
                    if (reconcile != null) {
                        this.reconcileService.confirmReconcile(reconcile, true);
                    }
                }
            }
            invoice.setCompanyInTaxTotalRemaining(this.moveToolService.getInTaxTotalRemaining(invoice));
        }
    }

    @Override
    public Move createMoveUseDebit(Invoice invoice, List<MoveLine> debitMoveLines, MoveLine invoiceCustomerMoveLine) throws AxelorException {
        Company company = invoice.getCompany();
        Partner partner = invoice.getPartner();
        Account account = invoice.getPartnerAccount();
        Journal journal = this.accountConfigService.getAutoMiscOpeJournal(this.accountConfigService.getAccountConfig(company));
        this.log.debug("Cr\u00e9ation d'une \u00e9criture comptable O.D. sp\u00e9cifique \u00e0 l'emploie des trop-per\u00e7us {} (Soci\u00e9t\u00e9 : {}, Journal : {})", new Object[]{invoice.getInvoiceId(), company.getName(), journal.getCode()});
        BigDecimal remainingAmount = invoice.getInTaxTotal().abs();
        this.log.debug("Montant \u00e0 payer avec l'avoir r\u00e9cup\u00e9r\u00e9 : {}", (Object)remainingAmount);
        Move oDmove = this.moveCreateService.createMove(journal, company, null, partner, invoice.getInvoiceDate(), null, 2);
        if (oDmove != null) {
            BigDecimal totalDebitAmount = this.moveToolService.getTotalDebitAmount(debitMoveLines);
            BigDecimal amount = totalDebitAmount.min(invoiceCustomerMoveLine.getCredit());
            MoveLine debitMoveLine = this.moveLineService.createMoveLine(oDmove, partner, account, amount, true, this.appAccountService.getTodayDate(company), 1, invoice.getInvoiceId(), null);
            oDmove.getMoveLineList().add(debitMoveLine);
            this.paymentService.createExcessPaymentWithAmount(debitMoveLines, amount, oDmove, 2, partner, company, null, account, this.appAccountService.getTodayDate(company));
            this.moveValidateService.validate(oDmove);
            Reconcile reconcile = this.reconcileService.createReconcile(debitMoveLine, invoiceCustomerMoveLine, amount, false);
            if (reconcile != null) {
                this.reconcileService.confirmReconcile(reconcile, true);
            }
        }
        return oDmove;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public Move generateReverse(Move move, boolean isAutomaticReconcile, boolean isAutomaticAccounting, boolean isUnreconcileOriginalMove, LocalDate dateOfReversion) throws AxelorException {
        Move newMove = this.moveCreateService.createMove(move.getJournal(), move.getCompany(), move.getCurrency(), move.getPartner(), dateOfReversion, move.getPaymentMode(), 1, move.getIgnoreInDebtRecoveryOk(), move.getIgnoreInAccountingOk(), move.getAutoYearClosureMove());
        move.setInvoice(move.getInvoice());
        move.setPaymentVoucher(move.getPaymentVoucher());
        boolean validatedMove = move.getStatusSelect() == 2 || move.getStatusSelect() == 3;
        for (MoveLine moveLine : move.getMoveLineList()) {
            this.log.debug("Moveline {}", (Object)moveLine);
            Boolean isDebit = moveLine.getDebit().compareTo(BigDecimal.ZERO) > 0;
            MoveLine newMoveLine = this.generateReverseMoveLine(newMove, moveLine, dateOfReversion, isDebit);
            if (moveLine.getAnalyticDistributionTemplate() != null) {
                newMoveLine.setAnalyticDistributionTemplate(moveLine.getAnalyticDistributionTemplate());
                List<AnalyticMoveLine> analyticMoveLineList = ((AnalyticMoveLineService)Beans.get(AnalyticMoveLineService.class)).generateLines(newMoveLine.getAnalyticDistributionTemplate(), newMoveLine.getDebit().add(newMoveLine.getCredit()), 3, dateOfReversion);
                if (CollectionUtils.isNotEmpty(analyticMoveLineList)) {
                    analyticMoveLineList.forEach(analyticMoveLine -> newMoveLine.addAnalyticMoveLineListItem((AnalyticMoveLine)((Object)analyticMoveLine)));
                }
            }
            newMove.addMoveLineListItem(newMoveLine);
            if (isUnreconcileOriginalMove) {
                List reconcileList = ((ReconcileRepository)((Object)Beans.get(ReconcileRepository.class))).all().filter("self.statusSelect != ?1 AND (self.debitMoveLine = ?2 OR self.creditMoveLine = ?2)", new Object[]{3, moveLine}).fetch();
                for (Reconcile reconcile : reconcileList) {
                    this.reconcileService.unreconcile(reconcile);
                }
            }
            if (!validatedMove || !isAutomaticReconcile) continue;
            if (isDebit.booleanValue()) {
                this.reconcileService.reconcile(moveLine, newMoveLine, false, true);
                continue;
            }
            this.reconcileService.reconcile(newMoveLine, moveLine, false, true);
        }
        if (validatedMove && isAutomaticAccounting) {
            this.moveValidateService.validate(newMove);
        }
        return (Move)((Object)this.moveRepository.save((Model)((Object)newMove)));
    }

    @Override
    public MoveLine findMoveLineByAccount(Move move, Account account) throws AxelorException {
        return move.getMoveLineList().stream().filter(moveLine -> moveLine.getAccount().equals((Object)account)).findFirst().orElseThrow(() -> new AxelorException((Model)((Object)move), 3, I18n.get((String)"%s account not found in move %s"), new Object[]{account.getName(), move.getReference()}));
    }

    @Override
    public Map<String, Object> computeTotals(Move move) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (move.getMoveLineList() == null || move.getMoveLineList().isEmpty()) {
            return values;
        }
        values.put("$totalLines", move.getMoveLineList().size());
        BigDecimal totalDebit = move.getMoveLineList().stream().map(MoveLine::getDebit).reduce(BigDecimal.ZERO, BigDecimal::add);
        values.put("$totalDebit", totalDebit);
        BigDecimal totalCredit = move.getMoveLineList().stream().map(MoveLine::getCredit).reduce(BigDecimal.ZERO, BigDecimal::add);
        values.put("$totalCredit", totalCredit);
        BigDecimal difference = totalDebit.subtract(totalCredit);
        values.put("$difference", difference);
        return values;
    }

    @Override
    public Move generateReverse(Move move, Map<String, Object> assistantMap) throws AxelorException {
        move = this.generateReverse(move, (Boolean)assistantMap.get("isAutomaticReconcile"), (Boolean)assistantMap.get("isAutomaticAccounting"), (Boolean)assistantMap.get("isUnreconcileOriginalMove"), (LocalDate)assistantMap.get("dateOfReversion"));
        return move;
    }

    protected MoveLine generateReverseMoveLine(Move reverseMove, MoveLine orgineMoveLine, LocalDate dateOfReversion, boolean isDebit) throws AxelorException {
        MoveLine reverseMoveLine = this.moveLineService.createMoveLine(reverseMove, orgineMoveLine.getPartner(), orgineMoveLine.getAccount(), orgineMoveLine.getCurrencyAmount(), orgineMoveLine.getDebit().add(orgineMoveLine.getCredit()), orgineMoveLine.getCurrencyRate(), !isDebit, dateOfReversion, dateOfReversion, dateOfReversion, orgineMoveLine.getCounter(), orgineMoveLine.getName(), null);
        return reverseMoveLine;
    }

    @Override
    public String filterPartner(Move move) {
        Long companyId = move.getCompany().getId();
        String domain = "self.isContact = false AND " + companyId + " member of self.companySet";
        if (move.getJournal() != null && !Strings.isNullOrEmpty((String)move.getJournal().getCompatiblePartnerTypeSelect())) {
            domain = domain + " AND (";
            String[] partnerSet = move.getJournal().getCompatiblePartnerTypeSelect().split(", ");
            String lastPartner = partnerSet[partnerSet.length - 1];
            for (String partner : partnerSet) {
                domain = domain + "self." + partner + " = true";
                if (partner.equals(lastPartner)) continue;
                domain = domain + " OR ";
            }
            domain = domain + ")";
        }
        return domain;
    }
}

