/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.MoveTemplate;
import com.axelor.apps.account.db.MoveTemplateLine;
import com.axelor.apps.account.db.MoveTemplateType;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.db.repo.MoveTemplateRepository;
import com.axelor.apps.account.service.AnalyticMoveLineService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.move.MoveValidateService;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.tax.TaxService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveTemplateService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveService moveService;
    protected MoveValidateService moveValidateService;
    protected MoveRepository moveRepo;
    protected MoveLineService moveLineService;
    protected PartnerRepository partnerRepo;
    protected AnalyticMoveLineService analyticMoveLineService;
    protected TaxService taxService;
    @Inject
    protected MoveTemplateRepository moveTemplateRepo;

    @Inject
    public MoveTemplateService(MoveService moveService, MoveValidateService moveValidateService, MoveRepository moveRepo, MoveLineService moveLineService, PartnerRepository partnerRepo, AnalyticMoveLineService analyticMoveLineService, TaxService taxService) {
        this.moveService = moveService;
        this.moveValidateService = moveValidateService;
        this.moveRepo = moveRepo;
        this.moveLineService = moveLineService;
        this.partnerRepo = partnerRepo;
        this.analyticMoveLineService = analyticMoveLineService;
        this.taxService = taxService;
    }

    @Transactional
    public void validateMoveTemplateLine(MoveTemplate moveTemplate) {
        moveTemplate.setIsValid(true);
        for (MoveTemplateLine line : moveTemplate.getMoveTemplateLineList()) {
            line.setIsValid(true);
        }
        this.moveTemplateRepo.save((Model)((Object)moveTemplate));
    }

    @Transactional(rollbackOn={Exception.class})
    public List<Long> generateMove(MoveTemplateType moveTemplateType, MoveTemplate moveTemplate, List<HashMap<String, Object>> dataList, LocalDate date, List<HashMap<String, Object>> moveTemplateList) throws AxelorException {
        if (moveTemplateType.getTypeSelect() == 1) {
            return this.generateMove(moveTemplate, dataList);
        }
        if (moveTemplateType.getTypeSelect() == 2) {
            return this.generateMove(date, moveTemplateList);
        }
        return new ArrayList<Long>();
    }

    @Transactional(rollbackOn={Exception.class})
    public List<Long> generateMove(MoveTemplate moveTemplate, List<HashMap<String, Object>> dataList) throws AxelorException {
        ArrayList<Long> moveList = new ArrayList<Long>();
        BigDecimal hundred = new BigDecimal(100);
        for (HashMap<String, Object> data : dataList) {
            LocalDate moveDate = LocalDate.parse(data.get("date").toString(), DateTimeFormatter.ISO_DATE);
            boolean isDebit = false;
            Partner debitPartner = null;
            Partner creditPartner = null;
            BigDecimal moveBalance = new BigDecimal(data.get("moveBalance").toString());
            Partner partner = null;
            if (data.get("debitPartner") != null) {
                partner = debitPartner = (Partner)((Object)this.partnerRepo.find(Long.parseLong(((HashMap)data.get("debitPartner")).get("id").toString())));
            }
            if (data.get("creditPartner") != null) {
                partner = creditPartner = (Partner)((Object)this.partnerRepo.find(Long.parseLong(((HashMap)data.get("creditPartner")).get("id").toString())));
            }
            if (moveTemplate.getJournal().getCompany() == null) continue;
            Move move = this.moveService.getMoveCreateService().createMove(moveTemplate.getJournal(), moveTemplate.getJournal().getCompany(), null, partner, moveDate, null, 3);
            int counter = 1;
            for (MoveTemplateLine moveTemplateLine : moveTemplate.getMoveTemplateLineList()) {
                TaxLine taxLine;
                partner = null;
                if (moveTemplateLine.getDebitCreditSelect().equals("D")) {
                    isDebit = true;
                    if (moveTemplateLine.getHasPartnerToDebit().booleanValue()) {
                        partner = debitPartner;
                    }
                } else if (moveTemplateLine.getDebitCreditSelect().equals("C")) {
                    isDebit = false;
                    if (moveTemplateLine.getHasPartnerToCredit().booleanValue()) {
                        partner = creditPartner;
                    }
                }
                BigDecimal amount = moveBalance.multiply(moveTemplateLine.getPercentage()).divide(hundred, RoundingMode.HALF_EVEN);
                MoveLine moveLine = this.moveLineService.createMoveLine(move, partner, moveTemplateLine.getAccount(), amount, isDebit, moveDate, moveDate, counter, moveTemplate.getFullName(), moveTemplateLine.getName());
                move.getMoveLineList().add(moveLine);
                Tax tax = moveTemplateLine.getTax();
                if (tax != null && (taxLine = this.taxService.getTaxLine(tax, moveDate)) != null) {
                    moveLine.setTaxLine(taxLine);
                    moveLine.setTaxRate(taxLine.getValue());
                    moveLine.setTaxCode(tax.getCode());
                }
                moveLine.setAnalyticDistributionTemplate(moveTemplateLine.getAnalyticDistributionTemplate());
                this.moveLineService.generateAnalyticMoveLines(moveLine);
                ++counter;
            }
            if (moveTemplate.getAutomaticallyValidate().booleanValue()) {
                this.moveValidateService.validate(move);
            }
            this.moveRepo.save((Model)((Object)move));
            moveList.add(move.getId());
        }
        return moveList;
    }

    @Transactional(rollbackOn={Exception.class})
    public List<Long> generateMove(LocalDate moveDate, List<HashMap<String, Object>> moveTemplateList) throws AxelorException {
        ArrayList<Long> moveList = new ArrayList<Long>();
        for (HashMap<String, Object> moveTemplateMap : moveTemplateList) {
            MoveTemplate moveTemplate = (MoveTemplate)((Object)this.moveTemplateRepo.find((long)((Integer)moveTemplateMap.get("id"))));
            if (moveTemplate.getJournal().getCompany() == null) continue;
            Move move = this.moveService.getMoveCreateService().createMove(moveTemplate.getJournal(), moveTemplate.getJournal().getCompany(), null, null, moveDate, null, 3);
            int counter = 1;
            for (MoveTemplateLine moveTemplateLine : moveTemplate.getMoveTemplateLineList()) {
                TaxLine taxLine;
                BigDecimal amount = moveTemplateLine.getDebit().add(moveTemplateLine.getCredit());
                MoveLine moveLine = this.moveLineService.createMoveLine(move, moveTemplateLine.getPartner(), moveTemplateLine.getAccount(), amount, moveTemplateLine.getDebit().compareTo(BigDecimal.ZERO) == 1, moveDate, moveDate, counter, moveTemplate.getFullName(), moveTemplateLine.getName());
                move.getMoveLineList().add(moveLine);
                Tax tax = moveTemplateLine.getTax();
                if (tax != null && (taxLine = this.taxService.getTaxLine(tax, moveDate)) != null) {
                    moveLine.setTaxLine(taxLine);
                    moveLine.setTaxRate(taxLine.getValue());
                    moveLine.setTaxCode(tax.getCode());
                }
                moveLine.setAnalyticDistributionTemplate(moveTemplateLine.getAnalyticDistributionTemplate());
                this.moveLineService.generateAnalyticMoveLines(moveLine);
                ++counter;
            }
            if (moveTemplate.getAutomaticallyValidate().booleanValue()) {
                this.moveValidateService.validate(move);
            }
            this.moveRepo.save((Model)((Object)move));
            moveList.add(move.getId());
        }
        return moveList;
    }

    public boolean checkValidity(MoveTemplate moveTemplate) {
        MoveTemplateType moveTemplateType = moveTemplate.getMoveTemplateType();
        if (moveTemplateType == null) {
            return false;
        }
        if (moveTemplateType.getTypeSelect() == 1) {
            return this.checkValidityInPercentage(moveTemplate);
        }
        if (moveTemplateType.getTypeSelect() == 2) {
            return this.checkValidityInAmount(moveTemplate);
        }
        return false;
    }

    protected boolean checkValidityInPercentage(MoveTemplate moveTemplate) {
        BigDecimal debitPercent = BigDecimal.ZERO;
        BigDecimal creditPercent = BigDecimal.ZERO;
        for (MoveTemplateLine line : moveTemplate.getMoveTemplateLineList()) {
            LOG.debug("Adding percent: {}", (Object)line.getPercentage());
            if ("D".equals(line.getDebitCreditSelect())) {
                debitPercent = debitPercent.add(line.getPercentage());
                continue;
            }
            creditPercent = creditPercent.add(line.getPercentage());
        }
        LOG.debug("Debit percent: {}, Credit percent: {}", new Object[]{debitPercent, creditPercent});
        if (debitPercent.compareTo(BigDecimal.ZERO) != 0 && creditPercent.compareTo(BigDecimal.ZERO) != 0 && debitPercent.compareTo(creditPercent) == 0) {
            this.validateMoveTemplateLine(moveTemplate);
            return true;
        }
        return false;
    }

    protected boolean checkValidityInAmount(MoveTemplate moveTemplate) {
        BigDecimal debit = BigDecimal.ZERO;
        BigDecimal credit = BigDecimal.ZERO;
        for (MoveTemplateLine line : moveTemplate.getMoveTemplateLineList()) {
            debit = debit.add(line.getDebit());
            credit = credit.add(line.getCredit());
        }
        LOG.debug("Debit : {}, Credit : {}", new Object[]{debit, credit});
        if (debit.compareTo(BigDecimal.ZERO) != 0 && credit.compareTo(BigDecimal.ZERO) != 0 && debit.compareTo(credit) == 0) {
            this.validateMoveTemplateLine(moveTemplate);
            return true;
        }
        return false;
    }

    public Map<String, Object> computeTotals(MoveTemplate moveTemplate) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (moveTemplate.getMoveTemplateLineList() == null || moveTemplate.getMoveTemplateLineList().isEmpty()) {
            return values;
        }
        values.put("$totalLines", moveTemplate.getMoveTemplateLineList().size());
        BigDecimal totalDebit = moveTemplate.getMoveTemplateLineList().stream().map(MoveTemplateLine::getDebit).reduce(BigDecimal.ZERO, BigDecimal::add);
        values.put("$totalDebit", totalDebit);
        BigDecimal totalCredit = moveTemplate.getMoveTemplateLineList().stream().map(MoveTemplateLine::getCredit).reduce(BigDecimal.ZERO, BigDecimal::add);
        values.put("$totalCredit", totalCredit);
        BigDecimal difference = totalDebit.subtract(totalCredit);
        values.put("$difference", difference);
        return values;
    }
}

