/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.service.AccountCustomerService;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveToolService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected MoveLineService moveLineService;
    protected MoveLineRepository moveLineRepository;
    protected AccountCustomerService accountCustomerService;
    protected AccountConfigService accountConfigService;

    @Inject
    public MoveToolService(MoveLineService moveLineService, MoveLineRepository moveLineRepository, AccountCustomerService accountCustomerService, AccountConfigService accountConfigService) {
        this.moveLineService = moveLineService;
        this.moveLineRepository = moveLineRepository;
        this.accountCustomerService = accountCustomerService;
        this.accountConfigService = accountConfigService;
    }

    public boolean isMinus(Invoice invoice) {
        return invoice.getInTaxTotal().compareTo(BigDecimal.ZERO) == -1;
    }

    public boolean isDebitCustomer(Invoice invoice, boolean reverseDirectionForNegativeAmount) throws AxelorException {
        boolean isDebitCustomer;
        switch (invoice.getOperationTypeSelect()) {
            case 1: {
                isDebitCustomer = false;
                break;
            }
            case 2: {
                isDebitCustomer = true;
                break;
            }
            case 3: {
                isDebitCustomer = true;
                break;
            }
            case 4: {
                isDebitCustomer = false;
                break;
            }
            default: {
                throw new AxelorException((Model)((Object)invoice), 1, I18n.get((String)"Invoice type missing on invoice %s"), new Object[]{invoice.getInvoiceId()});
            }
        }
        if (reverseDirectionForNegativeAmount && this.isMinus(invoice)) {
            isDebitCustomer = !isDebitCustomer;
        }
        return isDebitCustomer;
    }

    public MoveLine getInvoiceCustomerMoveLineByLoop(Invoice invoice) throws AxelorException {
        if (this.isDebitCustomer(invoice, true)) {
            return this.moveLineService.getDebitCustomerMoveLine(invoice);
        }
        return this.moveLineService.getCreditCustomerMoveLine(invoice);
    }

    public MoveLine getInvoiceCustomerMoveLineByQuery(Invoice invoice) throws AxelorException {
        if (this.isDebitCustomer(invoice, true)) {
            return (MoveLine)((Object)this.moveLineRepository.all().filter("self.move = ?1 AND self.account = ?2 AND self.debit > 0 AND self.amountRemaining > 0", new Object[]{invoice.getMove(), invoice.getPartnerAccount()}).fetchOne());
        }
        return (MoveLine)((Object)this.moveLineRepository.all().filter("self.move = ?1 AND self.account = ?2 AND self.credit > 0 AND self.amountRemaining > 0", new Object[]{invoice.getMove(), invoice.getPartnerAccount()}).fetchOne());
    }

    public MoveLine getCustomerMoveLineByLoop(Invoice invoice) throws AxelorException {
        if (invoice.getRejectMoveLine() != null && invoice.getRejectMoveLine().getAmountRemaining().compareTo(BigDecimal.ZERO) > 0) {
            return invoice.getRejectMoveLine();
        }
        return this.getInvoiceCustomerMoveLineByLoop(invoice);
    }

    public MoveLine getCustomerMoveLineByQuery(Invoice invoice) throws AxelorException {
        if (invoice.getRejectMoveLine() != null && invoice.getRejectMoveLine().getAmountRemaining().compareTo(BigDecimal.ZERO) > 0) {
            return invoice.getRejectMoveLine();
        }
        return this.getInvoiceCustomerMoveLineByQuery(invoice);
    }

    public Account getCustomerAccount(Partner partner, Company company, boolean isSupplierAccount) throws AxelorException {
        AccountingSituationService situationService = (AccountingSituationService)Beans.get(AccountingSituationService.class);
        return isSupplierAccount ? situationService.getSupplierAccount(partner, company) : situationService.getCustomerAccount(partner, company);
    }

    public boolean isSameAccount(List<MoveLine> moveLineList, Account account) {
        for (MoveLine moveLine : moveLineList) {
            if (moveLine.getAccount().equals((Object)account)) continue;
            return false;
        }
        return true;
    }

    public BigDecimal getTotalCreditAmount(List<MoveLine> creditMoveLineList) {
        BigDecimal totalCredit = BigDecimal.ZERO;
        for (MoveLine moveLine : creditMoveLineList) {
            totalCredit = totalCredit.add(moveLine.getAmountRemaining());
        }
        return totalCredit;
    }

    public BigDecimal getTotalDebitAmount(List<MoveLine> debitMoveLineList) {
        BigDecimal totalDebit = BigDecimal.ZERO;
        for (MoveLine moveLine : debitMoveLineList) {
            totalDebit = totalDebit.add(moveLine.getAmountRemaining());
        }
        return totalDebit;
    }

    public BigDecimal getBalanceAmount(List<MoveLine> moveLineList) {
        BigDecimal balance = BigDecimal.ZERO;
        if (moveLineList == null) {
            return balance;
        }
        for (MoveLine moveLine : moveLineList) {
            balance = balance.add(moveLine.getDebit());
            balance = balance.subtract(moveLine.getCredit());
        }
        return balance;
    }

    public BigDecimal getBalanceCurrencyAmount(List<MoveLine> moveLineList) {
        BigDecimal balance = BigDecimal.ZERO;
        if (moveLineList == null) {
            return balance;
        }
        for (MoveLine moveLine : moveLineList) {
            if (moveLine.getDebit().compareTo(moveLine.getCredit()) == 1) {
                balance = balance.add(moveLine.getCurrencyAmount());
                continue;
            }
            balance = balance.subtract(moveLine.getCurrencyAmount());
        }
        return balance;
    }

    public MoveLine getOrignalInvoiceFromRefund(Invoice invoice) {
        Invoice originalInvoice = invoice.getOriginalInvoice();
        if (originalInvoice != null && originalInvoice.getMove() != null) {
            for (MoveLine moveLine : originalInvoice.getMove().getMoveLineList()) {
                if (!moveLine.getAccount().getUseForPartnerBalance().booleanValue() || moveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0 || moveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
                return moveLine;
            }
        }
        return null;
    }

    @Transactional(rollbackOn={Exception.class})
    public BigDecimal getInTaxTotalRemaining(Invoice invoice) throws AxelorException {
        BigDecimal inTaxTotalRemaining = BigDecimal.ZERO;
        this.log.debug("Update Remaining amount of invoice : {}", (Object)invoice.getInvoiceId());
        if (invoice != null) {
            boolean isMinus = this.isMinus(invoice);
            ((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).save((Model)((Object)invoice));
            MoveLine moveLine = this.getCustomerMoveLineByLoop(invoice);
            if (moveLine != null) {
                inTaxTotalRemaining = inTaxTotalRemaining.add(moveLine.getAmountRemaining());
                if (isMinus) {
                    inTaxTotalRemaining = inTaxTotalRemaining.negate();
                }
            }
        }
        return inTaxTotalRemaining;
    }

    public MoveLine getOppositeMoveLine(MoveLine moveLine) {
        if (moveLine.getDebit().compareTo(BigDecimal.ZERO) > 0) {
            for (MoveLine oppositeMoveLine : moveLine.getMove().getMoveLineList()) {
                if (oppositeMoveLine.getCredit().compareTo(BigDecimal.ZERO) <= 0) continue;
                return oppositeMoveLine;
            }
        }
        if (moveLine.getCredit().compareTo(BigDecimal.ZERO) > 0) {
            for (MoveLine oppositeMoveLine : moveLine.getMove().getMoveLineList()) {
                if (oppositeMoveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0) continue;
                return oppositeMoveLine;
            }
        }
        return null;
    }

    public List<MoveLine> orderListByDate(List<MoveLine> list) {
        Collections.sort(list, new Comparator<MoveLine>(){

            @Override
            public int compare(MoveLine o1, MoveLine o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        return list;
    }

    public boolean isDebitMoveLine(MoveLine moveLine) {
        return moveLine.getDebit().compareTo(BigDecimal.ZERO) == 1;
    }

    public List<MoveLine> getToReconcileCreditMoveLines(Move move) {
        ArrayList<MoveLine> moveLineList = new ArrayList<MoveLine>();
        if (move.getStatusSelect() == 3 || move.getStatusSelect() == 2) {
            for (MoveLine moveLine : move.getMoveLineList()) {
                if (moveLine.getCredit().compareTo(BigDecimal.ZERO) <= 0 || moveLine.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0 || !moveLine.getAccount().getUseForPartnerBalance().booleanValue()) continue;
                moveLineList.add(moveLine);
            }
        }
        return moveLineList;
    }
}

