/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.move;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.db.repo.MoveRepository;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveCustAccountService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveSequenceService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.common.ObjectUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveValidateService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AccountConfigService accountConfigService;
    protected MoveSequenceService moveSequenceService;
    protected MoveCustAccountService moveCustAccountService;
    protected MoveRepository moveRepository;
    protected AccountRepository accountRepository;
    protected PartnerRepository partnerRepository;
    protected AppBaseService appBaseService;

    @Inject
    public MoveValidateService(AccountConfigService accountConfigService, MoveSequenceService moveSequenceService, MoveCustAccountService moveCustAccountService, MoveRepository moveRepository, AccountRepository accountRepository, PartnerRepository partnerRepository, AppBaseService appBaseService) {
        this.accountConfigService = accountConfigService;
        this.moveSequenceService = moveSequenceService;
        this.moveCustAccountService = moveCustAccountService;
        this.moveRepository = moveRepository;
        this.accountRepository = accountRepository;
        this.partnerRepository = partnerRepository;
        this.appBaseService = appBaseService;
    }

    public void completeMoveLines(Move move) {
        LocalDate date = move.getDate();
        Partner partner = move.getPartner();
        int counter = 1;
        for (MoveLine moveLine : move.getMoveLineList()) {
            if (moveLine.getDate() == null) {
                moveLine.setDate(date);
            }
            if (moveLine.getAccount() != null && moveLine.getAccount().getUseForPartnerBalance().booleanValue() && moveLine.getDueDate() == null) {
                moveLine.setDueDate(date);
            }
            if (moveLine.getOriginDate() == null) {
                moveLine.setOriginDate(date);
            }
            if (partner != null) {
                moveLine.setPartner(partner);
            }
            moveLine.setCounter(counter);
            ++counter;
        }
    }

    public void checkPreconditions(Move move) throws AxelorException {
        Journal journal = move.getJournal();
        Company company = move.getCompany();
        if (company == null) {
            throw new AxelorException(4, String.format(I18n.get((String)"You must select a company for the move %s"), move.getReference()));
        }
        if (journal == null) {
            throw new AxelorException(4, String.format(I18n.get((String)"You must select a journal for the move %s"), move.getReference()));
        }
        if (move.getPeriod() == null) {
            throw new AxelorException(4, String.format(I18n.get((String)"You must select a period for the move %s"), move.getReference()));
        }
        if (move.getMoveLineList() == null || move.getMoveLineList().isEmpty()) {
            throw new AxelorException(5, String.format(I18n.get((String)"The move %s cannot be empty"), move.getReference()));
        }
        if (move.getMoveLineList().stream().allMatch(moveLine -> moveLine.getDebit().add(moveLine.getCredit()).compareTo(BigDecimal.ZERO) == 0)) {
            throw new AxelorException(5, String.format(I18n.get((String)"The move %s cannot be empty"), move.getReference()));
        }
        MoveLineService moveLineService = (MoveLineService)Beans.get(MoveLineService.class);
        if (move.getFunctionalOriginSelect() != 2 && move.getFunctionalOriginSelect() != 1) {
            for (MoveLine moveLine2 : move.getMoveLineList()) {
                Account account = moveLine2.getAccount();
                if (account.getIsTaxAuthorizedOnMoveLine().booleanValue() && account.getIsTaxRequiredOnMoveLine().booleanValue() && moveLine2.getTaxLine() == null) {
                    throw new AxelorException(1, String.format(I18n.get((String)"Tax is mandatory for the account %s on the move line %s"), account.getName(), moveLine2.getName()));
                }
                if (moveLine2.getAnalyticDistributionTemplate() == null && ObjectUtils.isEmpty(moveLine2.getAnalyticMoveLineList()) && account.getAnalyticDistributionAuthorized().booleanValue() && account.getAnalyticDistributionRequiredOnMoveLines().booleanValue()) {
                    throw new AxelorException(1, String.format(I18n.get((String)"Analytic distribution template is mandatory for the account %s on the move line %s."), account.getName(), moveLine2.getName()));
                }
                if (account != null && !account.getAnalyticDistributionAuthorized().booleanValue() && (moveLine2.getAnalyticDistributionTemplate() != null || moveLine2.getAnalyticMoveLineList() != null && !moveLine2.getAnalyticMoveLineList().isEmpty())) {
                    throw new AxelorException((Model)((Object)move), 4, String.format(I18n.get((String)"An analytic distribution is set in move line %s but the account used do not allow analytic distribution"), moveLine2.getName()));
                }
                moveLineService.validateMoveLine(moveLine2);
            }
            this.validateWellBalancedMove(move);
        }
    }

    public void validate(Move move) throws AxelorException {
        this.validate(move, true);
    }

    @Transactional(rollbackOn={Exception.class})
    public void validate(Move move, boolean updateCustomerAccount) throws AxelorException {
        this.log.debug("Validation de l'\u00e9criture comptable {}", (Object)move.getReference());
        this.checkPreconditions(move);
        if (move.getPeriod().getStatusSelect() == 2 && !move.getAutoYearClosureMove().booleanValue()) {
            throw new AxelorException(4, I18n.get((String)"Accounting move can not be validated because its fiscal period is closed."));
        }
        Boolean dayBookMode = this.accountConfigService.getAccountConfig(move.getCompany()).getAccountingDaybook();
        if (!dayBookMode.booleanValue() || move.getStatusSelect() == 2) {
            this.moveSequenceService.setSequence(move);
        }
        if (move.getPeriod().getStatusSelect() == 3) {
            move.setAdjustingMove(true);
        }
        this.completeMoveLines(move);
        this.freezeAccountAndPartnerFieldsOnMoveLines(move);
        this.updateValidateStatus(move, dayBookMode);
        this.moveRepository.save((Model)((Object)move));
        if (updateCustomerAccount) {
            this.moveCustAccountService.updateCustomerAccount(move);
        }
    }

    public void validateWellBalancedMove(Move move) throws AxelorException {
        this.log.debug("Well-balanced validation on account move {}", (Object)move.getReference());
        if (move.getMoveLineList() != null) {
            BigDecimal totalDebit = BigDecimal.ZERO;
            BigDecimal totalCredit = BigDecimal.ZERO;
            for (MoveLine moveLine : move.getMoveLineList()) {
                if (moveLine.getDebit().compareTo(BigDecimal.ZERO) > 0 && moveLine.getCredit().compareTo(BigDecimal.ZERO) > 0) {
                    throw new AxelorException((Model)((Object)move), 5, I18n.get((String)"Move account sens %s can't be determined"), new Object[]{moveLine.getName()});
                }
                totalDebit = totalDebit.add(moveLine.getDebit());
                totalCredit = totalCredit.add(moveLine.getCredit());
            }
            if (totalDebit.compareTo(totalCredit) != 0) {
                throw new AxelorException((Model)((Object)move), 5, I18n.get((String)"Account move %s has a total debit different than total credit : %s <> %s"), new Object[]{move.getReference(), totalDebit, totalCredit});
            }
        }
    }

    public void updateValidateStatus(Move move, boolean daybook) throws AxelorException {
        if (daybook && move.getStatusSelect() == 1) {
            move.setStatusSelect(2);
        } else {
            move.setStatusSelect(3);
            move.setValidationDate(this.appBaseService.getTodayDate(move.getCompany()));
        }
    }

    @Transactional(rollbackOn={Exception.class})
    public void updateInDayBookMode(Move move) throws AxelorException {
        this.checkPreconditions(move);
        HashSet<Partner> partnerSet = new HashSet<Partner>();
        partnerSet.addAll(this.getPartnerOfMoveBeforeUpdate(move));
        partnerSet.addAll(this.moveCustAccountService.getPartnerOfMove(move));
        ArrayList<Partner> partnerList = new ArrayList<Partner>();
        partnerList.addAll(partnerSet);
        this.freezeAccountAndPartnerFieldsOnMoveLines(move);
        this.moveRepository.save((Model)((Object)move));
        this.moveCustAccountService.updateCustomerAccount(partnerList, move.getCompany());
    }

    public List<Partner> getPartnerOfMoveBeforeUpdate(Move move) {
        ArrayList<Partner> partnerList = new ArrayList<Partner>();
        for (MoveLine moveLine : move.getMoveLineList()) {
            Partner partner;
            Account account;
            if (moveLine.getAccountId() == null || (account = (Account)((Object)this.accountRepository.find(moveLine.getAccountId()))) == null || !account.getUseForPartnerBalance().booleanValue() || moveLine.getPartnerId() == null || (partner = (Partner)((Object)this.partnerRepository.find(moveLine.getPartnerId()))) == null || partnerList.contains((Object)partner)) continue;
            partnerList.add(partner);
        }
        return partnerList;
    }

    public void freezeAccountAndPartnerFieldsOnMoveLines(Move move) {
        for (MoveLine moveLine : move.getMoveLineList()) {
            Account account = moveLine.getAccount();
            moveLine.setAccountId(account.getId());
            moveLine.setAccountCode(account.getCode());
            moveLine.setAccountName(account.getName());
            Partner partner = moveLine.getPartner();
            if (partner != null) {
                moveLine.setPartnerId(partner.getId());
                moveLine.setPartnerFullName(partner.getFullName());
                moveLine.setPartnerSeq(partner.getPartnerSeq());
            }
            if (moveLine.getTaxLine() == null) continue;
            moveLine.setTaxRate(moveLine.getTaxLine().getValue());
            moveLine.setTaxCode(moveLine.getTaxLine().getTax().getCode());
        }
    }

    public boolean validateMultiple(List<? extends Move> moveList) {
        boolean error = false;
        if (moveList == null) {
            return error;
        }
        try {
            for (Move move : moveList) {
                this.validate((Move)((Object)this.moveRepository.find(move.getId())));
                JPA.clear();
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
            error = true;
            JPA.clear();
        }
        return error;
    }

    public void validateMultiple(Query<Move> moveListQuery) throws AxelorException {
        Move move;
        while ((move = (Move)((Object)moveListQuery.fetchOne())) != null) {
            this.validate(move);
            JPA.clear();
        }
    }

    private String getPartnerFullName(Partner partner) {
        if (!Strings.isNullOrEmpty((String)partner.getName()) && !Strings.isNullOrEmpty((String)partner.getFirstName())) {
            return partner.getName() + " " + partner.getFirstName();
        }
        if (!Strings.isNullOrEmpty((String)partner.getName())) {
            return partner.getName();
        }
        if (!Strings.isNullOrEmpty((String)partner.getFirstName())) {
            return partner.getFirstName();
        }
        return "" + partner.getId();
    }
}

