/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.payment.invoice.payment;

import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveCancelService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCancelService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentToolService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoicePaymentCancelServiceImpl
implements InvoicePaymentCancelService {
    protected AccountConfigService accountConfigService;
    protected InvoicePaymentRepository invoicePaymentRepository;
    protected MoveCancelService moveCancelService;
    protected ReconcileService reconcileService;
    protected InvoicePaymentToolService invoicePaymentToolService;
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public InvoicePaymentCancelServiceImpl(AccountConfigService accountConfigService, InvoicePaymentRepository invoicePaymentRepository, MoveCancelService moveCancelService, ReconcileService reconcileService, InvoicePaymentToolService invoicePaymentToolService) {
        this.accountConfigService = accountConfigService;
        this.invoicePaymentRepository = invoicePaymentRepository;
        this.moveCancelService = moveCancelService;
        this.reconcileService = reconcileService;
        this.invoicePaymentToolService = invoicePaymentToolService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void cancel(InvoicePayment invoicePayment) throws AxelorException {
        Move paymentMove = invoicePayment.getMove();
        Reconcile reconcile = invoicePayment.getReconcile();
        this.log.debug("cancel : reconcile : {}", (Object)reconcile);
        if (reconcile != null && reconcile.getStatusSelect() == 2) {
            this.reconcileService.unreconcile(reconcile);
        }
        if (paymentMove != null && invoicePayment.getTypeSelect() == 2) {
            invoicePayment.setMove(null);
            this.moveCancelService.cancel(paymentMove);
        } else {
            this.updateCancelStatus(invoicePayment);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateCancelStatus(InvoicePayment invoicePayment) throws AxelorException {
        invoicePayment.setStatusSelect(2);
        this.invoicePaymentRepository.save((Model)((Object)invoicePayment));
        this.invoicePaymentToolService.updateAmountPaid(invoicePayment.getInvoice());
    }
}

