/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.payment.invoice.payment;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.ReconcileRepository;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentCreateService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentToolService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class InvoicePaymentCreateServiceImpl
implements InvoicePaymentCreateService {
    protected InvoicePaymentRepository invoicePaymentRepository;
    protected InvoicePaymentToolService invoicePaymentToolService;
    protected CurrencyService currencyService;
    protected AppBaseService appBaseService;

    @Inject
    public InvoicePaymentCreateServiceImpl(InvoicePaymentRepository invoicePaymentRepository, InvoicePaymentToolService invoicePaymentToolService, CurrencyService currencyService, AppBaseService appBaseService) {
        this.invoicePaymentRepository = invoicePaymentRepository;
        this.invoicePaymentToolService = invoicePaymentToolService;
        this.currencyService = currencyService;
        this.appBaseService = appBaseService;
    }

    @Override
    public InvoicePayment createInvoicePayment(Invoice invoice, BigDecimal amount, LocalDate paymentDate, Currency currency, PaymentMode paymentMode, int typeSelect) {
        return new InvoicePayment(amount, paymentDate, currency, paymentMode, invoice, typeSelect, 0);
    }

    @Override
    public InvoicePayment createInvoicePayment(Invoice invoice, BigDecimal amount, Move paymentMove) throws AxelorException {
        LocalDate paymentDate = paymentMove.getDate();
        BigDecimal amountConverted = this.currencyService.getAmountCurrencyConvertedAtDate(paymentMove.getCompanyCurrency(), paymentMove.getCurrency(), amount, paymentDate);
        int typePaymentMove = this.determineType(paymentMove);
        Currency currency = paymentMove.getCurrency();
        if (currency == null) {
            currency = paymentMove.getCompanyCurrency();
        }
        PaymentMode paymentMode = typePaymentMove == 3 || typePaymentMove == 4 ? null : paymentMove.getPaymentMode();
        InvoicePayment invoicePayment = this.createInvoicePayment(invoice, amountConverted, paymentDate, currency, paymentMode, typePaymentMove);
        invoicePayment.setMove(paymentMove);
        invoicePayment.setStatusSelect(1);
        PaymentVoucher paymentVoucher = paymentMove.getPaymentVoucher();
        if (paymentVoucher != null) {
            invoicePayment.setCompanyBankDetails(paymentVoucher.getCompanyBankDetails());
        } else if (invoice.getSchedulePaymentOk().booleanValue() && invoice.getPaymentSchedule() != null) {
            BankDetails companyBankDetails = invoice.getPaymentSchedule().getCompanyBankDetails();
            invoicePayment.setCompanyBankDetails(companyBankDetails);
        }
        this.computeAdvancePaymentImputation(invoicePayment, paymentMove);
        invoice.addInvoicePaymentListItem(invoicePayment);
        this.invoicePaymentToolService.updateAmountPaid(invoice);
        this.invoicePaymentRepository.save((Model)((Object)invoicePayment));
        return invoicePayment;
    }

    protected int determineType(Move move) {
        Invoice invoice = move.getInvoice();
        if (invoice != null) {
            if (invoice.getOperationTypeSelect() == 3 || invoice.getOperationTypeSelect() == 1) {
                return 4;
            }
            return 3;
        }
        if (move.getPaymentVoucher() != null) {
            return 2;
        }
        return 5;
    }

    protected void computeAdvancePaymentImputation(InvoicePayment invoicePayment, Move paymentMove) {
        List<InvoicePayment> invoicePaymentList;
        Invoice advanceInvoice = this.determineIfReconcileFromInvoice(paymentMove);
        if (advanceInvoice != null && (invoicePaymentList = advanceInvoice.getInvoicePaymentList()) != null && !invoicePaymentList.isEmpty()) {
            invoicePayment.setTypeSelect(6);
            InvoicePayment advancePayment = advanceInvoice.getInvoicePaymentList().get(0);
            advancePayment.setImputedBy(invoicePayment);
            this.invoicePaymentRepository.save((Model)((Object)advancePayment));
            invoicePayment.setCurrency(advancePayment.getCurrency());
            BigDecimal currentImputedAmount = invoicePayment.getAmount();
            BigDecimal totalAmountInAdvanceInvoice = advancePayment.getInvoice().getCompanyInTaxTotal();
            BigDecimal convertedImputedAmount = currentImputedAmount.multiply(advancePayment.getAmount()).divide(totalAmountInAdvanceInvoice, 2, RoundingMode.HALF_UP);
            invoicePayment.setAmount(convertedImputedAmount);
        }
    }

    protected Invoice determineIfReconcileFromInvoice(Move move) {
        List<MoveLine> moveLineList = move.getMoveLineList();
        if (moveLineList == null || moveLineList.size() != 2) {
            return null;
        }
        InvoicePaymentRepository invoicePaymentRepo = (InvoicePaymentRepository)((Object)Beans.get(InvoicePaymentRepository.class));
        for (MoveLine moveLine : moveLineList) {
            if (moveLine.getDebit().compareTo(BigDecimal.ZERO) <= 0) continue;
            Reconcile reconcile = (Reconcile)((Object)((ReconcileRepository)((Object)Beans.get(ReconcileRepository.class))).all().filter("self.debitMoveLine = ?", new Object[]{moveLine}).fetchOne());
            if (reconcile == null) {
                return null;
            }
            if (reconcile.getCreditMoveLine() == null || reconcile.getCreditMoveLine().getMove() == null) continue;
            Move candidatePaymentMove = reconcile.getCreditMoveLine().getMove();
            InvoicePayment invoicePayment = (InvoicePayment)((Object)invoicePaymentRepo.all().filter("self.move = :_move").bind("_move", (Object)candidatePaymentMove).fetchOne());
            if (invoicePayment == null || invoicePayment.getInvoice() == null || invoicePayment.getInvoice().getOperationSubTypeSelect() != 2) continue;
            return invoicePayment.getInvoice();
        }
        return null;
    }

    @Override
    @Transactional
    public InvoicePayment createInvoicePayment(Invoice invoice, BankDetails companyBankDetails) {
        InvoicePayment invoicePayment = this.createInvoicePayment(invoice, invoice.getInTaxTotal().subtract(invoice.getAmountPaid()), this.appBaseService.getTodayDate(invoice.getCompany()), invoice.getCurrency(), invoice.getPaymentMode(), 2);
        invoicePayment.setCompanyBankDetails(companyBankDetails);
        return (InvoicePayment)((Object)this.invoicePaymentRepository.save((Model)((Object)invoicePayment)));
    }

    @Transactional
    public InvoicePayment createInvoicePayment(Invoice invoice, PaymentMode paymentMode, BankDetails companyBankDetails, LocalDate paymentDate, LocalDate bankDepositDate, String chequeNumber) {
        InvoicePayment invoicePayment = this.createInvoicePayment(invoice, invoice.getInTaxTotal().subtract(invoice.getAmountPaid()), paymentDate, invoice.getCurrency(), paymentMode, 2);
        invoicePayment.setCompanyBankDetails(companyBankDetails);
        invoicePayment.setBankDepositDate(bankDepositDate);
        invoicePayment.setChequeNumber(chequeNumber);
        return (InvoicePayment)((Object)this.invoicePaymentRepository.save((Model)((Object)invoicePayment)));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public List<InvoicePayment> createMassInvoicePayment(List<Long> invoiceList, PaymentMode paymentMode, BankDetails companyBankDetails, LocalDate paymentDate, LocalDate bankDepositDate, String chequeNumber) throws AxelorException {
        ArrayList<InvoicePayment> invoicePaymentList = new ArrayList<InvoicePayment>();
        InvoiceRepository invoiceRepository = (InvoiceRepository)((Object)Beans.get(InvoiceRepository.class));
        for (Long invoiceId : invoiceList) {
            Invoice invoice = (Invoice)((Object)invoiceRepository.find(invoiceId));
            InvoicePayment invoicePayment = this.createInvoicePayment(invoice, paymentMode, companyBankDetails, paymentDate, bankDepositDate, chequeNumber);
            invoicePaymentList.add(invoicePayment);
            invoice.addInvoicePaymentListItem(invoicePayment);
            this.invoicePaymentToolService.updateAmountPaid(invoice);
        }
        return invoicePaymentList;
    }

    @Override
    public List<Long> getInvoiceIdsToPay(List<Long> invoiceIdList) throws AxelorException {
        Company company = null;
        Currency currency = null;
        ArrayList<Long> invoiceToPay = new ArrayList<Long>();
        Boolean isActivatePassedForPayment = ((AppAccountService)Beans.get(AppAccountService.class)).getAppAccount().getActivatePassedForPayment();
        for (Long invoiceId : invoiceIdList) {
            Invoice invoice = (Invoice)((Object)((InvoiceRepository)((Object)Beans.get(InvoiceRepository.class))).find(invoiceId));
            if (invoice.getStatusSelect() != 3 && invoice.getOperationSubTypeSelect() != 2 || invoice.getOperationSubTypeSelect() == 2 && invoice.getStatusSelect() != 2 || invoice.getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) continue;
            if (company == null) {
                company = invoice.getCompany();
            }
            if (currency == null) {
                currency = invoice.getCurrency();
            }
            if (invoice.getCompany() == null || company == null || !invoice.getCompany().equals((Object)company)) {
                throw new AxelorException(5, I18n.get((String)"The company is required and must be the same for all invoices"));
            }
            if (invoice.getCurrency() == null || currency == null || !invoice.getCurrency().equals((Object)currency)) {
                throw new AxelorException(5, I18n.get((String)"The currency is required and must be the same for all invoices"));
            }
            if (isActivatePassedForPayment.booleanValue() && invoice.getPfpValidateStatusSelect() != 2) {
                throw new AxelorException(5, I18n.get((String)"Their is at least one invoice selected that it is not validated to pay"));
            }
            invoiceToPay.add(invoiceId);
        }
        return invoiceToPay;
    }
}

