/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.payment.invoice.payment;

import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.db.repo.InvoiceRepository;
import com.axelor.apps.account.db.repo.PaymentModeRepository;
import com.axelor.apps.account.service.move.MoveToolService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentToolService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoicePaymentToolServiceImpl
implements InvoicePaymentToolService {
    protected InvoiceRepository invoiceRepo;
    protected MoveToolService moveToolService;
    protected InvoicePaymentRepository invoicePaymentRepo;
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public InvoicePaymentToolServiceImpl(InvoiceRepository invoiceRepo, MoveToolService moveToolService, InvoicePaymentRepository invoicePaymentRepo) {
        this.invoiceRepo = invoiceRepo;
        this.moveToolService = moveToolService;
        this.invoicePaymentRepo = invoicePaymentRepo;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateAmountPaid(Invoice invoice) throws AxelorException {
        invoice.setAmountPaid(this.computeAmountPaid(invoice));
        invoice.setAmountRemaining(invoice.getInTaxTotal().subtract(invoice.getAmountPaid()));
        this.updateHasPendingPayments(invoice);
        this.invoiceRepo.save((Model)((Object)invoice));
        this.log.debug("Invoice : {}, amount paid : {}", (Object)invoice.getInvoiceId(), (Object)invoice.getAmountPaid());
    }

    @Override
    @Transactional
    public void updateHasPendingPayments(Invoice invoice) {
        invoice.setHasPendingPayments(this.checkPendingPayments(invoice));
    }

    protected BigDecimal computeAmountPaid(Invoice invoice) throws AxelorException {
        BigDecimal amountPaid = BigDecimal.ZERO;
        if (invoice.getInvoicePaymentList() == null) {
            return amountPaid;
        }
        CurrencyService currencyService = (CurrencyService)Beans.get(CurrencyService.class);
        Currency invoiceCurrency = invoice.getCurrency();
        for (InvoicePayment invoicePayment : invoice.getInvoicePaymentList()) {
            if (invoicePayment.getStatusSelect() != 1) continue;
            this.log.debug("Amount paid without move : {}", (Object)invoicePayment.getAmount());
            amountPaid = amountPaid.add(currencyService.getAmountCurrencyConvertedAtDate(invoicePayment.getCurrency(), invoiceCurrency, invoicePayment.getAmount(), invoicePayment.getPaymentDate()));
        }
        boolean isMinus = this.moveToolService.isMinus(invoice);
        if (isMinus) {
            amountPaid = amountPaid.negate();
        }
        this.log.debug("Amount paid total : {}", (Object)amountPaid);
        return amountPaid;
    }

    protected boolean checkPendingPayments(Invoice invoice) {
        BigDecimal pendingAmount = BigDecimal.ZERO;
        if (invoice.getInvoicePaymentList() != null) {
            for (InvoicePayment invoicePayment : invoice.getInvoicePaymentList()) {
                if (invoicePayment.getStatusSelect() != 3) continue;
                pendingAmount = pendingAmount.add(invoicePayment.getAmount());
            }
        }
        return invoice.getAmountRemaining().compareTo(pendingAmount) <= 0;
    }

    @Override
    public List<BankDetails> findCompatibleBankDetails(Company company, InvoicePayment invoicePayment) {
        PaymentMode paymentMode = invoicePayment.getPaymentMode();
        if (company == null || paymentMode == null) {
            return new ArrayList<BankDetails>();
        }
        paymentMode = (PaymentMode)((Object)((PaymentModeRepository)((Object)Beans.get(PaymentModeRepository.class))).find(invoicePayment.getPaymentMode().getId()));
        return ((PaymentModeService)Beans.get(PaymentModeService.class)).getCompatibleBankDetailsList(paymentMode, company);
    }

    @Override
    public List<InvoicePayment> assignAdvancePayment(Invoice invoice, Invoice advancePayment) {
        List<InvoicePayment> advancePaymentList = advancePayment.getInvoicePaymentList();
        if (advancePaymentList == null || advancePaymentList.isEmpty()) {
            return advancePaymentList;
        }
        for (InvoicePayment invoicePayment : advancePaymentList) {
            invoice.addInvoicePaymentListItem(invoicePayment);
        }
        return advancePaymentList;
    }

    @Override
    public List<MoveLine> getCreditMoveLinesFromPayments(List<InvoicePayment> payments) {
        ArrayList<MoveLine> moveLines = new ArrayList<MoveLine>();
        for (InvoicePayment payment : payments) {
            Move move = payment.getMove();
            if (move == null || move.getMoveLineList() == null || move.getMoveLineList().isEmpty()) continue;
            moveLines.addAll(this.moveToolService.getToReconcileCreditMoveLines(move));
        }
        return moveLines;
    }

    @Override
    public void checkConditionBeforeSave(InvoicePayment invoicePayment) throws AxelorException {
        if (invoicePayment.getInvoice() != null && invoicePayment.getInvoice().getAmountRemaining().compareTo(BigDecimal.ZERO) <= 0) {
            throw new AxelorException(5, I18n.get((String)"The payment cannot be done because the amount remaining on the invoice %s is inferior or equal to 0."), new Object[]{invoicePayment.getInvoice().getInvoiceId()});
        }
    }
}

