/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.payment.invoice.payment;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.InvoicePayment;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.repo.InvoicePaymentRepository;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentToolService;
import com.axelor.apps.account.service.payment.invoice.payment.InvoicePaymentValidateService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;

public class InvoicePaymentValidateServiceImpl
implements InvoicePaymentValidateService {
    protected PaymentModeService paymentModeService;
    protected MoveService moveService;
    protected MoveLineService moveLineService;
    protected AccountConfigService accountConfigService;
    protected InvoicePaymentRepository invoicePaymentRepository;
    protected ReconcileService reconcileService;
    protected InvoicePaymentToolService invoicePaymentToolService;

    @Inject
    public InvoicePaymentValidateServiceImpl(PaymentModeService paymentModeService, MoveService moveService, MoveLineService moveLineService, AccountConfigService accountConfigService, InvoicePaymentRepository invoicePaymentRepository, ReconcileService reconcileService, InvoicePaymentToolService invoicePaymentToolService) {
        this.paymentModeService = paymentModeService;
        this.moveService = moveService;
        this.moveLineService = moveLineService;
        this.accountConfigService = accountConfigService;
        this.invoicePaymentRepository = invoicePaymentRepository;
        this.reconcileService = reconcileService;
        this.invoicePaymentToolService = invoicePaymentToolService;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validate(InvoicePayment invoicePayment, boolean force) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        if (!force && invoicePayment.getStatusSelect() != 0) {
            return;
        }
        invoicePayment.setStatusSelect(1);
        Company company = invoicePayment.getInvoice().getCompany();
        if (this.accountConfigService.getAccountConfig(company).getGenerateMoveForInvoicePayment().booleanValue()) {
            invoicePayment = this.createMoveForInvoicePayment(invoicePayment);
        } else {
            ((AccountingSituationService)Beans.get(AccountingSituationService.class)).updateCustomerCredit(invoicePayment.getInvoice().getPartner());
            invoicePayment = (InvoicePayment)((Object)this.invoicePaymentRepository.save((Model)((Object)invoicePayment)));
        }
        this.invoicePaymentToolService.updateAmountPaid(invoicePayment.getInvoice());
        if (invoicePayment.getInvoice() != null && invoicePayment.getInvoice().getOperationSubTypeSelect() == 2) {
            invoicePayment.setTypeSelect(1);
        }
        this.invoicePaymentRepository.save((Model)((Object)invoicePayment));
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void validate(InvoicePayment invoicePayment) throws AxelorException, JAXBException, IOException, DatatypeConfigurationException {
        this.validate(invoicePayment, false);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public InvoicePayment createMoveForInvoicePayment(InvoicePayment invoicePayment) throws AxelorException {
        Account customerAccount;
        Invoice invoice = invoicePayment.getInvoice();
        Company company = invoice.getCompany();
        PaymentMode paymentMode = invoicePayment.getPaymentMode();
        Partner partner = invoice.getPartner();
        LocalDate paymentDate = invoicePayment.getPaymentDate();
        BigDecimal paymentAmount = invoicePayment.getAmount();
        BankDetails companyBankDetails = invoicePayment.getCompanyBankDetails();
        Journal journal = this.paymentModeService.getPaymentModeJournal(paymentMode, company, companyBankDetails);
        boolean isDebitInvoice = this.moveService.getMoveToolService().isDebitCustomer(invoice, true);
        MoveLine invoiceMoveLine = this.moveService.getMoveToolService().getInvoiceCustomerMoveLineByLoop(invoice);
        if (invoice.getOperationSubTypeSelect() == 2) {
            AccountConfig accountConfig = this.accountConfigService.getAccountConfig(company);
            customerAccount = this.accountConfigService.getAdvancePaymentAccount(accountConfig);
        } else {
            if (invoiceMoveLine == null) {
                return null;
            }
            customerAccount = invoiceMoveLine.getAccount();
        }
        String origin = invoicePayment.getInvoice().getInvoiceId();
        if (invoicePayment.getPaymentMode().getTypeSelect() == 7 || invoicePayment.getPaymentMode().getTypeSelect() == 4) {
            origin = invoicePayment.getChequeNumber() != null ? invoicePayment.getChequeNumber() : origin;
        } else if (invoicePayment.getPaymentMode().getTypeSelect() == 6) {
            String string = origin = invoicePayment.getInvoicePaymentRef() != null ? invoicePayment.getInvoicePaymentRef() : origin;
        }
        if (invoicePayment.getInvoice().getOperationTypeSelect() == 1 || invoicePayment.getInvoice().getOperationTypeSelect() == 2) {
            origin = invoicePayment.getInvoice().getSupplierInvoiceNb();
        }
        Move move = this.moveService.getMoveCreateService().createMove(journal, company, invoicePayment.getCurrency(), partner, paymentDate, paymentMode, 2);
        move.addMoveLineListItem(this.moveLineService.createMoveLine(move, partner, this.paymentModeService.getPaymentModeAccount(paymentMode, company, companyBankDetails), paymentAmount, isDebitInvoice, paymentDate, null, 1, origin, invoicePayment.getDescription()));
        MoveLine customerMoveLine = this.moveLineService.createMoveLine(move, partner, customerAccount, paymentAmount, !isDebitInvoice, paymentDate, null, 2, origin, invoicePayment.getDescription());
        move.addMoveLineListItem(customerMoveLine);
        this.moveService.getMoveValidateService().validate(move);
        if (invoice.getOperationSubTypeSelect() != 2) {
            Reconcile reconcile = this.reconcileService.reconcile(invoiceMoveLine, customerMoveLine, true, false);
            invoicePayment.setReconcile(reconcile);
        }
        invoicePayment.setMove(move);
        this.invoicePaymentRepository.save((Model)((Object)invoicePayment));
        return invoicePayment;
    }
}

