/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.payment.paymentvoucher;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PayVoucherElementToPay;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.db.Reconcile;
import com.axelor.apps.account.db.repo.PayVoucherElementToPayRepository;
import com.axelor.apps.account.db.repo.PaymentVoucherRepository;
import com.axelor.apps.account.service.AccountCustomerService;
import com.axelor.apps.account.service.ReconcileService;
import com.axelor.apps.account.service.app.AppAccountService;
import com.axelor.apps.account.service.move.MoveLineService;
import com.axelor.apps.account.service.move.MoveService;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.account.service.payment.PaymentService;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherControlService;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherSequenceService;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherToolService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentVoucherConfirmService {
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected ReconcileService reconcileService;
    protected MoveLineService moveLineService;
    protected MoveService moveService;
    protected PaymentService paymentService;
    protected PaymentModeService paymentModeService;
    protected PaymentVoucherSequenceService paymentVoucherSequenceService;
    protected PaymentVoucherControlService paymentVoucherControlService;
    protected PaymentVoucherToolService paymentVoucherToolService;
    protected PayVoucherElementToPayRepository payVoucherElementToPayRepo;
    protected PaymentVoucherRepository paymentVoucherRepository;

    @Inject
    public PaymentVoucherConfirmService(ReconcileService reconcileService, MoveLineService moveLineService, MoveService moveService, PaymentService paymentService, PaymentModeService paymentModeService, PaymentVoucherSequenceService paymentVoucherSequenceService, PaymentVoucherControlService paymentVoucherControlService, PaymentVoucherToolService paymentVoucherToolService, PayVoucherElementToPayRepository payVoucherElementToPayRepo, PaymentVoucherRepository paymentVoucherRepository) {
        this.reconcileService = reconcileService;
        this.moveLineService = moveLineService;
        this.moveService = moveService;
        this.paymentService = paymentService;
        this.paymentModeService = paymentModeService;
        this.paymentVoucherSequenceService = paymentVoucherSequenceService;
        this.paymentVoucherControlService = paymentVoucherControlService;
        this.paymentVoucherToolService = paymentVoucherToolService;
        this.payVoucherElementToPayRepo = payVoucherElementToPayRepo;
        this.paymentVoucherRepository = paymentVoucherRepository;
    }

    @Transactional(rollbackOn={Exception.class})
    public void confirmPaymentVoucher(PaymentVoucher paymentVoucher) throws AxelorException {
        this.log.debug("In confirmPaymentVoucherService ....");
        this.paymentVoucherSequenceService.setReference(paymentVoucher);
        PaymentMode paymentMode = paymentVoucher.getPaymentMode();
        Company company = paymentVoucher.getCompany();
        BankDetails companyBankDetails = paymentVoucher.getCompanyBankDetails();
        Journal journal = this.paymentModeService.getPaymentModeJournal(paymentMode, company, companyBankDetails);
        Account paymentModeAccount = this.paymentModeService.getPaymentModeAccount(paymentMode, company, companyBankDetails);
        this.paymentVoucherControlService.checkPaymentVoucherField(paymentVoucher, company, paymentModeAccount, journal);
        if (paymentVoucher.getRemainingAmount().compareTo(BigDecimal.ZERO) > 0 && !journal.getExcessPaymentOk().booleanValue()) {
            throw new AxelorException((Model)((Object)paymentVoucher), 5, I18n.get((String)"%s : Caution - You can't pay for an amount higher than selected invoices"), new Object[]{I18n.get((String)"Warning !")});
        }
        AppAccountService appAccountService = (AppAccountService)Beans.get(AppAccountService.class);
        if (appAccountService.getAppAccount().getPaymentVouchersOnInvoice().booleanValue() && paymentVoucher.getPaymentMode().getValidatePaymentByDepositSlipPublication().booleanValue()) {
            this.waitForDepositSlip(paymentVoucher);
        } else {
            this.createMoveAndConfirm(paymentVoucher);
        }
        this.paymentVoucherSequenceService.setReceiptNo(paymentVoucher, company, journal);
        this.paymentVoucherRepository.save((Model)((Object)paymentVoucher));
    }

    private void waitForDepositSlip(PaymentVoucher paymentVoucher) {
        for (PayVoucherElementToPay payVoucherElementToPay : paymentVoucher.getPayVoucherElementToPayList()) {
            Invoice invoice = payVoucherElementToPay.getMoveLine().getMove().getInvoice();
            boolean hasPendingPayments = payVoucherElementToPay.getRemainingAmountAfterPayment().signum() <= 0;
            invoice.setHasPendingPayments(hasPendingPayments);
        }
        paymentVoucher.setStatusSelect(2);
    }

    @Transactional(rollbackOn={Exception.class})
    public void createMoveAndConfirm(PaymentVoucher paymentVoucher) throws AxelorException {
        Partner payerPartner = paymentVoucher.getPartner();
        PaymentMode paymentMode = paymentVoucher.getPaymentMode();
        Company company = paymentVoucher.getCompany();
        BankDetails companyBankDetails = paymentVoucher.getCompanyBankDetails();
        Journal journal = this.paymentModeService.getPaymentModeJournal(paymentMode, company, companyBankDetails);
        LocalDate paymentDate = paymentVoucher.getPaymentDate();
        boolean scheduleToBePaid = false;
        Account paymentModeAccount = this.paymentModeService.getPaymentModeAccount(paymentMode, company, companyBankDetails);
        boolean allRight = this.paymentVoucherControlService.checkIfSameAccount(paymentVoucher.getPayVoucherElementToPayList(), paymentVoucher.getMoveLine());
        this.log.debug("allRight : {}", (Object)allRight);
        if (allRight) {
            scheduleToBePaid = this.toPayWithExcessPayment(paymentVoucher.getPayVoucherElementToPayList(), paymentVoucher.getMoveLine(), scheduleToBePaid, paymentDate);
        }
        if (paymentVoucher.getMoveLine() == null || paymentVoucher.getMoveLine() != null && !allRight || scheduleToBePaid && !allRight && paymentVoucher.getMoveLine() != null) {
            Move move = this.moveService.getMoveCreateService().createMoveWithPaymentVoucher(journal, company, paymentVoucher, payerPartner, paymentDate, paymentMode, 2);
            move.setPaymentVoucher(paymentVoucher);
            paymentVoucher.setGeneratedMove(move);
            BigDecimal paidLineTotal = BigDecimal.ZERO;
            int moveLineNo = 1;
            boolean isDebitToPay = this.paymentVoucherToolService.isDebitToPay(paymentVoucher);
            for (PayVoucherElementToPay payVoucherElementToPay : this.getPayVoucherElementToPayList(paymentVoucher)) {
                MoveLine moveLineToPay = payVoucherElementToPay.getMoveLine();
                this.log.debug("PV moveLineToPay debit : {}", (Object)moveLineToPay.getDebit());
                this.log.debug("PV moveLineToPay amountPaid : {}", (Object)moveLineToPay.getAmountPaid());
                BigDecimal amountToPay = payVoucherElementToPay.getAmountToPayCurrency();
                if (amountToPay.compareTo(BigDecimal.ZERO) <= 0) continue;
                paidLineTotal = paidLineTotal.add(amountToPay);
                this.payMoveLine(move, moveLineNo++, payerPartner, moveLineToPay, amountToPay, payVoucherElementToPay, isDebitToPay, paymentDate);
            }
            MoveLine moveLine = null;
            if (paymentVoucher.getMoveLine() != null) {
                moveLine = this.moveLineService.createMoveLine(move, paymentVoucher.getPartner(), paymentVoucher.getMoveLine().getAccount(), paymentVoucher.getPaidAmount(), isDebitToPay, paymentDate, moveLineNo++, paymentVoucher.getRef(), null);
                Reconcile reconcile = this.reconcileService.createReconcile(moveLine, paymentVoucher.getMoveLine(), moveLine.getDebit(), !isDebitToPay);
                if (reconcile != null) {
                    this.reconcileService.confirmReconcile(reconcile, true);
                }
            } else {
                moveLine = this.moveLineService.createMoveLine(move, payerPartner, paymentModeAccount, paymentVoucher.getPaidAmount(), isDebitToPay, paymentDate, moveLineNo++, paymentVoucher.getRef(), null);
            }
            move.getMoveLineList().add(moveLine);
            if (paymentVoucher.getPaidAmount().compareTo(paidLineTotal) > 0) {
                BigDecimal bigDecimal = paymentVoucher.getRemainingAmount();
                Account partnerAccount = ((AccountCustomerService)Beans.get(AccountCustomerService.class)).getPartnerAccount(payerPartner, company, this.paymentVoucherToolService.isPurchase(paymentVoucher));
                moveLine = this.moveLineService.createMoveLine(move, paymentVoucher.getPartner(), partnerAccount, bigDecimal, !isDebitToPay, paymentDate, moveLineNo++, paymentVoucher.getRef(), null);
                move.getMoveLineList().add(moveLine);
                if (isDebitToPay) {
                    this.reconcileService.balanceCredit(moveLine);
                }
            }
            this.moveService.getMoveValidateService().validate(move);
            paymentVoucher.setGeneratedMove(move);
        }
        paymentVoucher.setStatusSelect(3);
        this.deleteUnPaidLines(paymentVoucher);
    }

    public void deleteUnPaidLines(PaymentVoucher paymentVoucher) {
        if (paymentVoucher.getPayVoucherElementToPayList() == null) {
            return;
        }
        paymentVoucher.getPayVoucherDueElementList().clear();
        ArrayList<PayVoucherElementToPay> payVoucherElementToPayToRemove = new ArrayList<PayVoucherElementToPay>();
        for (PayVoucherElementToPay payVoucherElementToPay : paymentVoucher.getPayVoucherElementToPayList()) {
            if (payVoucherElementToPay.getAmountToPay().compareTo(BigDecimal.ZERO) != 0 || payVoucherElementToPay.getMoveLineGenerated() != null) continue;
            payVoucherElementToPayToRemove.add(payVoucherElementToPay);
        }
        paymentVoucher.getPayVoucherElementToPayList().removeAll(payVoucherElementToPayToRemove);
    }

    public List<? extends PayVoucherElementToPay> getPayVoucherElementToPayList(PaymentVoucher paymentVoucher) {
        return this.payVoucherElementToPayRepo.all().filter("self.paymentVoucher = ?1 ORDER by self.sequence ASC", new Object[]{paymentVoucher}).fetch();
    }

    public boolean toPayWithExcessPayment(List<PayVoucherElementToPay> payVoucherElementToPayList, MoveLine creditMoveLine, boolean scheduleToBePaid, LocalDate paymentDate) throws AxelorException {
        boolean scheduleToBePaid2 = scheduleToBePaid;
        ArrayList<MoveLine> debitMoveLines = new ArrayList<MoveLine>();
        for (PayVoucherElementToPay payVoucherElementToPay : payVoucherElementToPayList) {
            debitMoveLines.add(payVoucherElementToPay.getMoveLine());
        }
        ArrayList<MoveLine> creditMoveLines = new ArrayList<MoveLine>();
        creditMoveLines.add(creditMoveLine);
        this.paymentService.useExcessPaymentOnMoveLines(debitMoveLines, creditMoveLines);
        return scheduleToBePaid2;
    }

    public MoveLine payMoveLine(Move paymentMove, int moveLineSeq, Partner payerPartner, MoveLine moveLineToPay, BigDecimal amountToPay, PayVoucherElementToPay payVoucherElementToPay, boolean isDebitToPay, LocalDate paymentDate) throws AxelorException {
        String invoiceName = "";
        invoiceName = moveLineToPay.getMove().getInvoice() != null ? moveLineToPay.getMove().getInvoice().getInvoiceId() : payVoucherElementToPay.getPaymentVoucher().getRef();
        MoveLine moveLine = this.moveLineService.createMoveLine(paymentMove, payerPartner, moveLineToPay.getAccount(), amountToPay, !isDebitToPay, paymentDate, moveLineSeq, invoiceName, null);
        paymentMove.addMoveLineListItem(moveLine);
        payVoucherElementToPay.setMoveLineGenerated(moveLine);
        BigDecimal amountInCompanyCurrency = moveLine.getDebit().add(moveLine.getCredit());
        Reconcile reconcile = this.reconcileService.createReconcile(moveLineToPay, moveLine, amountInCompanyCurrency, true);
        if (reconcile != null) {
            this.log.debug("Reconcile : : : {}", (Object)reconcile);
            this.reconcileService.confirmReconcile(reconcile, true);
        }
        return moveLine;
    }
}

