/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.payment.paymentvoucher;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PayVoucherElementToPay;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherSequenceService;
import com.axelor.apps.base.db.Company;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.List;

public class PaymentVoucherControlService {
    protected PaymentVoucherSequenceService paymentVoucherSequenceService;

    @Inject
    public PaymentVoucherControlService(PaymentVoucherSequenceService paymentVoucherSequenceService) {
        this.paymentVoucherSequenceService = paymentVoucherSequenceService;
    }

    public void checkPaymentVoucherField(PaymentVoucher paymentVoucher, Company company, Account paymentModeAccount, Journal journal) throws AxelorException {
        if (paymentVoucher.getPaidAmount().compareTo(BigDecimal.ZERO) < 1) {
            throw new AxelorException((Model)((Object)paymentVoucher), 5, I18n.get((String)"%s : Payment voucher n\u00b0 %s, the paid amount should be positive"), new Object[]{I18n.get((String)"Warning !"), paymentVoucher.getRef()});
        }
        if (paymentVoucher.getRemainingAmount().compareTo(BigDecimal.ZERO) < 0) {
            throw new AxelorException((Model)((Object)paymentVoucher), 5, I18n.get((String)"%s : Caution, payment entry nb %s, total line's amount imputed is higher than customer's amount paid."), new Object[]{I18n.get((String)"Warning !"), paymentVoucher.getRef()});
        }
        if (!(paymentVoucher.getHasAutoInput().booleanValue() || paymentVoucher.getPayVoucherElementToPayList() != null && paymentVoucher.getPayVoucherElementToPayList().size() != 0)) {
            throw new AxelorException((Model)((Object)paymentVoucher), 5, I18n.get((String)"%s : There's no line to pay."), new Object[]{I18n.get((String)"Warning !")});
        }
        if (journal == null || paymentModeAccount == null) {
            throw new AxelorException((Model)((Object)paymentVoucher), 4, I18n.get((String)"%s : You must add a journal and a treasury account into payment mode."), new Object[]{I18n.get((String)"Warning !")});
        }
        if (journal.getEditReceiptOk().booleanValue()) {
            this.paymentVoucherSequenceService.checkReceipt(paymentVoucher);
        }
    }

    public boolean checkIfSameAccount(List<PayVoucherElementToPay> payVoucherElementToPayList, MoveLine moveLine) {
        if (moveLine != null) {
            Account account = moveLine.getAccount();
            for (PayVoucherElementToPay payVoucherElementToPay : payVoucherElementToPayList) {
                if (payVoucherElementToPay.getMoveLine().getAccount().equals((Object)account)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

