/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.payment.paymentvoucher;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.Invoice;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.PayVoucherDueElement;
import com.axelor.apps.account.db.PayVoucherElementToPay;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.db.repo.MoveLineRepository;
import com.axelor.apps.account.db.repo.PayVoucherDueElementRepository;
import com.axelor.apps.account.db.repo.PaymentVoucherRepository;
import com.axelor.apps.account.service.payment.paymentvoucher.PaymentVoucherToolService;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.apps.base.service.CurrencyService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PaymentVoucherLoadService {
    protected CurrencyService currencyService;
    protected PaymentVoucherToolService paymentVoucherToolService;
    protected PayVoucherDueElementRepository payVoucherDueElementRepo;
    protected PaymentVoucherRepository paymentVoucherRepository;

    @Inject
    public PaymentVoucherLoadService(CurrencyService currencyService, PaymentVoucherToolService paymentVoucherToolService, PayVoucherDueElementRepository payVoucherDueElementRepo, PaymentVoucherRepository paymentVoucherRepository) {
        this.currencyService = currencyService;
        this.paymentVoucherToolService = paymentVoucherToolService;
        this.payVoucherDueElementRepo = payVoucherDueElementRepo;
        this.paymentVoucherRepository = paymentVoucherRepository;
    }

    public List<MoveLine> getMoveLines(PaymentVoucher paymentVoucher) throws AxelorException {
        MoveLineRepository moveLineRepo = (MoveLineRepository)((Object)Beans.get(MoveLineRepository.class));
        List moveLines = null;
        String query = "self.partner = ?1 and self.account.useForPartnerBalance = 't' and self.amountRemaining > 0 and (self.move.statusSelect = ?3 OR self.move.statusSelect = ?4)and self.move.ignoreInDebtRecoveryOk = 'f' and self.move.company = ?2 and self.move.invoice.pfpValidateStatusSelect != ?5";
        query = this.paymentVoucherToolService.isDebitToPay(paymentVoucher) ? query + " and self.debit > 0 " : query + " and self.credit > 0 ";
        moveLines = moveLineRepo.all().filter(query, new Object[]{paymentVoucher.getPartner(), paymentVoucher.getCompany(), 3, 2, 3}).fetch();
        return moveLines;
    }

    @Transactional(rollbackOn={Exception.class})
    public void searchDueElements(PaymentVoucher paymentVoucher) throws AxelorException {
        if (paymentVoucher.getPayVoucherElementToPayList() != null) {
            paymentVoucher.getPayVoucherElementToPayList().clear();
        }
        if (paymentVoucher.getPayVoucherDueElementList() != null) {
            paymentVoucher.getPayVoucherDueElementList().clear();
        }
        for (MoveLine moveLine : this.getMoveLines(paymentVoucher)) {
            paymentVoucher.addPayVoucherDueElementListItem(this.createPayVoucherDueElement(moveLine));
        }
        this.paymentVoucherRepository.save((Model)((Object)paymentVoucher));
    }

    public PayVoucherDueElement createPayVoucherDueElement(MoveLine moveLine) throws AxelorException {
        Move move = moveLine.getMove();
        PayVoucherDueElement payVoucherDueElement = new PayVoucherDueElement();
        payVoucherDueElement.setMoveLine(moveLine);
        payVoucherDueElement.setDueAmount(moveLine.getCurrencyAmount());
        BigDecimal paidAmountInElementCurrency = this.currencyService.getAmountCurrencyConvertedAtDate(move.getCompanyCurrency(), move.getCurrency(), moveLine.getAmountPaid(), moveLine.getDate()).setScale(2, RoundingMode.HALF_EVEN);
        payVoucherDueElement.setPaidAmount(paidAmountInElementCurrency);
        payVoucherDueElement.setAmountRemaining(payVoucherDueElement.getDueAmount().subtract(payVoucherDueElement.getPaidAmount()));
        payVoucherDueElement.setCurrency(move.getCurrency());
        return payVoucherDueElement;
    }

    @Transactional(rollbackOn={Exception.class})
    public void loadSelectedLines(PaymentVoucher paymentVoucher, PaymentVoucher paymentVoucherContext) throws AxelorException {
        if (paymentVoucherContext.getPayVoucherElementToPayList() != null) {
            if (paymentVoucherContext.getPaidAmount() == null) {
                throw new AxelorException((Model)((Object)paymentVoucher), 1, I18n.get((String)"%s : You must add an amount paid."), new Object[]{I18n.get((String)"Warning !")});
            }
            paymentVoucher.setPaidAmount(paymentVoucherContext.getPaidAmount());
            this.completeElementToPay(paymentVoucher, paymentVoucherContext);
        }
        paymentVoucher.setPaidAmount(paymentVoucherContext.getPaidAmount());
        this.paymentVoucherRepository.save((Model)((Object)paymentVoucher));
    }

    public void completeElementToPay(PaymentVoucher paymentVoucher, PaymentVoucher paymentVoucherContext) throws AxelorException {
        int sequence = paymentVoucher.getPayVoucherElementToPayList().size() + 1;
        for (PayVoucherDueElement payVoucherDueElementContext : paymentVoucherContext.getPayVoucherDueElementList()) {
            PayVoucherDueElement payVoucherDueElement = (PayVoucherDueElement)((Object)this.payVoucherDueElementRepo.find(payVoucherDueElementContext.getId()));
            if (!payVoucherDueElementContext.isSelected()) continue;
            paymentVoucher.addPayVoucherElementToPayListItem(this.createPayVoucherElementToPay(payVoucherDueElement, sequence++));
            paymentVoucher.removePayVoucherDueElementListItem(payVoucherDueElement);
        }
    }

    public PayVoucherElementToPay createPayVoucherElementToPay(PayVoucherDueElement payVoucherDueElement, int sequence) throws AxelorException {
        PaymentVoucher paymentVoucher = payVoucherDueElement.getPaymentVoucher();
        BigDecimal amountRemaining = paymentVoucher.getRemainingAmount();
        LocalDate paymentDate = paymentVoucher.getPaymentDate();
        PayVoucherElementToPay payVoucherElementToPay = new PayVoucherElementToPay();
        payVoucherElementToPay.setSequence(sequence);
        payVoucherElementToPay.setMoveLine(payVoucherDueElement.getMoveLine());
        payVoucherElementToPay.setTotalAmount(payVoucherDueElement.getDueAmount());
        payVoucherElementToPay.setRemainingAmount(payVoucherDueElement.getAmountRemaining());
        payVoucherElementToPay.setCurrency(payVoucherDueElement.getCurrency());
        BigDecimal amountRemainingInElementCurrency = this.currencyService.getAmountCurrencyConvertedAtDate(paymentVoucher.getCurrency(), payVoucherElementToPay.getCurrency(), amountRemaining, paymentDate).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal amountImputedInElementCurrency = amountRemainingInElementCurrency.min(payVoucherElementToPay.getRemainingAmount());
        BigDecimal amountImputedInPayVouchCurrency = this.currencyService.getAmountCurrencyConvertedAtDate(payVoucherElementToPay.getCurrency(), paymentVoucher.getCurrency(), amountImputedInElementCurrency, paymentDate).setScale(2, RoundingMode.HALF_EVEN);
        payVoucherElementToPay.setAmountToPay(amountImputedInElementCurrency);
        payVoucherElementToPay.setAmountToPayCurrency(amountImputedInPayVouchCurrency);
        payVoucherElementToPay.setRemainingAmountAfterPayment(payVoucherElementToPay.getRemainingAmount().subtract(amountImputedInElementCurrency));
        return payVoucherElementToPay;
    }

    @Transactional(rollbackOn={Exception.class})
    public void resetImputation(PaymentVoucher paymentVoucher) throws AxelorException {
        paymentVoucher.getPayVoucherElementToPayList().clear();
        this.searchDueElements(paymentVoucher);
    }

    public boolean checkIfSameAccount(List<PayVoucherElementToPay> payVoucherElementToPayList, MoveLine moveLine) {
        if (moveLine != null) {
            Account account = moveLine.getAccount();
            for (PayVoucherElementToPay payVoucherElementToPay : payVoucherElementToPayList) {
                if (payVoucherElementToPay.getMoveLine().getAccount().equals((Object)account)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean mustBeBalanced(MoveLine moveLineToPay, PaymentVoucher paymentVoucher, BigDecimal amountToPay) {
        Invoice invoice = moveLineToPay.getMove().getInvoice();
        Currency invoiceCurrency = invoice.getCurrency();
        Currency paymentVoucherCurrency = paymentVoucher.getCurrency();
        return paymentVoucherCurrency.equals((Object)invoiceCurrency) && invoice.getAmountPaid().add(amountToPay).compareTo(invoice.getInTaxTotal()) == 0;
    }

    public List<MoveLine> assignMaxAmountToReconcile(List<MoveLine> moveLineInvoiceToPay, BigDecimal amountToPay) {
        ArrayList<MoveLine> debitMoveLines = new ArrayList<MoveLine>();
        if (moveLineInvoiceToPay != null && moveLineInvoiceToPay.size() != 0) {
            BigDecimal maxAmountToPayRemaining = amountToPay;
            for (MoveLine moveLine : moveLineInvoiceToPay) {
                if (maxAmountToPayRemaining.compareTo(BigDecimal.ZERO) <= 0) continue;
                BigDecimal amountPay = maxAmountToPayRemaining.min(moveLine.getAmountRemaining());
                moveLine.setMaxAmountToReconcile(amountPay);
                debitMoveLines.add(moveLine);
                maxAmountToPayRemaining = maxAmountToPayRemaining.subtract(amountPay);
            }
        }
        return debitMoveLines;
    }

    public void initFromInvoice(PaymentVoucher paymentVoucher, Invoice invoice) throws AxelorException {
        PayVoucherDueElement payVoucherDueElement;
        paymentVoucher.setOperationTypeSelect(invoice.getOperationTypeSelect());
        paymentVoucher.setPartner(invoice.getPartner());
        paymentVoucher.setPaymentMode(invoice.getPaymentMode());
        paymentVoucher.setCurrency(invoice.getCurrency());
        paymentVoucher.clearPayVoucherDueElementList();
        paymentVoucher.clearPayVoucherElementToPayList();
        paymentVoucher.setCompany(invoice.getCompany());
        BankDetails companyBankDetails = invoice.getCompanyBankDetails() != null ? invoice.getCompanyBankDetails() : ((BankDetailsService)Beans.get(BankDetailsService.class)).getDefaultCompanyBankDetails(invoice.getCompany(), invoice.getPaymentMode(), invoice.getPartner(), null);
        paymentVoucher.setCompanyBankDetails(companyBankDetails);
        BigDecimal amount = BigDecimal.ZERO;
        List<MoveLine> moveLineList = this.getMoveLines(paymentVoucher);
        for (MoveLine moveLine : moveLineList) {
            payVoucherDueElement = this.createPayVoucherDueElement(moveLine);
            paymentVoucher.addPayVoucherDueElementListItem(payVoucherDueElement);
            if (!invoice.equals((Object)payVoucherDueElement.getMoveLine().getMove().getInvoice())) continue;
            amount = amount.add(payVoucherDueElement.getAmountRemaining());
        }
        paymentVoucher.setPaidAmount(amount);
        paymentVoucher.clearPayVoucherDueElementList();
        for (MoveLine moveLine : moveLineList) {
            paymentVoucher.addPayVoucherDueElementListItem(this.createPayVoucherDueElement(moveLine));
        }
        if (paymentVoucher.getPayVoucherDueElementList() == null) {
            return;
        }
        int sequence = 0;
        Iterator<PayVoucherDueElement> it = paymentVoucher.getPayVoucherDueElementList().iterator();
        while (it.hasNext()) {
            payVoucherDueElement = it.next();
            if (!invoice.equals((Object)payVoucherDueElement.getMoveLine().getMove().getInvoice()) || !paymentVoucher.getCurrency().equals((Object)payVoucherDueElement.getCurrency())) continue;
            paymentVoucher.addPayVoucherElementToPayListItem(this.createPayVoucherElementToPay(payVoucherDueElement, ++sequence));
            it.remove();
        }
    }
}

