/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.service.payment.paymentvoucher;

import com.axelor.apps.account.db.Journal;
import com.axelor.apps.account.db.PaymentMode;
import com.axelor.apps.account.db.PaymentVoucher;
import com.axelor.apps.account.service.payment.PaymentModeService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.common.base.Strings;
import com.google.inject.Inject;

public class PaymentVoucherSequenceService {
    protected SequenceService sequenceService;
    protected PaymentModeService paymentModeService;

    @Inject
    public PaymentVoucherSequenceService(SequenceService sequenceService, PaymentModeService paymentModeService) {
        this.sequenceService = sequenceService;
        this.paymentModeService = paymentModeService;
    }

    public void setReference(PaymentVoucher paymentVoucher) throws AxelorException {
        if (Strings.isNullOrEmpty((String)paymentVoucher.getRef())) {
            paymentVoucher.setRef(this.getReference(paymentVoucher));
        }
    }

    public String getReference(PaymentVoucher paymentVoucher) throws AxelorException {
        PaymentMode paymentMode = paymentVoucher.getPaymentMode();
        Company company = paymentVoucher.getCompany();
        return this.sequenceService.getSequenceNumber(this.paymentModeService.getPaymentModeSequence(paymentMode, company, paymentVoucher.getCompanyBankDetails()));
    }

    public void setReceiptNo(PaymentVoucher paymentVoucher, Company company, Journal journal) {
        if (journal.getEditReceiptOk().booleanValue()) {
            paymentVoucher.setReceiptNo(this.getReceiptNo(paymentVoucher, company, journal));
        }
    }

    public String getReceiptNo(PaymentVoucher paymentVoucher, Company company, Journal journal) {
        return this.sequenceService.getSequenceNumber("paymentVoucherReceiptNo", company);
    }

    public void checkReceipt(PaymentVoucher paymentVoucher) throws AxelorException {
        Company company = paymentVoucher.getCompany();
        if (!this.sequenceService.hasSequence("paymentVoucherReceiptNo", company)) {
            throw new AxelorException((Model)((Object)paymentVoucher), 4, I18n.get((String)"%s : You must configure a receipt number (Payment entry) for the company %s"), new Object[]{I18n.get((String)"Warning !"), company.getName()});
        }
    }
}

