/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.AccountChart;
import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.repo.AccountChartRepository;
import com.axelor.apps.account.db.repo.AccountConfigRepository;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.service.AccountChartService;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
public class AccountChartController {
    public void installChart(ActionRequest request, ActionResponse response) throws AxelorException {
        AccountConfig accountConfig = (AccountConfig)((Object)request.getContext().asType(AccountConfig.class));
        AccountChart act = (AccountChart)((Object)((AccountChartRepository)((Object)Beans.get(AccountChartRepository.class))).find(accountConfig.getAccountChart().getId()));
        Company company = (Company)((Object)((CompanyRepository)((Object)Beans.get(CompanyRepository.class))).find(accountConfig.getCompany().getId()));
        accountConfig = (AccountConfig)((Object)((AccountConfigRepository)((Object)Beans.get(AccountConfigRepository.class))).find(accountConfig.getId()));
        List accountList = ((AccountRepository)((Object)Beans.get(AccountRepository.class))).all().filter("self.company.id = ?1 AND self.parentAccount != null", new Object[]{company.getId()}).fetch();
        if (accountList.isEmpty()) {
            if (((AccountChartService)Beans.get(AccountChartService.class)).installAccountChart(act, company, accountConfig).booleanValue()) {
                response.setFlash(I18n.get((String)"The chart of account has been loaded successfully"));
            } else {
                response.setFlash(I18n.get((String)"Error in account chart import please check the log"));
            }
            response.setReload(true);
        } else {
            response.setFlash(I18n.get((String)"A chart or chart structure of accounts already exists, please delete the hierarchy between accounts in order to import a new chart."));
        }
    }
}

