/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.repo.AccountRepository;
import com.axelor.apps.account.service.AccountService;
import com.axelor.common.ObjectUtils;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.math.BigDecimal;
import java.util.List;

@Singleton
public class AccountController {
    public void computeBalance(ActionRequest request, ActionResponse response) {
        try {
            Account account = (Account)((Object)request.getContext().asType(Account.class));
            if (account.getId() == null) {
                return;
            }
            account = (Account)((Object)((AccountRepository)((Object)Beans.get(AccountRepository.class))).find(account.getId()));
            BigDecimal balance = ((AccountService)Beans.get(AccountService.class)).computeBalance(account, AccountService.BALANCE_TYPE_DEBIT_BALANCE);
            if (balance.compareTo(BigDecimal.ZERO) >= 0) {
                response.setAttr("$balanceBtn", "title", (Object)I18n.get((String)"Debit balance"));
            } else {
                balance = balance.multiply(new BigDecimal(-1));
                response.setAttr("$balanceBtn", "title", (Object)I18n.get((String)"Credit balance"));
            }
            response.setValue("$balanceBtn", (Object)balance);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkIfCodeAccountAlreadyExistForCompany(ActionRequest request, ActionResponse response) {
        try {
            List sameAccountList;
            Account account = (Account)((Object)request.getContext().asType(Account.class));
            Long accountId = account.getId();
            if (accountId == null) {
                accountId = 0L;
            }
            if (!ObjectUtils.isEmpty((Object)(sameAccountList = ((AccountRepository)((Object)Beans.get(AccountRepository.class))).all().filter("self.company = ?1 AND self.code = ?2 AND self.id != ?3", new Object[]{account.getCompany(), account.getCode(), accountId}).fetch()))) {
                throw new AxelorException(4, I18n.get((String)"The account code %s is already used for the company %s, there cannot be two accounts with the same code for the same company."), new Object[]{account.getCode(), account.getCompany().getName()});
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

