/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.AccountingBatch;
import com.axelor.apps.account.db.repo.AccountingBatchRepository;
import com.axelor.apps.account.service.batch.AccountingBatchService;
import com.axelor.apps.base.db.Batch;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.util.HashMap;

@Singleton
public class AccountingBatchController {
    public void actionDebtRecovery(ActionRequest request, ActionResponse response) {
        AccountingBatch accountingBatch = (AccountingBatch)((Object)request.getContext().asType(AccountingBatch.class));
        Batch batch = null;
        if (accountingBatch.getActionSelect() == 14) {
            batch = ((AccountingBatchService)((Object)Beans.get(AccountingBatchService.class))).debtRecovery((AccountingBatch)((Object)((AccountingBatchRepository)((Object)Beans.get(AccountingBatchRepository.class))).find(accountingBatch.getId())));
        }
        if (batch != null) {
            response.setFlash(batch.getComments());
        }
        response.setReload(true);
    }

    public void actionDoubtfulCustomer(ActionRequest request, ActionResponse response) {
        AccountingBatch accountingBatch = (AccountingBatch)((Object)request.getContext().asType(AccountingBatch.class));
        Batch batch = null;
        batch = ((AccountingBatchService)((Object)Beans.get(AccountingBatchService.class))).doubtfulCustomer((AccountingBatch)((Object)((AccountingBatchRepository)((Object)Beans.get(AccountingBatchRepository.class))).find(accountingBatch.getId())));
        if (batch != null) {
            response.setFlash(batch.getComments());
        }
        response.setReload(true);
    }

    public void actionReimbursement(ActionRequest request, ActionResponse response) {
        AccountingBatch accountingBatch = (AccountingBatch)((Object)request.getContext().asType(AccountingBatch.class));
        AccountingBatchService accountingBatchService = (AccountingBatchService)((Object)Beans.get(AccountingBatchService.class));
        AccountingBatchRepository accountingBatchRepository = (AccountingBatchRepository)((Object)Beans.get(AccountingBatchRepository.class));
        Batch batch = null;
        if (accountingBatch.getReimbursementTypeSelect() == 1) {
            batch = accountingBatchService.reimbursementExport((AccountingBatch)((Object)accountingBatchRepository.find(accountingBatch.getId())));
        } else if (accountingBatch.getReimbursementTypeSelect() == 2) {
            batch = accountingBatchService.reimbursementImport((AccountingBatch)((Object)accountingBatchRepository.find(accountingBatch.getId())));
        }
        if (batch != null) {
            response.setFlash(batch.getComments());
        }
        response.setReload(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionDirectDebit(ActionRequest request, ActionResponse response) {
        try {
            AccountingBatch accountingBatch = (AccountingBatch)((Object)request.getContext().asType(AccountingBatch.class));
            accountingBatch = (AccountingBatch)((Object)((AccountingBatchRepository)((Object)Beans.get(AccountingBatchRepository.class))).find(accountingBatch.getId()));
            Batch batch = ((AccountingBatchService)((Object)Beans.get(AccountingBatchService.class))).directDebit(accountingBatch);
            response.setFlash(batch.getComments());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
        finally {
            response.setReload(true);
        }
    }

    public void actionAccountingCustomer(ActionRequest request, ActionResponse response) {
        AccountingBatch accountingBatch = (AccountingBatch)((Object)request.getContext().asType(AccountingBatch.class));
        Batch batch = null;
        batch = ((AccountingBatchService)((Object)Beans.get(AccountingBatchService.class))).accountCustomer((AccountingBatch)((Object)((AccountingBatchRepository)((Object)Beans.get(AccountingBatchRepository.class))).find(accountingBatch.getId())));
        if (batch != null) {
            response.setFlash(batch.getComments());
        }
        response.setReload(true);
    }

    public void actionMoveLineExport(ActionRequest request, ActionResponse response) {
        AccountingBatch accountingBatch = (AccountingBatch)((Object)request.getContext().asType(AccountingBatch.class));
        Batch batch = null;
        batch = ((AccountingBatchService)((Object)Beans.get(AccountingBatchService.class))).moveLineExport((AccountingBatch)((Object)((AccountingBatchRepository)((Object)Beans.get(AccountingBatchRepository.class))).find(accountingBatch.getId())));
        if (batch != null) {
            response.setFlash(batch.getComments());
        }
        response.setReload(true);
    }

    public void actionCreditTransfer(ActionRequest request, ActionResponse response) {
        AccountingBatch accountingBatch = (AccountingBatch)((Object)request.getContext().asType(AccountingBatch.class));
        accountingBatch = (AccountingBatch)((Object)((AccountingBatchRepository)((Object)Beans.get(AccountingBatchRepository.class))).find(accountingBatch.getId()));
        Batch batch = ((AccountingBatchService)((Object)Beans.get(AccountingBatchService.class))).creditTransfer(accountingBatch);
        response.setFlash(batch.getComments());
        response.setReload(true);
    }

    public void actionRealizeFixedAssetLines(ActionRequest request, ActionResponse response) {
        AccountingBatch accountingBatch = (AccountingBatch)((Object)request.getContext().asType(AccountingBatch.class));
        accountingBatch = (AccountingBatch)((Object)((AccountingBatchRepository)((Object)Beans.get(AccountingBatchRepository.class))).find(accountingBatch.getId()));
        Batch batch = ((AccountingBatchService)((Object)Beans.get(AccountingBatchService.class))).realizeFixedAssetLines(accountingBatch);
        if (batch != null) {
            response.setFlash(batch.getComments());
        }
        response.setReload(true);
    }

    public void actionCloseAnnualAccounts(ActionRequest request, ActionResponse response) {
        AccountingBatch accountingBatch = (AccountingBatch)((Object)request.getContext().asType(AccountingBatch.class));
        accountingBatch = (AccountingBatch)((Object)((AccountingBatchRepository)((Object)Beans.get(AccountingBatchRepository.class))).find(accountingBatch.getId()));
        Batch batch = ((AccountingBatchService)((Object)Beans.get(AccountingBatchService.class))).closeAnnualAccounts(accountingBatch);
        if (batch != null) {
            response.setFlash(batch.getComments());
        }
        response.setReload(true);
    }

    public void run(ActionRequest request, ActionResponse response) throws AxelorException {
        Batch batch = ((AccountingBatchService)((Object)Beans.get(AccountingBatchService.class))).run((String)request.getContext().get((Object)"code"));
        HashMap<String, Integer> mapData = new HashMap<String, Integer>();
        mapData.put("anomaly", batch.getAnomaly());
        response.setData(mapData);
    }
}

