/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountingReport;
import com.axelor.apps.account.db.JournalType;
import com.axelor.apps.account.db.Move;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.account.db.repo.AccountingReportRepository;
import com.axelor.apps.account.service.AccountingReportService;
import com.axelor.apps.account.service.MoveLineExportService;
import com.axelor.apps.base.db.App;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaStore;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AccountingReportController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void searchMoveLine(ActionRequest request, ActionResponse response) {
        AccountingReport accountingReport = (AccountingReport)((Object)request.getContext().asType(AccountingReport.class));
        AccountingReportService accountingReportService = (AccountingReportService)Beans.get(AccountingReportService.class);
        try {
            accountingReport = (AccountingReport)((Object)((AccountingReportRepository)((Object)Beans.get(AccountingReportRepository.class))).find(accountingReport.getId()));
            String query = accountingReportService.getMoveLineList(accountingReport);
            BigDecimal debitBalance = accountingReportService.getDebitBalance();
            BigDecimal creditBalance = accountingReportService.getCreditBalance();
            response.setValue("totalDebit", (Object)debitBalance);
            response.setValue("totalCredit", (Object)creditBalance);
            response.setValue("balance", (Object)debitBalance.subtract(creditBalance));
            ActionView.ActionViewBuilder actionViewBuilder = ActionView.define((String)I18n.get((String)"Move lines recovered"));
            actionViewBuilder.model(MoveLine.class.getName());
            actionViewBuilder.add("grid", "move-line-grid");
            actionViewBuilder.add("form", "move-line-form");
            actionViewBuilder.param("search-filters", "move-line-filters");
            actionViewBuilder.domain(query);
            response.setView(actionViewBuilder.map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getJournalType(ActionRequest request, ActionResponse response) {
        AccountingReport accountingReport = (AccountingReport)((Object)request.getContext().asType(AccountingReport.class));
        try {
            JournalType journalType = ((AccountingReportService)Beans.get(AccountingReportService.class)).getJournalType(accountingReport);
            if (journalType != null) {
                String domainQuery = "self.journalType.id = " + journalType.getId();
                response.setAttr("journal", "domain", (Object)domainQuery);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getAccount(ActionRequest request, ActionResponse response) {
        AccountingReport accountingReport = (AccountingReport)((Object)request.getContext().asType(AccountingReport.class));
        try {
            Account account = ((AccountingReportService)Beans.get(AccountingReportService.class)).getAccount(accountingReport);
            this.logger.debug("Compte : {}", (Object)account);
            response.setValue("account", (Object)account);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void getReload(ActionRequest request, ActionResponse response) {
        response.setReload(true);
    }

    public void replayExport(ActionRequest request, ActionResponse response) {
        AccountingReport accountingReport = (AccountingReport)((Object)request.getContext().asType(AccountingReport.class));
        accountingReport = (AccountingReport)((Object)((AccountingReportRepository)((Object)Beans.get(AccountingReportRepository.class))).find(accountingReport.getId()));
        MoveLineExportService moveLineExportService = (MoveLineExportService)Beans.get(MoveLineExportService.class);
        try {
            moveLineExportService.replayExportMoveLine(accountingReport);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void printExportMoveLine(ActionRequest request, ActionResponse response) {
        AccountingReport accountingReport = (AccountingReport)((Object)request.getContext().asType(AccountingReport.class));
        accountingReport = (AccountingReport)((Object)((AccountingReportRepository)((Object)Beans.get(AccountingReportRepository.class))).find(accountingReport.getId()));
        AccountingReportService accountingReportService = (AccountingReportService)Beans.get(AccountingReportService.class);
        try {
            int typeSelect = accountingReport.getTypeSelect();
            if (accountingReport.getExportTypeSelect() == null || accountingReport.getExportTypeSelect().isEmpty() || accountingReport.getTypeSelect() == 0) {
                response.setFlash(I18n.get((String)"You must select an export type"));
                response.setReload(true);
                return;
            }
            if (accountingReportService.isThereTooManyLines(accountingReport)) {
                response.setAlert(I18n.get((String)"A large number of recording has been fetched in this period. Edition can take a while. Do you want to proceed ?"));
            }
            this.logger.debug("Type selected : {}", (Object)typeSelect);
            if (typeSelect >= 1000 && typeSelect < 2000) {
                MoveLineExportService moveLineExportService = (MoveLineExportService)Beans.get(MoveLineExportService.class);
                MetaFile accesssFile = moveLineExportService.exportMoveLine(accountingReport);
                if (typeSelect == 1000 && accesssFile != null) {
                    response.setView(ActionView.define((String)I18n.get((String)"Export file")).model(App.class.getName()).add("html", "ws/rest/com.axelor.meta.db.MetaFile/" + accesssFile.getId() + "/content/download?v=" + accesssFile.getVersion()).param("download", "true").map());
                }
            } else {
                accountingReportService.setPublicationDateTime(accountingReport);
                String name = I18n.get((String)MetaStore.getSelectionItem((String)"accounting.report.type.select", (String)accountingReport.getTypeSelect().toString()).getTitle()) + " " + accountingReport.getRef();
                String fileLink = accountingReportService.getReportFileLink(accountingReport, name);
                this.logger.debug("Printing " + name);
                response.setView(ActionView.define((String)name).add("html", fileLink).map());
                accountingReportService.setStatus(accountingReport);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showMoveExported(ActionRequest request, ActionResponse response) {
        AccountingReport accountingReport = (AccountingReport)((Object)request.getContext().asType(AccountingReport.class));
        ActionView.ActionViewBuilder actionViewBuilder = ActionView.define((String)I18n.get((String)"Moves exported"));
        actionViewBuilder.model(Move.class.getName());
        actionViewBuilder.add("grid", "move-grid");
        actionViewBuilder.param("search-filters", "move-filters");
        actionViewBuilder.domain("self.accountingReport.id = :_accountingReportId");
        actionViewBuilder.context("_accountingReportId", (Object)accountingReport.getId());
        response.setView(actionViewBuilder.map());
    }
}

