/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.AccountConfig;
import com.axelor.apps.account.db.AccountingSituation;
import com.axelor.apps.account.db.DebtRecovery;
import com.axelor.apps.account.service.AccountingSituationService;
import com.axelor.apps.account.service.config.AccountConfigService;
import com.axelor.apps.base.db.Company;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class AccountingSituationController {
    public void createInBankDetailsDomain(ActionRequest request, ActionResponse response) {
        AccountingSituation accountingSituation = (AccountingSituation)((Object)request.getContext().asType(AccountingSituation.class));
        String domain = ((AccountingSituationService)Beans.get(AccountingSituationService.class)).createDomainForBankDetails(accountingSituation, true);
        if (!domain.equals("")) {
            response.setAttr("companyInBankDetails", "domain", (Object)domain);
        } else {
            response.setAttr("companyInBankDetails", "domain", (Object)"self.id in (0)");
        }
    }

    public void createOutBankDetailsDomain(ActionRequest request, ActionResponse response) {
        AccountingSituation accountingSituation = (AccountingSituation)((Object)request.getContext().asType(AccountingSituation.class));
        String domain = ((AccountingSituationService)Beans.get(AccountingSituationService.class)).createDomainForBankDetails(accountingSituation, false);
        if (!domain.equals("")) {
            response.setAttr("companyOutBankDetails", "domain", (Object)domain);
        } else {
            response.setAttr("companyOutBankDetails", "domain", (Object)"self.id in (0)");
        }
    }

    public void setDefaultMail(ActionRequest request, ActionResponse response) throws AxelorException {
        AccountingSituation accountingSituation = (AccountingSituation)((Object)request.getContext().asType(AccountingSituation.class));
        Company company = accountingSituation.getCompany();
        if (company != null) {
            AccountConfig accountConfig = ((AccountConfigService)Beans.get(AccountConfigService.class)).getAccountConfig(company);
            response.setValue("invoiceAutomaticMail", (Object)accountConfig.getInvoiceAutomaticMail());
            response.setValue("invoiceMessageTemplate", (Object)accountConfig.getInvoiceMessageTemplate());
        }
    }

    public void openDebtRecovery(ActionRequest request, ActionResponse response) {
        AccountingSituation accountingSituation = (AccountingSituation)((Object)request.getContext().asType(AccountingSituation.class));
        DebtRecovery debtRecovery = accountingSituation.getDebtRecovery();
        if (debtRecovery != null) {
            response.setView(ActionView.define((String)I18n.get((String)"Debt Recovery")).model(DebtRecovery.class.getName()).add("grid", "debt-recovery-grid").add("form", "debt-recovery-form").param("forceEdit", "true").context("_showRecord", (Object)debtRecovery.getId()).map());
            response.setCanClose(true);
        }
    }
}

