/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.account.db.AssistantReportInvoice;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AssistantReportInvoiceController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final DateTimeFormatter dtFormater = DateTimeFormatter.ofPattern("dd/MM/yyyy");

    public void printSales(ActionRequest request, ActionResponse response) throws AxelorException {
        AssistantReportInvoice assistant = (AssistantReportInvoice)((Object)request.getContext().asType(AssistantReportInvoice.class));
        String name = I18n.get((String)"SaleInvoicesDetails-") + this.getDateString(assistant);
        String fileLink = ReportFactory.createReport((String)"SaleInvoicesDetails.rptdesign", (String)(name + "-${date}")).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("Timezone", assistant.getCompany() != null ? assistant.getCompany().getTimezone() : null).addParam("assistantId", (Object)assistant.getId()).addParam("companyId", (Object)assistant.getCompany().getId()).addParam("graphType", (Object)assistant.getGraphTypeSelect().toString()).addParam("turnoverTypeSelect", (Object)assistant.getTurnoverTypeSelect()).addFormat(assistant.getFormatSelect()).generate().getFileLink();
        this.logger.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    private String getDateString(AssistantReportInvoice assistant) {
        return assistant.getFromDate().format(dtFormater) + assistant.getToDate().format(dtFormater);
    }

    public void printPurchases(ActionRequest request, ActionResponse response) throws AxelorException {
        AssistantReportInvoice assistant = (AssistantReportInvoice)((Object)request.getContext().asType(AssistantReportInvoice.class));
        String name = I18n.get((String)"PurchaseInvoicesDetails-") + this.getDateString(assistant);
        String fileLink = ReportFactory.createReport((String)"PurchaseInvoicesDetails.rptdesign", (String)(name + "-${date}")).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("Timezone", assistant.getCompany() != null ? assistant.getCompany().getTimezone() : null).addParam("assistantId", (Object)assistant.getId()).addParam("companyId", (Object)assistant.getCompany().getId()).addParam("partnersIds", (Object)Joiner.on((String)",").join(assistant.getPartnerSet())).addParam("productsIds", (Object)Joiner.on((String)",").join(assistant.getProductSet())).addParam("productCategoriesIds", (Object)Joiner.on((String)",").join(assistant.getProductCategorySet())).addParam("graphType", (Object)assistant.getGraphTypeSelect().toString()).addFormat(assistant.getFormatSelect()).generate().getFileLink();
        this.logger.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }
}

