/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.web;

import com.axelor.apps.account.db.Budget;
import com.axelor.apps.account.db.BudgetLine;
import com.axelor.apps.account.db.repo.BudgetRepository;
import com.axelor.apps.account.service.BudgetService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
public class BudgetController {
    public void compute(ActionRequest request, ActionResponse response) {
        try {
            Budget budget = (Budget)((Object)request.getContext().asType(Budget.class));
            response.setValue("totalAmountExpected", (Object)((BudgetService)Beans.get(BudgetService.class)).compute(budget));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updateLines(ActionRequest request, ActionResponse response) {
        try {
            Budget budget = (Budget)((Object)request.getContext().asType(Budget.class));
            budget = (Budget)((Object)((BudgetRepository)((Object)Beans.get(BudgetRepository.class))).find(budget.getId()));
            List<BudgetLine> budgetLineList = ((BudgetService)Beans.get(BudgetService.class)).updateLines(budget);
            response.setValue("budgetLineList", budgetLineList);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void generatePeriods(ActionRequest request, ActionResponse response) {
        try {
            Budget budget = (Budget)((Object)request.getContext().asType(Budget.class));
            response.setValue("budgetLineList", ((BudgetService)Beans.get(BudgetService.class)).generatePeriods(budget));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkSharedDates(ActionRequest request, ActionResponse response) {
        try {
            Budget budget = (Budget)((Object)request.getContext().asType(Budget.class));
            ((BudgetService)Beans.get(BudgetService.class)).checkSharedDates(budget);
        }
        catch (Exception e) {
            response.setError(e.getMessage());
        }
    }

    public void validate(ActionRequest request, ActionResponse response) {
        try {
            Budget budget = (Budget)((Object)request.getContext().asType(Budget.class));
            budget = (Budget)((Object)((BudgetRepository)((Object)Beans.get(BudgetRepository.class))).find(budget.getId()));
            ((BudgetService)Beans.get(BudgetService.class)).validate(budget);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void draft(ActionRequest request, ActionResponse response) {
        try {
            Budget budget = (Budget)((Object)request.getContext().asType(Budget.class));
            budget = (Budget)((Object)((BudgetRepository)((Object)Beans.get(BudgetRepository.class))).find(budget.getId()));
            ((BudgetService)Beans.get(BudgetService.class)).draft(budget);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeTotalAmountRealized(ActionRequest request, ActionResponse response) {
        try {
            Budget budget = (Budget)((Object)request.getContext().asType(Budget.class));
            budget = (Budget)((Object)((BudgetRepository)((Object)Beans.get(BudgetRepository.class))).find(budget.getId()));
            response.setValue("totalAmountRealized", (Object)((BudgetService)Beans.get(BudgetService.class)).computeTotalAmountRealized(budget));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

